/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.codegen;

import com.google.common.base.Function;
import com.mysema.codegen.AbstractCodeWriter;
import com.mysema.codegen.CodegenException;
import com.mysema.codegen.StringUtils;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public final class JavaWriter
extends AbstractCodeWriter<JavaWriter> {
    private static final String EXTENDS = " extends ";
    private static final String IMPLEMENTS = " implements ";
    private static final String IMPORT = "import ";
    private static final String IMPORT_STATIC = "import static ";
    private static final String PACKAGE = "package ";
    private static final String PRIVATE = "private ";
    private static final String PRIVATE_FINAL = "private final ";
    private static final String PRIVATE_STATIC_FINAL = "private static final ";
    private static final String PROTECTED = "protected ";
    private static final String PROTECTED_FINAL = "protected final ";
    private static final String PUBLIC = "public ";
    private static final String PUBLIC_CLASS = "public class ";
    private static final String PUBLIC_FINAL = "public final ";
    private static final String PUBLIC_INTERFACE = "public interface ";
    private static final String PUBLIC_STATIC = "public static ";
    private static final String PUBLIC_STATIC_FINAL = "public static final ";
    private final Set<String> classes = new HashSet<String>();
    private final Set<String> packages = new HashSet<String>();
    private final Stack<Type> types = new Stack();

    public JavaWriter(Appendable appendable) {
        super(appendable, 4);
        this.packages.add("java.lang");
    }

    @Override
    public JavaWriter annotation(Annotation annotation) throws IOException {
        ((JavaWriter)((JavaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation.annotationType());
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        if (methods.length == 1 && methods[0].getName().equals("value")) {
            try {
                Object value = methods[0].invoke((Object)annotation, new Object[0]);
                this.append("(");
                this.annotationConstant(value);
                this.append(")");
            }
            catch (IllegalArgumentException e) {
                throw new CodegenException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodegenException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodegenException(e);
            }
        }
        boolean first = true;
        for (Method method : methods) {
            try {
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (value == null || value.equals(method.getDefaultValue()) || value.getClass().isArray() && Arrays.equals((Object[])value, (Object[])method.getDefaultValue())) continue;
                if (!first) {
                    this.append(", ");
                } else {
                    this.append("(");
                }
                this.append(method.getName() + "=");
                this.annotationConstant(value);
            }
            catch (IllegalArgumentException e) {
                throw new CodegenException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodegenException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodegenException(e);
            }
            first = false;
        }
        if (!first) {
            this.append(")");
        }
        return (JavaWriter)this.nl();
    }

    @Override
    public JavaWriter annotation(Class<? extends Annotation> annotation) throws IOException {
        return (JavaWriter)((JavaWriter)((JavaWriter)this.beginLine(new String[0])).append("@")).appendType(annotation).nl();
    }

    private void annotationConstant(Object value) throws IOException {
        if (value.getClass().isArray()) {
            this.append("{");
            boolean first = true;
            for (Object o : (Object[])value) {
                if (!first) {
                    this.append(", ");
                }
                this.annotationConstant(o);
                first = false;
            }
            this.append("}");
        } else if (value instanceof Class) {
            this.appendType((Class)value).append(".class");
        } else if (value instanceof Number || value instanceof Boolean) {
            this.append(value.toString());
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            if (this.classes.contains(enumValue.getClass().getName()) || this.packages.contains(enumValue.getClass().getPackage().getName())) {
                this.append(enumValue.name());
            } else {
                this.append(enumValue.getDeclaringClass().getName() + "." + enumValue.name());
            }
        } else if (value instanceof String) {
            String escaped = StringUtils.escapeJava(value.toString());
            this.append("\"" + escaped.replace("\\/", "/") + "\"");
        } else {
            throw new IllegalArgumentException("Unsupported annotation value : " + value);
        }
    }

    private JavaWriter appendType(Class<?> type) throws IOException {
        if (this.classes.contains(type.getName()) || this.packages.contains(type.getPackage().getName())) {
            this.append(type.getSimpleName());
        } else {
            this.append(type.getName());
        }
        return this;
    }

    @Override
    public JavaWriter beginClass(Type type) throws IOException {
        return this.beginClass(type, null, new Type[0]);
    }

    @Override
    public JavaWriter beginClass(Type type, Type superClass, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{PUBLIC_CLASS + type.getGenericName(false, this.packages, this.classes)});
        if (superClass != null) {
            this.append(EXTENDS + superClass.getGenericName(false, this.packages, this.classes));
        }
        if (interfaces.length > 0) {
            this.append(IMPLEMENTS);
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
            }
        }
        ((JavaWriter)((JavaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.types.push(type);
        return this;
    }

    @Override
    public <T> JavaWriter beginConstructor(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(new String[]{PUBLIC + this.types.peek().getSimpleName()})).params(parameters, transformer).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public JavaWriter beginConstructor(Parameter ... parameters) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(new String[]{PUBLIC + this.types.peek().getSimpleName()})).params(parameters).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public JavaWriter beginInterface(Type type, Type ... interfaces) throws IOException {
        this.packages.add(type.getPackageName());
        this.beginLine(new String[]{PUBLIC_INTERFACE + type.getGenericName(false, this.packages, this.classes)});
        if (interfaces.length > 0) {
            this.append(EXTENDS);
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    this.append(", ");
                }
                this.append(interfaces[i].getGenericName(false, this.packages, this.classes));
            }
        }
        ((JavaWriter)((JavaWriter)this.append(" {")).nl()).nl();
        this.goIn();
        this.types.push(type);
        return this;
    }

    private JavaWriter beginMethod(String modifiers, Type returnType, String methodName, Parameter ... args) throws IOException {
        this.types.push(this.types.peek());
        ((JavaWriter)((JavaWriter)this.beginLine(new String[]{modifiers + returnType.getGenericName(true, this.packages, this.classes) + " " + methodName})).params(args).append(" {")).nl();
        return (JavaWriter)this.goIn();
    }

    @Override
    public <T> JavaWriter beginPublicMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(PUBLIC, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public JavaWriter beginPublicMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(PUBLIC, returnType, methodName, args);
    }

    @Override
    public <T> JavaWriter beginStaticMethod(Type returnType, String methodName, Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        return this.beginMethod(PUBLIC_STATIC, returnType, methodName, this.transform(parameters, transformer));
    }

    @Override
    public JavaWriter beginStaticMethod(Type returnType, String methodName, Parameter ... args) throws IOException {
        return this.beginMethod(PUBLIC_STATIC, returnType, methodName, args);
    }

    @Override
    public JavaWriter end() throws IOException {
        this.types.pop();
        this.goOut();
        return (JavaWriter)((JavaWriter)this.line(new String[]{"}"})).nl();
    }

    @Override
    public JavaWriter field(Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{type.getGenericName(true, this.packages, this.classes) + " " + name + ";"})).nl();
    }

    private JavaWriter field(String modifier, Type type, String name) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{modifier + type.getGenericName(true, this.packages, this.classes) + " " + name + ";"})).nl();
    }

    private JavaWriter field(String modifier, Type type, String name, String value) throws IOException {
        return (JavaWriter)((JavaWriter)this.line(new String[]{modifier + type.getGenericName(true, this.packages, this.classes) + " " + name + " = " + value + ";"})).nl();
    }

    @Override
    public String getClassConstant(String className) {
        return className + ".class";
    }

    @Override
    public String getGenericName(boolean asArgType, Type type) {
        return type.getGenericName(asArgType, this.packages, this.classes);
    }

    @Override
    public String getRawName(Type type) {
        return type.getRawName(this.packages, this.classes);
    }

    @Override
    public JavaWriter imports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.classes.add(cl.getName());
            this.line(new String[]{IMPORT + cl.getName() + ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter imports(Package ... imports) throws IOException {
        for (Package p : imports) {
            this.packages.add(p.getName());
            this.line(new String[]{IMPORT + p.getName() + ".*;"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importClasses(String ... imports) throws IOException {
        for (String cl : imports) {
            this.classes.add(cl);
            this.line(new String[]{IMPORT + cl + ";"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter importPackages(String ... imports) throws IOException {
        for (String p : imports) {
            this.packages.add(p);
            this.line(new String[]{IMPORT + p + ".*;"});
        }
        this.nl();
        return this;
    }

    @Override
    public JavaWriter javadoc(String ... lines) throws IOException {
        this.line(new String[]{"/**"});
        for (String line : lines) {
            this.line(new String[]{" * " + line});
        }
        return (JavaWriter)this.line(new String[]{" */"});
    }

    @Override
    public JavaWriter packageDecl(String packageName) throws IOException {
        this.packages.add(packageName);
        return (JavaWriter)((JavaWriter)this.line(new String[]{PACKAGE + packageName + ";"})).nl();
    }

    private <T> JavaWriter params(Collection<T> parameters, Function<T, Parameter> transformer) throws IOException {
        this.append("(");
        boolean first = true;
        for (T param : parameters) {
            if (!first) {
                this.append(", ");
            }
            this.param((Parameter)transformer.apply(param));
            first = false;
        }
        this.append(")");
        return this;
    }

    private JavaWriter params(Parameter ... params) throws IOException {
        this.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.param(params[i]);
        }
        this.append(")");
        return this;
    }

    private JavaWriter param(Parameter parameter) throws IOException {
        this.append(parameter.getType().getGenericName(true, this.packages, this.classes));
        this.append(" ");
        this.append(parameter.getName());
        return this;
    }

    @Override
    public JavaWriter privateField(Type type, String name) throws IOException {
        return this.field(PRIVATE, type, name);
    }

    @Override
    public JavaWriter privateFinal(Type type, String name) throws IOException {
        return this.field(PRIVATE_FINAL, type, name);
    }

    @Override
    public JavaWriter privateFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_FINAL, type, name, value);
    }

    @Override
    public JavaWriter privateStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(PRIVATE_STATIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter protectedField(Type type, String name) throws IOException {
        return this.field(PROTECTED, type, name);
    }

    @Override
    public JavaWriter protectedFinal(Type type, String name) throws IOException {
        return this.field(PROTECTED_FINAL, type, name);
    }

    @Override
    public JavaWriter protectedFinal(Type type, String name, String value) throws IOException {
        return this.field(PROTECTED_FINAL, type, name, value);
    }

    @Override
    public JavaWriter publicField(Type type, String name) throws IOException {
        return this.field(PUBLIC, type, name);
    }

    @Override
    public JavaWriter publicField(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC, type, name, value);
    }

    @Override
    public JavaWriter publicFinal(Type type, String name) throws IOException {
        return this.field(PUBLIC_FINAL, type, name);
    }

    @Override
    public JavaWriter publicFinal(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter publicStaticFinal(Type type, String name, String value) throws IOException {
        return this.field(PUBLIC_STATIC_FINAL, type, name, value);
    }

    @Override
    public JavaWriter staticimports(Class<?> ... imports) throws IOException {
        for (Class<?> cl : imports) {
            this.line(new String[]{IMPORT_STATIC + cl.getName() + ".*;"});
        }
        return this;
    }

    @Override
    public JavaWriter suppressWarnings(String type) throws IOException {
        return (JavaWriter)this.line(new String[]{"@SuppressWarnings(\"" + type + "\")"});
    }

    private <T> Parameter[] transform(Collection<T> parameters, Function<T, Parameter> transformer) {
        Parameter[] rv = new Parameter[parameters.size()];
        int i = 0;
        for (T value : parameters) {
            rv[i++] = (Parameter)transformer.apply(value);
        }
        return rv;
    }
}

