/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.support;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Normalization {
    private static final String WS = "\\s*";
    private static final String NUMBER = "([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})";
    private static final Pattern FULL_OPERATION = Pattern.compile("(?<![\\d*/\"?' ])(\\b|\\(|\\s+)(([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})\\s*[+\\-/*]\\s*)+([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})\\s*(?![\\d*/\"' ])");
    private static final Pattern[] OPERATIONS = new Pattern[]{Pattern.compile("([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})\\s*([*/])\\s*([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})"), Pattern.compile("([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})\\s*([+-])\\s*([\\+\\-]?\\d+\\.?\\d*)(?!\\p{Alpha})")};

    private static String normalizeOperation(String queryString) {
        for (int i = 0; i < OPERATIONS.length; ++i) {
            Matcher matcher;
            Pattern operation = OPERATIONS[i];
            while ((matcher = operation.matcher(queryString)).find()) {
                BigDecimal result;
                char operator = matcher.group(2).charAt(0);
                BigDecimal first = new BigDecimal(matcher.group(1));
                BigDecimal second = new BigDecimal(matcher.group(3));
                switch (operator) {
                    case '*': {
                        result = first.multiply(second);
                        break;
                    }
                    case '/': {
                        result = first.divide(second, 10, RoundingMode.HALF_UP);
                        break;
                    }
                    case '+': {
                        result = first.add(second);
                        break;
                    }
                    case '-': {
                        result = first.subtract(second);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                StringBuffer buffer = new StringBuffer();
                matcher.appendReplacement(buffer, result.stripTrailingZeros().toPlainString()).appendTail(buffer);
                queryString = buffer.toString();
            }
        }
        return queryString;
    }

    public static String normalize(String queryString) {
        if (!Normalization.hasOperators(queryString)) {
            return queryString;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher m = FULL_OPERATION.matcher(queryString);
        while (m.find()) {
            String result = Normalization.normalizeOperation(queryString.substring(m.start(), m.end()));
            m.appendReplacement(buffer, result);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    private static boolean hasOperators(String queryString) {
        for (int i = 0; i < queryString.length(); ++i) {
            char ch = queryString.charAt(i);
            if (ch != '+' && ch != '-' && ch != '*' && ch != '/') continue;
            return true;
        }
        return false;
    }

    private Normalization() {
    }
}

