/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AmountType;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.IUnits;
import com.anylogic.engine.internal.hg;

public enum AmountUnits implements IUnits<AmountUnits>
{
    LITER(0.001, hg.jlh, AmountType.VOLUME),
    OIL_BARREL(0.158987295, hg.kka, AmountType.VOLUME),
    CUBIC_METER(1.0, hg.mfg, AmountType.VOLUME),
    KILOGRAM(1.0, hg.lcl, AmountType.MASS),
    TON(1000.0, hg.aai, AmountType.MASS);

    private final double a;
    private final String n;
    private final AmountType k;

    private AmountUnits(double d2, String string2, AmountType amountType) {
        this.a = d2;
        this.n = string2;
        this.k = amountType;
    }

    @Override
    public String getName() {
        return this.n;
    }

    @Override
    public double modifier(AmountUnits amountUnits) {
        return this.a / amountUnits.a;
    }

    @Override
    public double convertTo(double d2, AmountUnits amountUnits) {
        return d2 * this.modifier(amountUnits);
    }

    @AnyLogicInternalAPI
    public AmountType getAmountType() {
        return this.k;
    }
}

