/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AmountType;
import com.anylogic.engine.AmountUnits;
import com.anylogic.engine.IUnits;
import com.anylogic.engine.TimeUnits;
import com.anylogic.engine.internal.hg;

public enum FlowRateUnits implements IUnits<FlowRateUnits>
{
    LITER_PER_SECOND(AmountUnits.LITER, TimeUnits.SECOND, hg.nia),
    OIL_BARREL_PER_SECOND(AmountUnits.OIL_BARREL, TimeUnits.SECOND, hg.ecm),
    CUBIC_METER_PER_SECOND(AmountUnits.CUBIC_METER, TimeUnits.SECOND, hg.dgl),
    KILOGRAM_PER_SECOND(AmountUnits.KILOGRAM, TimeUnits.SECOND, hg.bak),
    TON_PER_SECOND(AmountUnits.TON, TimeUnits.SECOND, hg.edb);

    private final AmountUnits a;
    private final TimeUnits n;
    private final String k;

    private FlowRateUnits(AmountUnits amountUnits, TimeUnits timeUnits, String string2) {
        this.a = amountUnits;
        this.n = timeUnits;
        this.k = string2;
    }

    public AmountUnits getAmountUnits() {
        return this.a;
    }

    public AmountType getAmountType() {
        return this.a.getAmountType();
    }

    public TimeUnits getTimeUnits() {
        return this.n;
    }

    @Override
    public String getName() {
        return this.k;
    }

    @Override
    public double modifier(FlowRateUnits flowRateUnits) {
        return this.a.modifier(flowRateUnits.a) / this.n.modifier(flowRateUnits.n);
    }

    @Override
    public double convertTo(double d2, FlowRateUnits flowRateUnits) {
        return d2 * this.modifier(flowRateUnits);
    }
}

