/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.Dimension;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import java.io.Serializable;
import java.util.Arrays;

public class HyperArray
implements Serializable {
    private static final long serialVersionUID = -78811125921911764L;
    public static final int INDEX_CAN_VARY = -1;
    private Dimension[] a;
    private int[] n;
    private double[] k;
    private static /* synthetic */ int[] m;

    public HyperArray(Dimension ... dimensionArray) {
        this.a = dimensionArray;
        this.n = new int[dimensionArray.length];
        int n2 = 1;
        int n3 = 0;
        while (n3 < dimensionArray.length) {
            n2 *= dimensionArray[n3].size();
            this.n[n3] = n3 == 0 ? 1 : this.n[n3 - 1] * dimensionArray[n3 - 1].size();
            ++n3;
        }
        this.k = new double[n2];
    }

    public HyperArray(double[] dArray, Dimension ... dimensionArray) {
        this(dimensionArray);
        System.arraycopy(dArray, 0, this.k, 0, Math.min(this.k.length, dArray.length));
    }

    public HyperArray(double d2, Dimension ... dimensionArray) {
        this(dimensionArray);
        Arrays.fill(this.k, d2);
    }

    public HyperArray(HyperArray hyperArray) {
        this.a = hyperArray.a;
        this.n = hyperArray.n;
        this.k = new double[hyperArray.k.length];
        System.arraycopy(hyperArray.k, 0, this.k, 0, this.k.length);
    }

    public Dimension[] getDimensions() {
        return this.a;
    }

    public int size() {
        return this.k.length;
    }

    public double[] getData() {
        return this.k;
    }

    public int getPosOf(int ... nArray) {
        if (nArray.length != this.a.length) {
            throw ff.m(hg.jgk);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.a.length) {
            int n4 = this.a[n3].getIndexPosition(nArray[n3]);
            if (n4 < 0) {
                throw new RuntimeException(String.format(hg.cdm, this.a[n3].getName(), nArray[n3]));
            }
            n2 += n4 * this.n[n3];
            ++n3;
        }
        return n2;
    }

    public double get(int ... nArray) {
        return this.k[this.getPosOf(nArray)];
    }

    public void set(double d2, int ... nArray) {
        this.k[this.getPosOf((int[])nArray)] = d2;
    }

    public void set(double[] dArray) {
        System.arraycopy(dArray, 0, this.k, 0, Math.min(this.k.length, dArray.length));
    }

    public void setData(double[] dArray, int n2) {
        System.arraycopy(dArray, n2, this.k, 0, Math.min(this.k.length, dArray.length));
    }

    public void set(double d2) {
        Arrays.fill(this.k, d2);
    }

    public void copyFrom(HyperArray hyperArray) {
        System.arraycopy(hyperArray.k, 0, this.k, 0, this.k.length);
    }

    void a(HyperArray hyperArray) {
        int n2 = 0;
        int n3 = Math.min(this.k.length, hyperArray.k.length);
        while (n2 < n3) {
            int n4 = n2;
            this.k[n4] = this.k[n4] + hyperArray.k[n2];
            ++n2;
        }
    }

    public double sum() {
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.k.length) {
            d2 += this.k[n2];
            ++n2;
        }
        return d2;
    }

    public double prod() {
        double d2 = 1.0;
        int n2 = 0;
        while (n2 < this.k.length) {
            d2 *= this.k[n2];
            ++n2;
        }
        return d2;
    }

    public double average() {
        return this.k.length > 0 ? this.sum() / (double)this.k.length : 0.0;
    }

    public double stddev() {
        if (this.k.length < 2) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = this.average();
        int n2 = 0;
        while (n2 < this.k.length) {
            double d4 = this.k[n2] - d3;
            d2 += d4 * d4;
            ++n2;
        }
        return Math.sqrt(d2 / (double)this.k.length / (double)(this.k.length - 1));
    }

    public double min() {
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.k.length) {
            if (this.k[n2] < d2) {
                d2 = this.k[n2];
            }
            ++n2;
        }
        return d2;
    }

    public double max() {
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = 0;
        while (n2 < this.k.length) {
            if (this.k[n2] > d2) {
                d2 = this.k[n2];
            }
            ++n2;
        }
        return d2;
    }

    public boolean equal(HyperArray hyperArray) {
        if (!Arrays.equals(this.a, hyperArray.a)) {
            return false;
        }
        return Arrays.equals(this.k, hyperArray.k);
    }

    public boolean equal(double d2) {
        int n2 = 0;
        while (n2 < this.k.length) {
            if (this.k[n2] != d2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasNegativeValues() {
        int n2 = 0;
        while (n2 < this.k.length) {
            if (this.k[n2] < 0.0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public double sum(int ... nArray) {
        return this.a(com.anylogic.engine.HyperArray$a.a, 0.0, nArray);
    }

    public double prod(int ... nArray) {
        return this.a(com.anylogic.engine.HyperArray$a.n, 0.0, nArray);
    }

    public double min(int ... nArray) {
        return this.a(com.anylogic.engine.HyperArray$a.k, 0.0, nArray);
    }

    public double max(int ... nArray) {
        return this.a(com.anylogic.engine.HyperArray$a.m, 0.0, nArray);
    }

    public void increment(int ... nArray) {
        this.a(com.anylogic.engine.HyperArray$a.h, 1.0, nArray);
    }

    public void incrementBy(double d2, int ... nArray) {
        this.a(com.anylogic.engine.HyperArray$a.h, d2, nArray);
    }

    public void decrement(int ... nArray) {
        this.a(com.anylogic.engine.HyperArray$a.h, -1.0, nArray);
    }

    public void decrementBy(double d2, int ... nArray) {
        this.a(com.anylogic.engine.HyperArray$a.h, -d2, nArray);
    }

    public void multiply(double d2, int ... nArray) {
        this.a(com.anylogic.engine.HyperArray$a.j, d2, nArray);
    }

    private double a(a a2, double d2, int ... nArray) {
        boolean bl2;
        double d3;
        block0 : switch (HyperArray.a()[a2.ordinal()]) {
            case 1: {
                d3 = 0.0;
                break;
            }
            case 2: {
                d3 = 1.0;
                break;
            }
            case 3: {
                d3 = Double.POSITIVE_INFINITY;
                break;
            }
            case 4: {
                d3 = Double.NEGATIVE_INFINITY;
                break;
            }
            case 5: 
            case 6: {
                d3 = 0.0;
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == -1) break block0;
                    ++n2;
                }
                n2 = this.getPosOf(nArray);
                switch (HyperArray.a()[a2.ordinal()]) {
                    case 5: {
                        int n3 = n2;
                        this.k[n3] = this.k[n3] + d2;
                        return 0.0;
                    }
                    case 6: {
                        int n4 = n2;
                        this.k[n4] = this.k[n4] * d2;
                        return 0.0;
                    }
                }
            }
            default: {
                throw new RuntimeException("HyperArray.operationOnSubset: illegal operation code: " + (Object)((Object)a2));
            }
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        int n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] == -1) {
                nArray2[n5] = this.a[n5].indexes[0];
            }
            ++n5;
        }
        block21: do {
            n5 = this.getPosOf(nArray2);
            double d4 = this.k[n5];
            switch (HyperArray.a()[a2.ordinal()]) {
                case 1: {
                    d3 += d4;
                    break;
                }
                case 2: {
                    d3 *= d4;
                    break;
                }
                case 3: {
                    if (!(d4 < d3)) break;
                    d3 = d4;
                    break;
                }
                case 4: {
                    if (!(d3 < d4)) break;
                    d3 = d4;
                    break;
                }
                case 5: {
                    this.k[n5] = d4 + d2;
                    break;
                }
                case 6: {
                    this.k[n5] = d4 * d2;
                }
            }
            bl2 = true;
            int n6 = 0;
            while (n6 < nArray.length) {
                if (nArray[n6] == -1) {
                    int n7 = this.a[n6].getIndexPosition(nArray2[n6]) + 1;
                    if (n7 < this.a[n6].size()) {
                        nArray2[n6] = this.a[n6].indexes[n7];
                        bl2 = false;
                        continue block21;
                    }
                    nArray2[n6] = this.a[n6].indexes[0];
                }
                ++n6;
            }
        } while (!bl2);
        return d3;
    }

    public String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.a.length > 0) {
            stringBuilder.append("[ ");
        }
        int n3 = 0;
        while (n3 < this.a.length) {
            stringBuilder.append(this.a[n3].getName());
            stringBuilder.append(n3 == this.a.length - 1 ? " ]" : ", ");
            ++n3;
        }
        if (this.a.length == 0) {
            return String.valueOf(stringBuilder.toString()) + Utilities.format(this.k[0]);
        }
        Dimension dimension = this.a[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < dimension.size()) {
            n4 = Math.max(n4, dimension.getIndexName(dimension.indexes[n5]).length());
            ++n5;
        }
        if (this.a.length == 1) {
            n5 = 0;
            while (n5 < dimension.size()) {
                int n6 = dimension.indexes[n5];
                stringBuilder.append(ff.h);
                HyperArray.a(stringBuilder, dimension.getIndexName(n6), n4);
                stringBuilder.append(Utilities.format(this.k[n5]));
                ++n5;
            }
            return stringBuilder.toString();
        }
        Dimension dimension2 = this.a[1];
        int[] nArray = new int[this.a.length];
        int n7 = 2;
        while (n7 < this.a.length) {
            nArray[n7] = this.a[n7].indexes[0];
            ++n7;
        }
        int[] nArray2 = new int[dimension2.size()];
        block4: do {
            int n8;
            if (this.a.length > 2) {
                stringBuilder.append(ff.h).append("[ .., .., ");
                n2 = 2;
                while (n2 < this.a.length) {
                    stringBuilder.append(this.a[n2].getIndexName(nArray[n2]));
                    stringBuilder.append(n2 < this.a.length - 1 ? ", " : " ]:");
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < dimension2.size()) {
                nArray2[n2] = dimension2.getIndexName(dimension2.indexes[n2]).length();
                ++n2;
            }
            n2 = 0;
            while (n2 < dimension.size()) {
                nArray[0] = dimension.indexes[n2];
                n8 = 0;
                while (n8 < dimension2.size()) {
                    nArray[1] = dimension2.indexes[n8];
                    nArray2[n8] = Math.max(nArray2[n8], Utilities.format(this.get(nArray)).length());
                    ++n8;
                }
                ++n2;
            }
            stringBuilder.append(ff.h);
            HyperArray.a(stringBuilder, "", n4);
            n2 = 0;
            while (n2 < dimension2.size()) {
                HyperArray.a(stringBuilder, dimension2.getIndexName(dimension2.indexes[n2]), nArray2[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < dimension.size()) {
                nArray[0] = dimension.indexes[n2];
                stringBuilder.append(ff.h);
                HyperArray.a(stringBuilder, dimension.getIndexName(nArray[0]), n4);
                n8 = 0;
                while (n8 < dimension2.size()) {
                    nArray[1] = dimension2.indexes[n8];
                    HyperArray.a(stringBuilder, Utilities.format(this.get(nArray)), nArray2[n8]);
                    ++n8;
                }
                ++n2;
            }
            n2 = 1;
            n8 = 2;
            while (n8 < this.a.length) {
                int n9 = this.a[n8].getIndexPosition(nArray[n8]) + 1;
                if (n9 < this.a[n8].size()) {
                    nArray[n8] = this.a[n8].indexes[n9];
                    n2 = 0;
                    continue block4;
                }
                nArray[n8] = this.a[n8].indexes[0];
                ++n8;
            }
        } while (n2 == 0);
        return stringBuilder.toString();
    }

    private static void a(StringBuilder stringBuilder, String string, int n2) {
        n2 = n2 - string.length() + 3;
        stringBuilder.append(string);
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append(' ');
            ++n3;
        }
    }

    static /* synthetic */ int[] a() {
        if (m != null) {
            return m;
        }
        int[] nArray = new int[com.anylogic.engine.HyperArray$a.values().length];
        try {
            nArray[com.anylogic.engine.HyperArray$a.h.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.anylogic.engine.HyperArray$a.m.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.anylogic.engine.HyperArray$a.k.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.anylogic.engine.HyperArray$a.n.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.anylogic.engine.HyperArray$a.j.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.anylogic.engine.HyperArray$a.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        m = nArray;
        return nArray;
    }

    private static enum a {
        a,
        n,
        k,
        m,
        h,
        j;

    }
}

