/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.IUnits;
import com.anylogic.engine.internal.hg;

public enum LengthUnits implements IUnits<LengthUnits>
{
    MILLIMETER(0.001, hg.ffn, hg.ffb),
    CENTIMETER(0.01, hg.bfg, hg.jak),
    METER(1.0, hg.mjn, hg.chl),
    KILOMETER(1000.0, hg.fmj, hg.gnl),
    INCH(0.0254, hg.hne, hg.nie),
    FOOT(0.3048, hg.cne, hg.kee),
    YARD(0.9144, hg.bjc, hg.cmb),
    MILE(1609.344, hg.glc, hg.emk),
    NAUTICAL_MILE(1853.184, hg.kid, hg.cnl);

    private final double a;
    private final String n;
    private final String k;

    private LengthUnits(double d2, String string2, String string3) {
        this.a = d2;
        this.n = string2;
        this.k = string3;
    }

    public String formatName(boolean bl2) {
        return bl2 ? this.n : this.k;
    }

    @Override
    public String getName() {
        return this.n;
    }

    @Override
    public double modifier(LengthUnits lengthUnits) {
        return this.a / lengthUnits.a;
    }

    @Override
    public double convertTo(double d2, LengthUnits lengthUnits) {
        return d2 * this.modifier(lengthUnits);
    }
}

