/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AbstractLinkToAgent;
import com.anylogic.engine.Agent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public interface LinkToAgentCollection<T extends Agent, A extends Agent>
extends AbstractLinkToAgent<T, A> {
    public <E extends T> List<E> getConnections();

    public int getConnectionsNumber();

    public int size();

    public T getConnectedAgent(int var1);

    public T getRandomConnectedAgent();

    public boolean connectTo(T var1);

    public boolean isConnectedTo(Agent var1);

    public boolean disconnectFrom(Agent var1);

    default public int disconnectByCondition(Predicate<T> predicate) {
        List list = this.getConnections();
        if (list.isEmpty()) {
            return 0;
        }
        ArrayList<Agent> arrayList = new ArrayList<Agent>(list.size());
        for (Agent agent : list) {
            if (!predicate.test(agent)) continue;
            arrayList.add(agent);
        }
        for (Agent agent : arrayList) {
            this.disconnectFrom(agent);
        }
        return arrayList.size();
    }

    public void disconnectFromAll();

    public void send(Object var1, T var2);

    public void sendToAllConnected(Object var1);

    public void sendToRandomConnected(Object var1);

    public void deliver(Object var1, T var2);

    public void deliverToAllConnected(Object var1);

    public void deliverToRandomConnected(Object var1);
}

