/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Engine;
import com.anylogic.engine.ExperimentMultipleRuns;
import com.anylogic.engine.ModelPropertyName;
import com.anylogic.engine.database.DatabaseLogViews;
import com.anylogic.engine.database.LoggingType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

@AnyLogicInternalAPI
public class ModelProperties {
    public static final String FILE_NAME = "model.properties";
    private final EnumMap<ModelPropertyName, Object> a = new EnumMap(ModelPropertyName.class);
    private final Properties n = new Properties();
    private EnumSet<LoggingType> k = null;

    public void load(Class<?> clazz) throws IOException {
        Object object;
        Properties properties = new Properties();
        Map.Entry<Object, Object> entry2 = null;
        Iterator<Map.Entry<Object, Object>> iterator = null;
        try {
            object = clazz.getResourceAsStream(FILE_NAME);
            try {
                properties.load((InputStream)object);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (entry2 == null) {
                entry2 = throwable;
            } else if (entry2 != throwable) {
                ((Throwable)((Object)entry2)).addSuppressed(throwable);
            }
            throw entry2;
        }
        this.a.clear();
        this.n.clear();
        this.n.putAll((Map<?, ?>)properties);
        for (Map.Entry<Object, Object> entry2 : this.n.entrySet()) {
            Object object2;
            block21: {
                if (!(entry2.getKey() instanceof ModelPropertyName)) continue;
                object = (ModelPropertyName)((Object)entry2.getKey());
                object2 = entry2.getValue();
                if (!(object2 instanceof String)) break block21;
                switch ((String)object2) {
                    case "true": {
                        object2 = true;
                        break;
                    }
                    case "false": {
                        object2 = false;
                    }
                }
            }
            this.a.put((ModelPropertyName)((Object)object), object2);
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        this.n.store(outputStream, null);
    }

    public String getStringProperty(Object object) {
        Object object2 = this.a.get(object);
        return object2 instanceof String ? (String)object2 : this.n.getProperty(ModelProperties.a(object));
    }

    public void setStringProperty(Object object, String string) {
        if (object instanceof ModelPropertyName) {
            this.a.put((ModelPropertyName)((Object)object), (Object)string);
        }
        this.n.put(ModelProperties.a(object), string);
    }

    public boolean getBooleanProperty(Object object) {
        Object object2 = this.a.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : Boolean.parseBoolean(this.n.getProperty(ModelProperties.a(object)));
    }

    public void setBooleanProperty(Object object, boolean bl2) {
        if (object instanceof ModelPropertyName) {
            this.a.put((ModelPropertyName)((Object)object), (Object)bl2);
        }
        this.n.put(ModelProperties.a(object), String.valueOf(bl2));
    }

    private static String a(Object object) {
        return String.valueOf(object);
    }

    public EnumSet<LoggingType> getLoggingTypes(Engine engine) {
        if (this.k == null) {
            this.k = EnumSet.noneOf(LoggingType.class);
            if (this.getBooleanProperty((Object)ModelPropertyName.LOGGING) && !(engine.getExperiment() instanceof ExperimentMultipleRuns)) {
                this.k.add(LoggingType.LOGGING);
                EnumSet<DatabaseLogViews> enumSet = this.a(engine);
                for (DatabaseLogViews databaseLogViews : enumSet) {
                    this.k.addAll(databaseLogViews.getLoggingTypes());
                }
            }
        }
        return this.k;
    }

    private EnumSet<DatabaseLogViews> a(Engine engine) {
        EnumSet<DatabaseLogViews> enumSet = EnumSet.noneOf(DatabaseLogViews.class);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement statement = engine.getModelDatabase().getConnection().createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT NAME FROM AL_SELECTED_LOG_OBJECTS WHERE TYPE= 'VIEW'");
                while (resultSet.next()) {
                    String string = resultSet.getString("NAME");
                    try {
                        enumSet.add(DatabaseLogViews.value(string));
                    }
                    catch (EnumConstantNotPresentException enumConstantNotPresentException) {}
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            engine.errorInModel(sQLException, sQLException.getLocalizedMessage());
        }
        return enumSet;
    }
}

