/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.IUnits;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.TimeUnits;
import com.anylogic.engine.internal.hg;

public enum SpeedUnits implements IUnits<SpeedUnits>
{
    MPS(LengthUnits.METER, TimeUnits.SECOND, hg.eic),
    KPH(LengthUnits.KILOMETER, TimeUnits.HOUR, hg.aij),
    FPS(LengthUnits.FOOT, TimeUnits.SECOND, hg.kbf),
    FPM(LengthUnits.FOOT, TimeUnits.MINUTE, hg.eef),
    MPH(LengthUnits.MILE, TimeUnits.HOUR, hg.akj),
    KN(LengthUnits.NAUTICAL_MILE, TimeUnits.HOUR, hg.lfa);

    private final LengthUnits a;
    private final TimeUnits n;
    private final String k;

    private SpeedUnits(LengthUnits lengthUnits, TimeUnits timeUnits, String string2) {
        this.a = lengthUnits;
        this.n = timeUnits;
        this.k = string2;
    }

    public LengthUnits getLengthUnits() {
        return this.a;
    }

    public TimeUnits getTimeUnits() {
        return this.n;
    }

    @Override
    public String getName() {
        return this.k;
    }

    @Override
    public double modifier(SpeedUnits speedUnits) {
        return this.a.modifier(speedUnits.a) / this.n.modifier(speedUnits.n);
    }

    @Override
    public double convertTo(double d2, SpeedUnits speedUnits) {
        return d2 * this.modifier(speedUnits);
    }
}

