/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.internal.hg;
import java.lang.reflect.Array;
import java.util.Collection;

public final class UtilitiesArray {
    private UtilitiesArray() {
        throw new UnsupportedOperationException();
    }

    public static int min(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException(hg.llj);
        }
        int n2 = Integer.MAX_VALUE;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            if (n5 < n2) {
                n2 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public static double min(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException(hg.llj);
        }
        double d2 = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d3 = dArray2[n3];
            if (d3 <= d2) {
                d2 = d3;
                bl2 = true;
            }
            ++n3;
        }
        return bl2 ? d2 : Double.NaN;
    }

    public static int max(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException(hg.llj);
        }
        int n2 = Integer.MIN_VALUE;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            if (n5 > n2) {
                n2 = n5;
            }
            ++n4;
        }
        return n2;
    }

    public static double max(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException(hg.llj);
        }
        double d2 = Double.NEGATIVE_INFINITY;
        boolean bl2 = false;
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d3 = dArray2[n3];
            if (d3 >= d2) {
                d2 = d3;
                bl2 = true;
            }
            ++n3;
        }
        return bl2 ? d2 : Double.NaN;
    }

    public static int indexOfMin(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] < n2) {
                n2 = nArray[n4];
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public static int indexOfMin(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return -1;
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = -1;
        int n3 = dArray.length - 1;
        while (n3 >= 0) {
            if (dArray[n3] <= d2) {
                d2 = dArray[n3];
                n2 = n3;
            }
            --n3;
        }
        return n2;
    }

    public static int indexOfMax(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] > n2) {
                n2 = nArray[n4];
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    public static int indexOfMax(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            return -1;
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        int n3 = dArray.length - 1;
        while (n3 >= 0) {
            if (dArray[n3] >= d2) {
                d2 = dArray[n3];
                n2 = n3;
            }
            --n3;
        }
        return n2;
    }

    public static int indexOf(int[] nArray, int n2) {
        if (nArray != null) {
            int n3 = 0;
            while (n3 < nArray.length) {
                if (n2 == nArray[n3]) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double d2) {
        if (dArray != null) {
            int n2 = 0;
            while (n2 < dArray.length) {
                if (d2 == dArray[n2]) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public static int indexOf(Object[] objectArray, Object object) {
        block6: {
            if (objectArray == null) break block6;
            if (object != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (object.equals(objectArray[n2])) {
                        return n2;
                    }
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3] == null) {
                        return n3;
                    }
                    ++n3;
                }
            }
        }
        return -1;
    }

    public static boolean arrayContains(int[] nArray, int n2) {
        return UtilitiesArray.indexOf(nArray, n2) >= 0;
    }

    public static boolean arrayContains(double[] dArray, double d2) {
        return UtilitiesArray.indexOf(dArray, d2) >= 0;
    }

    public static boolean arrayContains(Object[] objectArray, Object object) {
        return UtilitiesArray.indexOf(objectArray, object) >= 0;
    }

    public static <T> T[] concatenateArrays(T[] TArray, Collection<? extends T> collection) {
        int n2 = TArray.length;
        int n3 = collection.size();
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + n3);
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        int n4 = n2;
        for (T t : collection) {
            objectArray[n4++] = t;
        }
        return objectArray;
    }

    @SafeVarargs
    public static <T> T[] concatenateArrays(T[] TArray, T ... TArray2) {
        int n2 = TArray.length;
        int n3 = TArray2.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + n3);
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        System.arraycopy(TArray2, 0, objectArray, n2, n3);
        return objectArray;
    }

    @SafeVarargs
    public static <T> T[] toArray(T t, T ... TArray) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), 1);
        objectArray[0] = t;
        return UtilitiesArray.concatenateArrays(objectArray, TArray);
    }
}

