/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Experiment;
import com.anylogic.engine.ExperimentSimulation;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.TableTransferable;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.internal.af;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hc;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.in;
import com.anylogic.engine.internal.ke;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.Presentation;
import com.anylogic.engine.presentation.Shape;
import com.anylogic.engine.presentation.ShapeControl;
import com.anylogic.engine.presentation.ShapeGroup;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public abstract class Chart
extends ShapeControl
implements ActionListener {
    private static final long serialVersionUID = 3486512920533731353L;
    private static final String ac = hg.nj;
    private static final String mk = hg.jh;
    private static final String nd = hg.dc;
    private static final String mf = hg.gi;
    private static final String ha = hg.fd;
    public static final Direction NONE = Direction.NONE;
    public static final Direction SOUTH = Direction.SOUTH;
    public static final Direction WEST = Direction.WEST;
    public static final Direction EAST = Direction.EAST;
    public static final Direction NORTH = Direction.NORTH;
    public static final GridPosition GRID_NONE = GridPosition.GRID_NONE;
    public static final GridPosition GRID_DEFAULT = GridPosition.GRID_DEFAULT;
    public static final GridPosition GRID_OPPOSITE = GridPosition.GRID_OPPOSITE;
    public static final ScaleType SCALE_AUTO = ScaleType.SCALE_AUTO;
    public static final ScaleType SCALE_AUTO_FROM_0 = ScaleType.SCALE_AUTO_FROM_0;
    public static final ScaleType SCALE_FIXED = ScaleType.SCALE_FIXED;
    public static final ScaleType SCALE_100_PERCENT = ScaleType.SCALE_100_PERCENT;
    public static final PointStyle POINT_NONE = PointStyle.POINT_NONE;
    public static final PointStyle POINT_SQUARE = PointStyle.POINT_SQUARE;
    public static final PointStyle POINT_CIRCLE = PointStyle.POINT_CIRCLE;
    public static final PointStyle POINT_TRIANGLE = PointStyle.POINT_TRIANGLE;
    public static final InterpolationType INTERPOLATION_STEP = InterpolationType.INTERPOLATION_STEP;
    public static final InterpolationType INTERPOLATION_LINEAR = InterpolationType.INTERPOLATION_LINEAR;
    public static final TimeWindowMovementType WINDOW_MOVES_WITH_TIME = TimeWindowMovementType.WINDOW_MOVES_WITH_TIME;
    public static final TimeWindowMovementType WINDOW_MOVES_WITH_DATA = TimeWindowMovementType.WINDOW_MOVES_WITH_DATA;
    public static final String DEFAULT_TIME_PATTERN;
    public static final String DEFAULT_DATE_PATTERN;
    public static final String DEFAULT_DATE_TIME_PATTERN;
    protected static final Color a;
    protected static final Color n;
    protected static final Color k;
    protected static final DecimalFormat m;
    private static final FontRenderContext en;
    protected static final int h = 20;
    protected static final int j = 22;
    protected static final int i = 14;
    protected static final int d = 5;
    protected static final int l = 2;
    protected d g;
    private a fj;
    private JScrollPane me;
    private j lj;
    private JPopupMenu bf;
    private Color bl;
    private Color ca;
    protected Properties c;
    private final double mi;
    private final double be;
    private final int kh;
    private final int kn;
    private final int ck;
    private int bh;
    private int di;
    protected List<? extends ChartItem> b;
    protected List<String> f;
    protected List<Boolean> e = new ArrayList<Boolean>();
    private transient long bm = -1L;
    private static /* synthetic */ int[] gn;

    static {
        String string = new in(new long[]{1820108444170837631L, -6784983449284060214L, 7529437847157933609L}).toString();
        String string2 = new in(new long[]{-4090062331256594418L, 7791865530435662852L}).toString();
        String string3 = new in(new long[]{-6195776370448515868L, 3558706543066444080L, 5274370089143206277L}).toString();
        Locale locale = af.a();
        try {
            string3 = ((SimpleDateFormat)DateFormat.getDateInstance(2, locale)).toPattern();
            string2 = ((SimpleDateFormat)DateFormat.getTimeInstance(2, locale)).toLocalizedPattern();
            string = ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 2, locale)).toPattern();
        }
        catch (Throwable throwable) {
            ff.h(throwable);
            try {
                String[] stringArray;
                Object[] objectArray;
                try {
                    objectArray = Class.forName(new in(new long[]{-6867133922963903962L, 5709158282613311276L, -8627732044377827998L, 7238176182826298916L, 8506622297579263864L}).toString());
                    ResourceBundle resourceBundle = (ResourceBundle)objectArray.getMethod(new in(new long[]{6680455029382067704L, 5705213092180305881L, 5279395775958951068L, -3100830553181705636L}).toString(), Locale.class).invoke(objectArray, locale);
                    stringArray = resourceBundle.getStringArray(new in(new long[]{4295191598435263003L, -2291409790040394115L, -3883005212028721847L}).toString());
                }
                catch (Throwable throwable2) {
                    ff.h(throwable2);
                    Class<?> clazz = Class.forName(new in(new long[]{2187126285837809031L, 7306039533724669628L, -8793272412724025924L, 4371719887515342036L, -8017533281439373265L}).toString());
                    ResourceBundle resourceBundle = (ResourceBundle)clazz.getMethod(new in(new long[]{-2556411048413774617L, 1715102032908810318L, -2188186222292810338L, -6834789041469548058L}).toString(), Locale.class).invoke(clazz, locale);
                    stringArray = resourceBundle.getStringArray(new in(new long[]{7366381359116142708L, -7207579400261906289L, 1900161590047124184L}).toString());
                }
                string2 = stringArray[2];
                string3 = stringArray[6];
                objectArray = new Object[]{stringArray[2], stringArray[6]};
                string = MessageFormat.format(stringArray[8], objectArray);
            }
            catch (Throwable throwable3) {
                ff.h(throwable3);
            }
        }
        DEFAULT_DATE_TIME_PATTERN = string;
        DEFAULT_TIME_PATTERN = string2;
        DEFAULT_DATE_PATTERN = string3;
        a = UtilitiesColor.GAINSBORO;
        n = UtilitiesColor.WHITE_SMOKE;
        k = UtilitiesColor.WHITE;
        m = new DecimalFormat("##0.0", new DecimalFormatSymbols(Locale.ENGLISH));
        en = new FontRenderContext(null, false, true);
    }

    public Chart(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, double d6, double d7, double d8, double d9, Color color3, Color color4, Color color5, double d10, Direction direction, List<String> list) {
        super(presentable, bl2, d2, d3, d4, d5);
        this.mi = d4;
        this.be = d5;
        this.c = new Properties();
        this.c.picOffsetX = d6;
        this.kn = (int)Math.round(this.c.picOffsetX);
        this.c.picOffsetY = d7;
        this.ck = (int)Math.round(this.c.picOffsetY);
        this.c.picWidth = d8;
        this.bh = (int)Math.round(this.c.picWidth);
        this.c.picHeight = d9;
        this.di = (int)Math.round(this.c.picHeight);
        this.c.legendSize = d10;
        this.kh = (int)Math.round(this.c.legendSize);
        this.c.legendPos = direction;
        this.c.picBackgroundColor = color3;
        this.c.picBorderColor = color4;
        this.c.legendTextColor = color5;
        this.bl = color;
        this.ca = color2;
        this.f = list == null ? new ArrayList<String>() : list;
        this.mk();
    }

    public void refresh() {
        this.fj.a(false);
        this.g.repaint();
    }

    public final int getCount() {
        return this.b.size();
    }

    public final ChartItem get(int n2) {
        return this.b.get(n2);
    }

    public final String getTitle(int n2) {
        return this.f.get(n2);
    }

    public final int remove(ChartItem chartItem) {
        return this.a(chartItem, true, false);
    }

    private final int a(ChartItem chartItem, boolean bl2, boolean bl3) {
        this.h();
        int n2 = this.a(chartItem);
        if (n2 >= 0) {
            this.j();
        }
        this.onItemRemoved_xjal(n2, bl2);
        return n2;
    }

    protected int a(ChartItem chartItem) {
        int n2 = this.b.indexOf(chartItem);
        if (n2 >= 0) {
            this.b.remove(n2);
            this.f.remove(n2);
            this.e.remove(n2);
            if (this.lj != null) {
                this.lj.remove(n2);
            }
        }
        return n2;
    }

    public final void remove(int n2) {
        this.a(n2, true, false);
    }

    private final void a(int n2, boolean bl2, boolean bl3) {
        this.a(this.b.get(n2), bl2, bl3);
    }

    public void removeAll() {
        while (this.b.size() > 0) {
            this.a(this.b.get(this.b.size() - 1), true, this.b.size() > 1);
        }
    }

    public void updateData() {
        for (ChartItem chartItem : this.b) {
            chartItem.update();
        }
    }

    public String copyToClipboard() {
        List<List<Object>> list = this.k();
        Utilities.copyToClipboard(list);
        return TableTransferable.toString(list);
    }

    protected List<List<Object>> k() {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        int n2 = 0;
        while (n2 < this.b.size()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(this.f.get(n2));
            arrayList.add(arrayList2);
            arrayList.addAll(this.get(n2).getPlainDataTable());
            ++n2;
        }
        return arrayList;
    }

    private void ac() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n2 = this.g.getWidth();
            int n3 = this.g.getHeight();
            BufferedImage bufferedImage = ff.a(n2, n3, false);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            try {
                if (this.bl == null) {
                    graphics2D.setColor(UtilitiesColor.WHITE);
                    graphics2D.fillRect(0, 0, n2, n3);
                }
                this.g.print(graphics2D);
            }
            finally {
                graphics2D.dispose();
            }
            ke ke2 = new ke(bufferedImage);
            clipboard.setContents(ke2, null);
        }
        catch (HeadlessException headlessException) {
            throw ff.a(this.jj, headlessException, hg.aga);
        }
    }

    @AnyLogicInternalAPI
    public Chart(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        this.gd = this.jj.getShapeX(n2, n3);
        this.nm = this.jj.getShapeY(n2, n3);
        this.ng = this.jj.getShapeWidth(n2, n3);
        this.bn = this.jj.getShapeHeight(n2, n3);
        this.bl = this.jj.getShapeFillColor(n2, n3);
        this.ca = this.jj.getShapeLineColor(n2, n3);
        this.mi = this.ng;
        this.be = this.bn;
        this.c = this.jj.getShapeChartProperties(n2, n3);
        this.kn = (int)Math.round(this.c.picOffsetX);
        this.ck = (int)Math.round(this.c.picOffsetY);
        this.bh = (int)Math.round(this.c.picWidth);
        this.di = (int)Math.round(this.c.picHeight);
        this.kh = (int)Math.round(this.c.legendSize);
        this.f = this.jj.getShapeChartDataTitles(n2, n3);
        this.mk();
    }

    private void mk() {
        if (this.ng < 0.0 || this.bn < 0.0) {
            throw ff.a(this.jj, hg.if);
        }
        if (this.c.picOffsetX < 0.0 || this.c.picOffsetY < 0.0 || this.c.picWidth < 0.0 || this.c.picHeight < 0.0) {
            throw ff.a(this.jj, hg.aa);
        }
        switch (Chart.e()[this.c.legendPos.ordinal()]) {
            case 2: 
            case 5: {
                if (this.c.legendSize >= this.bn) {
                    throw ff.a(this.jj, hg.kj);
                }
                if (!(this.c.picOffsetX + this.c.picWidth > this.ng) && !(this.c.picOffsetY + this.c.picHeight > this.bn - this.c.legendSize)) break;
                throw ff.a(this.jj, hg.ei);
            }
            case 3: 
            case 4: {
                if (this.c.legendSize >= this.ng) {
                    throw ff.a(this.jj, hg.ii);
                }
                if (!(this.c.picOffsetX + this.c.picWidth > this.ng - this.c.legendSize) && !(this.c.picOffsetY + this.c.picHeight > this.bn)) break;
                throw ff.a(this.jj, hg.ei);
            }
            case 1: {
                if (!(this.c.picOffsetX + this.c.picWidth > this.ng) && !(this.c.picOffsetY + this.c.picHeight > this.bn)) break;
                throw ff.a(this.jj, hg.al);
            }
            default: {
                throw new RuntimeException(String.format(hg.kk, new Object[]{this.c.legendPos}));
            }
        }
        this.g = new d();
        this.fj = new a();
        this.g.add(this.fj);
        if (this.c.legendPos != NONE) {
            this.lj = new j();
            this.me = new JScrollPane(this.lj);
            if (ff.j() == 789) {
                this.me.setUI(new BasicScrollPaneUI());
            }
            this.me.setBorder(BorderFactory.createEmptyBorder());
            this.me.setOpaque(false);
            this.me.setBackground(null);
            this.me.setAutoscrolls(false);
            this.me.setWheelScrollingEnabled(false);
            MouseWheelListener[] mouseWheelListenerArray = this.me.getMouseWheelListeners();
            int n2 = mouseWheelListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MouseWheelListener mouseWheelListener = mouseWheelListenerArray[n3];
                this.me.removeMouseWheelListener(mouseWheelListener);
                ++n3;
            }
            this.me.getViewport().setOpaque(false);
            this.me.getViewport().setBackground(null);
            this.me.getVerticalScrollBar().setUnitIncrement(20);
            this.me.getHorizontalScrollBar().setUnitIncrement(50);
            this.g.add(this.me);
        }
    }

    long m() {
        long l2 = 0L;
        for (ChartItem chartItem : this.b) {
            l2 += chartItem.a;
        }
        return l2;
    }

    final void h() {
        this.bm = -1L;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.h();
    }

    protected void j() {
        if (this.jj == null || this.jj.getExperiment() == null || this.jj.getExperiment().getState() != Experiment.RUNNING) {
            this.refresh();
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void update() {
        this.refresh();
    }

    @Override
    @AnyLogicInternalAPI
    public void action() {
    }

    @Override
    public JComponent getJComponent() {
        return this.g;
    }

    @Override
    protected Shape a(ShapeGroup shapeGroup) {
        throw new UnsupportedOperationException(hg.he);
    }

    @Override
    public final Shape clone() {
        return super.clone();
    }

    protected void a(Graphics2D graphics2D, int n2, int n3) {
        if (this.c.picBackgroundColor != null) {
            graphics2D.setColor(this.c.picBackgroundColor);
            graphics2D.fillRect(0, 0, n2, n3);
        }
    }

    protected abstract void a(Graphics2D var1, int var2);

    protected boolean a(int n2) {
        return this.e.get(n2);
    }

    protected boolean i() {
        for (boolean bl2 : this.e) {
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public int[] getSelectedItemIndices() {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.e.size()) {
            if (this.e.get(n4).booleanValue()) {
                ++n2;
                n3 = n4;
            }
            ++n4;
        }
        int[] nArray = new int[n2];
        if (n2 == 1) {
            nArray[0] = n3;
        } else {
            n2 = 0;
            int n5 = 0;
            while (n5 < this.e.size()) {
                if (this.e.get(n5).booleanValue()) {
                    nArray[n2++] = n5;
                }
                ++n5;
            }
        }
        return nArray;
    }

    public void setSelectedItemIndices(int[] nArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(this.e);
        int n2 = 0;
        while (n2 < this.e.size()) {
            this.e.set(n2, false);
            ++n2;
        }
        if (nArray != null) {
            int[] nArray2 = nArray;
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                n2 = nArray2[n4];
                this.e.set(n2, true);
                ++n4;
            }
        }
        if (!arrayList.equals(this.e)) {
            this.h();
            this.refresh();
            this.onSelectionChanged_xjal(this.getSelectedItemIndices(), true);
        }
    }

    public void selectItem(int n2, boolean bl2) {
        boolean bl3 = this.e.get(n2);
        if (bl3 != bl2) {
            this.e.set(n2, bl2);
            this.h();
            this.refresh();
            this.onSelectionChanged_xjal(this.getSelectedItemIndices(), true);
        }
    }

    @AnyLogicInternalCodegenAPI
    public void onSelectionChanged_xjal(int[] nArray, boolean bl2) {
        if (this.jj != null) {
            this.jj.onSelectionChanged_xjal(this.jb, this.hn, nArray, bl2);
        }
    }

    @AnyLogicInternalCodegenAPI
    public void onItemRemoved_xjal(int n2, boolean bl2) {
        if (this.jj != null) {
            this.jj.onItemRemoved_xjal(this.jb, this.hn, n2, bl2);
        }
    }

    protected void a(String string) {
        this.e.add(false);
        if (this.lj != null) {
            this.lj.add(new k(string));
        }
    }

    protected String n(int n2) {
        if (this.lj == null) {
            return null;
        }
        return ((k)this.lj.getComponent((int)n2)).a;
    }

    protected void a(int n2, String string) {
        ((k)this.lj.getComponent((int)n2)).a = string;
    }

    @Override
    @AnyLogicInternalAPI
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            int n2 = this.b.size();
            if (mk.equals(string)) {
                ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
                int n3 = 0;
                while (n3 < n2) {
                    if (this.a(n3)) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        arrayList2.add(this.f.get(n3));
                        arrayList.add(arrayList2);
                        arrayList.addAll(this.get(n3).getPlainDataTable());
                    }
                    ++n3;
                }
                Utilities.copyToClipboard(arrayList);
            } else if (ac.equals(string)) {
                this.copyToClipboard();
            } else if (nd.equals(string)) {
                try {
                    this.ac();
                }
                catch (Throwable throwable) {
                    ff.h(throwable);
                    this.jj.getPresentation().showErrorDialog(ff.a(throwable), hg.dif);
                }
            } else if (ha.equals(string)) {
                int n4 = 0;
                int n5 = 0;
                while (n5 < this.e.size()) {
                    if (this.e.get(n5).booleanValue()) {
                        ++n4;
                    }
                    ++n5;
                }
                n5 = 0;
                int n6 = n2 - 1;
                while (n6 >= 0) {
                    if (this.a(n6)) {
                        this.a(n6, false, n5 < n4 - 1);
                        ++n5;
                    }
                    --n6;
                }
            } else if (mf.equals(string)) {
                while (this.lj.getComponentCount() > 0) {
                    this.a(this.b.size() - 1, false, this.lj.getComponentCount() > 1);
                }
            }
        }
        catch (Exception exception) {}
    }

    @AnyLogicInternalAPI
    public JPopupMenu getPopupMenu() {
        if (this.bf == null) {
            this.bf = new f();
        }
        return this.bf;
    }

    static /* synthetic */ String b() {
        return ha;
    }

    static /* synthetic */ String f() {
        return mf;
    }

    static /* synthetic */ int[] e() {
        if (gn != null) {
            return gn;
        }
        int[] nArray = new int[Direction.values().length];
        try {
            nArray[Direction.EAST.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.NORTH.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.SOUTH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.WEST.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        gn = nArray;
        return nArray;
    }

    private class a
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 2594175448593004641L;
        private static final int n = 100;
        private boolean k = false;
        private transient AtomicReference<SoftReference<hc>> m;

        a() {
            this.n();
            this.setOpaque(false);
            this.setBackground(null);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public Rectangle getVisibleRect() {
            return this.k ? new Rectangle(0, 0, this.getWidth(), this.getHeight()) : super.getVisibleRect();
        }

        @Override
        protected void printComponent(Graphics graphics) {
            this.k = true;
            try {
                super.printComponent(graphics);
            }
            finally {
                this.k = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            try {
                Rectangle rectangle = this.getVisibleRect();
                if (rectangle.width == 0 || rectangle.height == 0) {
                    return;
                }
                hc hc2 = this.a();
                try {
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    Object object = hc2.m;
                    synchronized (object) {
                        hc2.a();
                        if (!hc2.k.contains(rectangle)) {
                            Object object2 = hc2.h;
                            synchronized (object2) {
                                block24: {
                                    ff.a(rectangle, 100, 0, 0, this.getWidth(), this.getHeight());
                                    if (rectangle.width > hc2.a.width || rectangle.height > hc2.a.height || 2 * rectangle.width < hc2.a.width || 2 * rectangle.height < hc2.a.height) {
                                        Presentation presentation;
                                        Presentation presentation2 = presentation = Chart.this.jj != null ? Chart.this.jj.getPresentation() : null;
                                        if (presentation != null) {
                                            presentation.getPanel().internals.a().a();
                                        }
                                        try {
                                            double d2 = this.a(rectangle);
                                            while (true) {
                                                double d3 = Math.sqrt(d2);
                                                int n6 = (int)Math.round(d3 * (double)rectangle.width);
                                                int n7 = (int)Math.round(d3 * (double)rectangle.height);
                                                try {
                                                    hc2.a(n6, n7, true);
                                                    hc2.n.setSize(n6, n7);
                                                    hc2.a.setSize(rectangle.width, rectangle.height);
                                                    break block24;
                                                }
                                                catch (OutOfMemoryError outOfMemoryError) {
                                                    d2 /= 1.5;
                                                    continue;
                                                }
                                                break;
                                            }
                                        }
                                        finally {
                                            if (presentation != null) {
                                                presentation.getPanel().internals.a().n();
                                            }
                                        }
                                    }
                                    if (hc2.k()) {
                                        hc2.n.width = (int)((long)rectangle.width * (long)hc2.m() / (long)hc2.a.width);
                                        hc2.n.height = (int)((long)rectangle.height * (long)hc2.h() / (long)hc2.a.height);
                                    } else {
                                        hc2.n.setSize(rectangle.width, rectangle.height);
                                    }
                                }
                                hc2.k.setBounds(rectangle);
                                Chart.this.h();
                                this.a(true);
                            }
                        }
                        n5 = hc2.k.x;
                        n4 = hc2.k.y;
                        n3 = hc2.k.width;
                        n2 = hc2.k.height;
                    }
                    graphics.drawImage(hc2.j(), n5, n4, n5 + n3 - 1, n4 + n2 - 1, 0, 0, hc2.n.width - 1, hc2.n.height - 1, null);
                }
                finally {
                    hc2.n();
                }
            }
            catch (Exception exception) {}
        }

        private double a(Rectangle rectangle) {
            return 1.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void a(boolean bl2) {
            hc hc2 = this.a();
            Object object = hc2.h;
            synchronized (object) {
                if (hc2.k.width == 0 || hc2.k.height == 0) {
                    return;
                }
                long l2 = Chart.this.m();
                if (Chart.this.bm == l2) {
                    return;
                }
                Chart.this.bm = l2;
                Graphics2D graphics2D = hc2.i().createGraphics();
                try {
                    graphics2D.setClip(0, 0, hc2.n.width, hc2.n.height);
                    com.anylogic.engine.internal.presentation.e.a(graphics2D, 0, 0, hc2.n.width, hc2.n.height);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    double d2 = -hc2.k.x + Chart.this.kn;
                    double d3 = -hc2.k.y + Chart.this.ck;
                    int n2 = Chart.this.bh;
                    int n3 = Chart.this.di;
                    if (hc2.k()) {
                        double d4 = (double)hc2.n.width / (double)hc2.k.width;
                        double d5 = (double)hc2.n.height / (double)hc2.k.height;
                        d2 *= d4;
                        d3 *= d5;
                        n2 = (int)Math.round((double)n2 * d4);
                        n3 = (int)Math.round((double)n3 * d5);
                    }
                    graphics2D.translate(d2, d3);
                    Chart.this.a(graphics2D, n2, n3);
                    if (Chart.this.c.picBorderColor != null) {
                        graphics2D.setColor(Chart.this.c.picBorderColor);
                        graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.n());
                        graphics2D.drawRect(0, 0, n2, n3);
                    }
                }
                finally {
                    graphics2D.dispose();
                }
            }
            hc2.a(bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
            hc hc2 = this.a();
            if (this.getWidth() != n4 || this.getHeight() != n5) {
                Object object = hc2.m;
                synchronized (object) {
                    hc2.k.setSize(0, 0);
                    if (n4 < hc2.a.width || n5 < hc2.a.height) {
                        hc2.a.setSize(0, 0);
                    }
                }
            }
            super.setBounds(n2, n3, n4, n5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeNotify() {
            hc hc2 = this.a();
            super.removeNotify();
            Object object = hc2.m;
            synchronized (object) {
                hc2.k.setSize(0, 0);
                hc2.a.setSize(0, 0);
                Object object2 = hc2.h;
                synchronized (object2) {
                    hc2.d();
                    hc2.n.setSize(0, 0);
                }
                object2 = this.m.getAndSet(null);
                if (object2 != null) {
                    Presentation presentation;
                    Presentation presentation2 = presentation = Chart.this.jj != null ? Chart.this.jj.getPresentation() : null;
                    if (presentation != null) {
                        presentation.getPanel().internals.a().n((SoftReference<hc>)object2);
                    }
                }
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.n();
        }

        private hc a() {
            hc hc2;
            SoftReference<hc> softReference;
            SoftReference<hc> softReference2;
            do {
                Presentation presentation;
                softReference2 = this.m.get();
                Presentation presentation2 = presentation = Chart.this.jj != null ? Chart.this.jj.getPresentation() : null;
                if (softReference2 != null) {
                    hc2 = softReference2.get();
                    if (hc2 != null) break;
                    if (presentation != null) {
                        presentation.getPanel().internals.a().n(softReference2);
                    }
                }
                hc2 = new hc();
                softReference = new SoftReference<hc>(hc2);
                if (presentation == null) continue;
                presentation.getPanel().internals.a().a(softReference);
            } while (!this.m.compareAndSet(softReference2, softReference));
            return hc2;
        }

        private void n() {
            this.m = new AtomicReference<Object>(null);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            try {
                this.n(mouseEvent);
                this.a(mouseEvent);
            }
            catch (Exception exception) {}
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                this.n(mouseEvent);
                this.a(mouseEvent);
            }
            catch (Exception exception) {}
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        private void a(MouseEvent mouseEvent) {
            Panel panel = this.k();
            if (panel != null) {
                mouseEvent.translatePoint(Chart.this.g.getX() + this.getX(), Chart.this.g.getY() + this.getY());
                mouseEvent.setSource(panel);
                panel.dispatchEvent(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                this.a(mouseEvent);
            }
            catch (Exception exception) {}
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        private Panel k() {
            Container container = Chart.this.g.getParent();
            return container instanceof Panel ? (Panel)container : null;
        }

        private boolean n(MouseEvent mouseEvent) {
            JMenuItem jMenuItem;
            if (!mouseEvent.isPopupTrigger()) {
                return false;
            }
            Panel panel = this.k();
            if (panel == null || panel.getCursor().getType() == 13) {
                return false;
            }
            if (!ff.g()) {
                return false;
            }
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>(3);
            JMenuItem jMenuItem2 = new JMenuItem(ac, new ImageIcon(Presentation.class.getResource("popup_copy_all.gif")));
            jMenuItem2.addActionListener(Chart.this);
            arrayList.add(jMenuItem2);
            if (Chart.this.i()) {
                jMenuItem = new JMenuItem(mk, new ImageIcon(Presentation.class.getResource("popup_copy.gif")));
                jMenuItem.addActionListener(Chart.this);
                arrayList.add(jMenuItem);
            }
            if (Chart.this.jj.getPresentation().getMode() != Presentation.MODE_APPLET) {
                jMenuItem = new JMenuItem(nd, new ImageIcon(Presentation.class.getResource("popup_copy_image.gif")));
                jMenuItem.addActionListener(Chart.this);
                arrayList.add(jMenuItem);
            }
            panel.setPopupMenu_xjal(arrayList.toArray(new JMenuItem[arrayList.size()]));
            return true;
        }
    }

    class d
    extends JPanel {
        private static final long serialVersionUID = 1816330947371104763L;

        d() {
            if (Chart.this.bl != null) {
                this.setBackground(Chart.this.bl);
            } else {
                this.setOpaque(false);
            }
            if (Chart.this.ca != null) {
                this.setBorder(new LineBorder(Chart.this.ca));
            }
            this.setLayout(null);
        }

        @Override
        public void setBounds(int n2, int n3, int n4, int n5) {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10 = this.getWidth();
            int n11 = this.getHeight();
            super.setBounds(n2, n3, n4, n5);
            if (n10 == n4 && n11 == n5) {
                return;
            }
            Chart.this.bh = n4 - (int)(Chart.this.mi - Chart.this.c.picWidth);
            Chart.this.di = n5 - (int)(Chart.this.be - Chart.this.c.picHeight);
            if (Chart.this.c.legendPos == NONE) {
                n9 = 0;
                n8 = 0;
                n7 = n4;
                n6 = n5;
            } else {
                int n12;
                int n13;
                int n14;
                int n15;
                switch (Chart.this.c.legendPos) {
                    case SOUTH: {
                        n9 = 0;
                        n8 = 0;
                        n7 = n4;
                        n6 = n5 - Chart.this.kh;
                        n15 = Chart.this.kn;
                        n14 = n5 - Chart.this.kh;
                        n13 = n4 - Chart.this.kn;
                        n12 = Chart.this.kh;
                        break;
                    }
                    case WEST: {
                        n9 = Chart.this.kh;
                        n8 = 0;
                        n7 = n4 - Chart.this.kh;
                        n6 = n5;
                        n15 = 0;
                        n14 = Chart.this.ck;
                        n13 = Chart.this.kh;
                        n12 = n5 - Chart.this.ck;
                        break;
                    }
                    case EAST: {
                        n9 = 0;
                        n8 = 0;
                        n7 = n4 - Chart.this.kh;
                        n6 = n5;
                        n15 = n4 - Chart.this.kh;
                        n14 = Chart.this.ck;
                        n13 = Chart.this.kh;
                        n12 = n5 - Chart.this.ck;
                        break;
                    }
                    case NORTH: {
                        n9 = 0;
                        n8 = Chart.this.kh;
                        n7 = n4;
                        n6 = n5 - Chart.this.kh;
                        n15 = Chart.this.kn;
                        n14 = 0;
                        n13 = n4 - Chart.this.kn;
                        n12 = Chart.this.kh;
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format(hg.kk, new Object[]{Chart.this.c.legendPos}));
                    }
                }
                Chart.this.me.setBounds(n15, n14, n13, n12);
                Chart.this.lj.a();
            }
            Chart.this.fj.setBounds(n9, n8, n7, n6);
        }
    }

    public static enum Direction {
        NONE,
        SOUTH,
        WEST,
        EAST,
        NORTH;

    }

    public static enum GridPosition {
        GRID_NONE,
        GRID_DEFAULT,
        GRID_OPPOSITE;

    }

    public static enum InterpolationType {
        INTERPOLATION_STEP,
        INTERPOLATION_LINEAR;

    }

    private class k
    extends JComponent
    implements MouseListener {
        private static final long serialVersionUID = 878927706798370894L;
        private boolean k = false;
        String a;

        k(String string) {
            this.a = string;
            this.setOpaque(false);
            this.setBackground(null);
            this.addMouseListener(this);
        }

        private int a() {
            try {
                int n2 = this.getParent().getComponentCount();
                int n3 = 0;
                while (n3 < n2) {
                    if (this.getParent().getComponent(n3) == this) break;
                    ++n3;
                }
                return n3;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            try {
                int n2 = this.a();
                if (n2 < 0) {
                    return;
                }
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                try {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (Chart.this.e.get(n2).booleanValue()) {
                        graphics2D.setColor(UtilitiesColor.MEDIUM_BLUE);
                        graphics2D.fillRect(2, 2, this.getWidth() - 4, 16);
                    }
                    Chart.this.a(graphics2D, n2);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.setColor(Chart.this.e.get(n2) != false ? k : Chart.this.c.legendTextColor);
                    graphics2D.setFont(com.anylogic.engine.internal.presentation.e.a());
                    graphics2D.drawString(this.a, 22, 14);
                }
                finally {
                    graphics2D.dispose();
                }
            }
            catch (Exception exception) {}
        }

        @Override
        @AnyLogicInternalAPI
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        @AnyLogicInternalAPI
        public void mousePressed(MouseEvent mouseEvent) {
            try {
                this.k = false;
                if (ff.mf && mouseEvent.isPopupTrigger()) {
                    this.mouseReleased(mouseEvent);
                    this.k = true;
                }
            }
            catch (Exception exception) {}
        }

        @Override
        @AnyLogicInternalAPI
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (this.k) {
                    return;
                }
                int n2 = this.a();
                if (n2 < 0) {
                    return;
                }
                if (!mouseEvent.isPopupTrigger() || !Chart.this.e.get(n2).booleanValue()) {
                    Chart.this.e.set(n2, Chart.this.e.get(n2) == false);
                    if (Chart.this.e.get(n2).booleanValue() && (mouseEvent.getModifiers() & 2) != 2) {
                        int n3 = 0;
                        while (n3 < Chart.this.e.size()) {
                            Chart.this.e.set(n3, false);
                            ++n3;
                        }
                        Chart.this.e.set(n2, true);
                    }
                    Chart.this.h();
                    Chart.this.refresh();
                    final int[] nArray = Chart.this.getSelectedItemIndices();
                    final Experiment<?> experiment = Chart.this.jj.getExperiment();
                    experiment.mutexModelActionQueue.a(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = experiment.getMutexWrite_xjal();
                            synchronized (object) {
                                Object object2 = experiment.getMutexRead_xjal();
                                synchronized (object2) {
                                    if (experiment instanceof ExperimentSimulation && Chart.this.jj instanceof Agent) {
                                        Agent agent = (Agent)Chart.this.jj;
                                        while (agent.getOwner() != null) {
                                            agent = agent.getOwner();
                                        }
                                        if (agent != experiment.getEngine().getRoot()) {
                                            return;
                                        }
                                    }
                                    Chart.this.onSelectionChanged_xjal(nArray, false);
                                }
                            }
                        }
                    });
                }
                if (mouseEvent.isPopupTrigger()) {
                    Chart.this.getPopupMenu().show(this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
            catch (Exception exception) {}
        }

        @Override
        @AnyLogicInternalAPI
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        @AnyLogicInternalAPI
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class j
    extends JPanel {
        private static final long serialVersionUID = 7294298692708337945L;

        j() {
            this.setOpaque(false);
            this.setBackground(null);
            this.setLayout(null);
        }

        @Override
        public Component add(Component component) {
            super.add(component);
            try {
                this.a();
            }
            catch (Exception exception) {}
            return component;
        }

        @Override
        public void remove(int n2) {
            super.remove(n2);
            try {
                this.a();
            }
            catch (Exception exception) {}
        }

        private void a() {
            int n2;
            int n3;
            int n4 = this.getComponentCount();
            if (n4 == 0) {
                return;
            }
            int n5 = Chart.this.me.getWidth();
            int n6 = 0;
            Font font = com.anylogic.engine.internal.presentation.e.a();
            int n7 = 0;
            while (n7 < n4) {
                String string = ((k)this.getComponent((int)n7)).a;
                n3 = 22 + (int)font.getStringBounds(string, en).getWidth() + 5;
                if (n3 > n6) {
                    n6 = n3;
                }
                ++n7;
            }
            if (n5 < n6) {
                n7 = 1;
                n2 = n6;
            } else {
                n7 = n5 / n6;
                n2 = n5 / n7;
            }
            n3 = 0;
            while (n3 < n4) {
                Component component = this.getComponent(n3);
                component.setBounds(n3 % n7 * n2, n3 / n7 * 20, n2, 20);
                ++n3;
            }
            Dimension dimension = new Dimension((n7 - 1) * n2 + n6, 20 * (int)Math.ceil((double)n4 / (double)n7));
            this.setPreferredSize(dimension);
            this.getParent().validate();
        }
    }

    public static enum PointStyle {
        POINT_NONE,
        POINT_SQUARE,
        POINT_CIRCLE,
        POINT_TRIANGLE;

    }

    private class f
    extends JPopupMenu {
        private static final long serialVersionUID = -1422412845747957470L;
        JMenuItem a = new JMenuItem(Chart.l(), new ImageIcon(Presentation.class.getResource("popup_copy.gif")));
        JMenuItem n = new JMenuItem(Chart.d(), new ImageIcon(Presentation.class.getResource("popup_copy_all.gif")));
        JMenuItem k = new JMenuItem(Chart.b(), new ImageIcon(Presentation.class.getResource("popup_delete.gif")));
        JMenuItem m = new JMenuItem(Chart.f(), new ImageIcon(Presentation.class.getResource("popup_delete_all.gif")));
        JMenuItem h = new JMenuItem(Chart.g(), new ImageIcon(Presentation.class.getResource("popup_copy_image.gif")));

        f() {
            ff.a(this);
            if (ff.g()) {
                this.a.addActionListener(Chart.this);
                this.add(this.a);
                this.n.addActionListener(Chart.this);
                this.add(this.n);
                this.h.addActionListener(Chart.this);
                this.add(this.h);
                this.addSeparator();
            }
            this.k.addActionListener(Chart.this);
            this.add(this.k);
            this.m.addActionListener(Chart.this);
            this.add(this.m);
        }

        @Override
        public void show(Component component, int n2, int n3) {
            try {
                this.a.setEnabled(Chart.this.i());
                this.k.setEnabled(Chart.this.i());
            }
            catch (Exception exception) {}
            super.show(component, n2, n3);
        }
    }

    public static class Properties
    implements Serializable {
        private static final long serialVersionUID = 5713465384194652921L;
        public double picOffsetX = 50.0;
        public double picOffsetY = 10.0;
        public double picWidth;
        public double picHeight;
        public Direction legendPos = SOUTH;
        public double legendSize;
        public Color picBackgroundColor = UtilitiesColor.WHITE;
        public Color picBorderColor = UtilitiesColor.BLACK;
        public Color legendTextColor = UtilitiesColor.BLACK;
        public Direction barDirection = NORTH;
        public double relativeBarWidth = 0.6;
        public GridPosition gridPositionX = GRID_DEFAULT;
        public GridPosition gridPositionY = GRID_DEFAULT;
        public Color gridLineColor = UtilitiesColor.GRAY;
        public Color gridTextColor = UtilitiesColor.BLACK;
        public ScaleType scaleTypeX = SCALE_AUTO;
        public double minimumX = 0.0;
        public double maximumX = 100.0;
        public TimeWindowMovementType timeWindowMovementType = WINDOW_MOVES_WITH_TIME;
        public ScaleType scaleTypeY = SCALE_AUTO;
        public double minimumY = 0.0;
        public double maximumY = 100.0;
        public boolean showPDF = true;
        public boolean showCDF = true;
        public boolean showMean = true;
        public boolean drawEnvelopes = true;
        public String dateFormatPattern = null;
    }

    public static enum ScaleType {
        SCALE_AUTO,
        SCALE_AUTO_FROM_0,
        SCALE_FIXED,
        SCALE_100_PERCENT;

    }

    public static enum TimeWindowMovementType {
        WINDOW_MOVES_WITH_TIME,
        WINDOW_MOVES_WITH_DATA;

    }
}

