/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.analysis.Chart;
import com.anylogic.engine.analysis.Chart2D;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.internal.b;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.n;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Chart2DPlot
extends Chart2D {
    private static final long serialVersionUID = 3638272481138477394L;
    private final int[] nd;
    private final int[] mf;
    protected List<Appearance> mk;

    public Chart2DPlot(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, double d6, double d7, double d8, double d9, Color color3, Color color4, Color color5, double d10, Chart.Direction direction, Chart.ScaleType scaleType, double d11, double d12, Chart.GridPosition gridPosition, Chart.GridPosition gridPosition2, Color color6, Color color7, List<DataSet> list, List<String> list2, List<Appearance> list3) {
        super(presentable, bl2, d2, d3, d4, d5, color, color2, d6, d7, d8, d9, color3, color4, color5, d10, direction, scaleType, d11, d12, gridPosition, gridPosition2, color6, color7, list, list2);
        int[] nArray = new int[3];
        nArray[0] = -3;
        nArray[2] = 3;
        this.nd = nArray;
        this.mf = new int[]{2, -3, 2};
        this.mk = list3 == null ? new ArrayList<Appearance>() : list3;
        this.mk();
    }

    @AnyLogicInternalAPI
    public Chart2DPlot(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        int[] nArray = new int[3];
        nArray[0] = -3;
        nArray[2] = 3;
        this.nd = nArray;
        this.mf = new int[]{2, -3, 2};
        this.mk = this.jj.getShapeChartDataPlotOptions(n2, n3);
        this.mk();
    }

    public void addDataSet(DataSet dataSet, String string, Color color, boolean bl2, Chart.InterpolationType interpolationType, double d2, Chart.PointStyle pointStyle) {
        this.addDataSet(dataSet, string, new Appearance(color, bl2, interpolationType, d2, pointStyle));
    }

    public void addDataSet(DataSet dataSet, String string, Appearance appearance) {
        this.mk.add(appearance);
        super.addDataSet(dataSet, string);
        this.j();
    }

    @Override
    public void addDataSet(DataSet dataSet, String string) {
        this.addDataSet(dataSet, string, UtilitiesColor.royalBlue, true, INTERPOLATION_LINEAR, 1.0, POINT_NONE);
    }

    public void addDataSet(DataSet dataSet) {
        this.addDataSet(dataSet, hg.id, UtilitiesColor.royalBlue, true, INTERPOLATION_LINEAR, 1.0, POINT_NONE);
    }

    public void setFixedVerticalScale(double d2, double d3) {
        this.c.scaleTypeY = SCALE_FIXED;
        this.c.minimumY = d2;
        this.c.maximumY = d3;
    }

    @Override
    protected int a(ChartItem chartItem) {
        int n2 = super.a(chartItem);
        if (n2 >= 0) {
            this.mk.remove(n2);
        }
        return n2;
    }

    public Appearance getAppearance(int n2) {
        return this.mk.get(n2);
    }

    private void mk() {
        if (this.mk.size() != this.ac.size()) {
            throw ff.a(this.jj, hg.fa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void a(Graphics2D graphics2D, int n2, int n3, Chart.PointStyle pointStyle) {
        switch (pointStyle) {
            case POINT_NONE: {
                return;
            }
            case POINT_CIRCLE: {
                graphics2D.fillOval(n2 - 2, n3 - 2, 4, 4);
                return;
            }
            case POINT_SQUARE: {
                graphics2D.fillRect(n2 - 2, n3 - 2, 4, 4);
                return;
            }
            case POINT_TRIANGLE: {
                int[] nArray = this.nd;
                synchronized (this.nd) {
                    int n4 = 0;
                    while (n4 < 3) {
                        int n5 = n4;
                        this.nd[n5] = this.nd[n5] + n2;
                        int n6 = n4++;
                        this.mf[n6] = this.mf[n6] + n3;
                    }
                    graphics2D.fillPolygon(this.nd, this.mf, 3);
                    n4 = 0;
                    while (n4 < 3) {
                        int n7 = n4;
                        this.nd[n7] = this.nd[n7] - n2;
                        int n8 = n4++;
                        this.mf[n8] = this.mf[n8] - n3;
                    }
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    protected static boolean a(int n2, int n3, int n4, int n5) {
        return n2 >= 0 && n2 <= n4 && n3 >= 0 && n3 <= n5;
    }

    @Override
    protected void a(Graphics2D graphics2D, int n2) {
        Appearance appearance = this.mk.get(n2);
        graphics2D.setColor(appearance.a);
        int n3 = 10;
        if (appearance.n) {
            graphics2D.setStroke(appearance.m);
            graphics2D.drawLine(5, n3, 17, n3);
        }
        if (appearance.j != POINT_NONE) {
            this.a(graphics2D, 7, n3, appearance.j);
            this.a(graphics2D, 14, n3, appearance.j);
        }
    }

    public static class Appearance
    extends b
    implements Serializable {
        private static final String i = "None";
        private static final String d = "Triangle";
        private static final String l = "Square";
        private static final String g = "Circle";
        private static final String c = "Point style";
        private static final String b = "Interpolation type";
        private static final String f = "Step";
        private static final String e = "Linear";
        private static final String ac = "Line width";
        private static final String mk = "Drawing line";
        private static final String nd = "Color";
        private static final long serialVersionUID = 7443426896864212118L;
        Color a;
        boolean n;
        Chart.InterpolationType k;
        transient BasicStroke m;
        transient BasicStroke h;
        Chart.PointStyle j;
        private static /* synthetic */ int[] mf;

        public Appearance(Color color, boolean bl2, Chart.InterpolationType interpolationType, double d2, Chart.PointStyle pointStyle) {
            this.a = color;
            this.n = bl2;
            this.k = interpolationType;
            this.m = new BasicStroke((float)d2);
            this.h = new BasicStroke((float)d2 * 4.0f);
            this.j = pointStyle;
        }

        @Override
        protected void a(Map<String, String> map) throws Exception {
            String string = map.get(nd);
            if (string == null) {
                throw Appearance.n(nd);
            }
            this.a = com.anylogic.engine.internal.n.n(string);
            string = map.get(mk);
            if (string == null) {
                throw Appearance.n(mk);
            }
            this.n = "Enabled".equals(com.anylogic.engine.internal.n.k(string));
            string = com.anylogic.engine.internal.n.k(map.get(b));
            if (string == null) {
                throw Appearance.n(b);
            }
            this.k = f.equalsIgnoreCase(string) ? Chart.INTERPOLATION_STEP : Chart.INTERPOLATION_LINEAR;
            string = map.get(ac);
            if (string == null) {
                throw Appearance.n(ac);
            }
            this.m = new BasicStroke((float)com.anylogic.engine.internal.n.a(string));
            string = com.anylogic.engine.internal.n.k(map.get(c));
            if (g.equalsIgnoreCase(string)) {
                this.j = Chart.POINT_CIRCLE;
            } else if (l.equalsIgnoreCase(string)) {
                this.j = Chart.POINT_SQUARE;
            } else if (d.equalsIgnoreCase(string)) {
                this.j = Chart.POINT_TRIANGLE;
            } else if (i.equalsIgnoreCase(string)) {
                this.j = Chart.POINT_NONE;
            } else {
                throw Appearance.n(c);
            }
        }

        @Override
        protected void n(Map<String, String> map) {
            String string;
            map.put(nd, com.anylogic.engine.internal.n.a(this.a));
            map.put(mk, Appearance.a(this.n ? "Enabled" : "Disabled"));
            map.put(b, Appearance.a(this.k == Chart.INTERPOLATION_STEP ? f : e));
            map.put(ac, com.anylogic.engine.internal.n.a(this.m.getLineWidth()));
            switch (Appearance.a()[this.j.ordinal()]) {
                case 3: {
                    string = g;
                    break;
                }
                case 2: {
                    string = l;
                    break;
                }
                case 4: {
                    string = d;
                    break;
                }
                default: {
                    string = i;
                }
            }
            map.put(c, Appearance.a(string));
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeFloat(this.m.getLineWidth());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            float f2 = objectInputStream.readFloat();
            this.m = new BasicStroke(f2);
            this.h = new BasicStroke(f2 * 4.0f);
        }

        static /* synthetic */ int[] a() {
            if (mf != null) {
                return mf;
            }
            int[] nArray = new int[Chart.PointStyle.values().length];
            try {
                nArray[Chart.PointStyle.POINT_CIRCLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Chart.PointStyle.POINT_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Chart.PointStyle.POINT_SQUARE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Chart.PointStyle.POINT_TRIANGLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            mf = nArray;
            return nArray;
        }
    }
}

