/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.TableFunction;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.DataUpdater_xjal;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.gk;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.n;
import java.util.ArrayList;
import java.util.List;

public class DataSet
extends ChartItem {
    private static final long serialVersionUID = 879409527620309777L;
    private int n;
    private boolean k = true;
    private boolean m = true;
    private double[] h;
    private double[] j;
    private int i;
    private boolean d;
    private double l;
    private double g;
    private double c;
    private double b;
    private DataUpdater_xjal f;

    public DataSet(int n2) {
        this(n2, null);
    }

    public DataSet(int n2, DataUpdater_xjal dataUpdater_xjal) {
        if (n2 <= 0) {
            throw new RuntimeException(String.format(hg.ki, n2));
        }
        this.n = n2;
        this.h = new double[n2];
        this.j = new double[n2];
        this.f = dataUpdater_xjal != null ? dataUpdater_xjal : DataUpdater_xjal.a;
        this.reset();
    }

    @AnyLogicInternalCodegenAPI
    public void destroyUpdater_xjal() {
        this.f = DataUpdater_xjal.a;
    }

    public synchronized void reset() {
        this.l = Double.POSITIVE_INFINITY;
        this.g = Double.NEGATIVE_INFINITY;
        this.c = Double.POSITIVE_INFINITY;
        this.b = Double.NEGATIVE_INFINITY;
        this.i = -1;
        this.d = false;
        ++this.a;
    }

    public synchronized void setCapacity(int n2) {
        if (n2 <= 0) {
            throw new RuntimeException(String.format(hg.ki, n2));
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = Math.min(this.size(), n2);
        this.l = Double.POSITIVE_INFINITY;
        this.g = Double.NEGATIVE_INFINITY;
        this.c = Double.POSITIVE_INFINITY;
        this.b = Double.NEGATIVE_INFINITY;
        int n4 = this.i;
        int n5 = n3 - 1;
        while (n5 >= 0) {
            dArray[n5] = this.h[n4];
            if (dArray[n5] < this.l) {
                this.l = dArray[n5];
            }
            if (this.g < dArray[n5]) {
                this.g = dArray[n5];
            }
            dArray2[n5] = this.j[n4];
            if (dArray2[n5] < this.c) {
                this.c = dArray2[n5];
            }
            if (this.b < dArray2[n5]) {
                this.b = dArray2[n5];
            }
            n4 = (this.n + n4 - 1) % this.n;
            --n5;
        }
        this.n = n2;
        this.h = dArray;
        this.j = dArray2;
        this.i = n3 - 1;
        this.d = n3 == n2;
        ++this.a;
    }

    public int getCapacity() {
        return this.n;
    }

    public void allowDuplicateY(boolean bl2) {
        this.m = bl2;
    }

    public boolean duplicateYAllowed() {
        return this.m;
    }

    public void allowDuplicateX(boolean bl2) {
        this.k = bl2;
    }

    public boolean duplicateXAllowed() {
        return this.k;
    }

    public synchronized void add(double d2, double d3) {
        if (Double.isNaN(d2 + d3)) {
            throw new RuntimeException(String.format(hg.cj, d2 + d3));
        }
        ++this.a;
        boolean bl2 = false;
        if (!this.k && this.i >= 0 && d2 == this.h[this.i]) {
            this.j[this.i] = d3;
            bl2 = true;
        }
        if (!this.m && this.i >= 0 && d3 == this.j[this.i]) {
            this.h[this.i] = d2;
            bl2 = true;
        }
        if (d2 < this.l) {
            this.l = d2;
        }
        if (d2 > this.g) {
            this.g = d2;
        }
        if (d3 < this.c) {
            this.c = d3;
        }
        if (d3 > this.b) {
            this.b = d3;
        }
        if (bl2) {
            return;
        }
        if (!this.d && this.i + 1 == this.n) {
            this.d = true;
        }
        this.i = (this.i + 1) % this.n;
        boolean bl3 = false;
        if (this.d) {
            double d4 = this.h[this.i];
            double d5 = this.j[this.i];
            if (d4 <= this.l || this.g <= d4 || d5 <= this.c || this.b <= d5) {
                bl3 = true;
            }
        }
        this.h[this.i] = d2;
        this.j[this.i] = d3;
        if (bl3) {
            this.l = Double.POSITIVE_INFINITY;
            this.g = Double.NEGATIVE_INFINITY;
            this.c = Double.POSITIVE_INFINITY;
            this.b = Double.NEGATIVE_INFINITY;
            int n2 = 0;
            while (n2 < this.h.length) {
                double d6 = this.h[n2];
                double d7 = this.j[n2];
                if (d6 < this.l) {
                    this.l = d6;
                }
                if (d6 > this.g) {
                    this.g = d6;
                }
                if (d7 < this.c) {
                    this.c = d7;
                }
                if (d7 > this.b) {
                    this.b = d7;
                }
                ++n2;
            }
        }
    }

    public synchronized void add(double d2) {
        this.add(this.f.getDataXValue(), d2);
    }

    public synchronized void fillFrom(DataSet dataSet) {
        this.n = dataSet.n;
        this.h = new double[dataSet.h.length];
        this.j = new double[dataSet.j.length];
        System.arraycopy(dataSet.h, 0, this.h, 0, dataSet.h.length);
        System.arraycopy(dataSet.j, 0, this.j, 0, dataSet.j.length);
        this.i = dataSet.i;
        this.d = dataSet.d;
        this.l = dataSet.l;
        this.g = dataSet.g;
        this.c = dataSet.c;
        this.b = dataSet.b;
        ++this.a;
    }

    public synchronized void fillFrom(TableFunction tableFunction) {
        this.reset();
        double[] dArray = tableFunction.getArguments();
        double[] dArray2 = tableFunction.getValues();
        this.setCapacity(dArray.length);
        int n2 = 0;
        while (n2 < dArray.length) {
            this.add(dArray[n2], dArray2[n2]);
            ++n2;
        }
        ++this.a;
    }

    @Override
    public void update() {
        this.f.update(this);
    }

    public double getXMin() {
        return this.l;
    }

    public double getXMax() {
        return this.g;
    }

    public double getXMean() {
        return ff.a(this.h, this.size());
    }

    public double getXMedian() {
        return ff.n(this.h, this.size());
    }

    public double getYMin() {
        return this.c;
    }

    public double getYMax() {
        return this.b;
    }

    public double getYMean() {
        return ff.a(this.j, this.size());
    }

    public double getYMedian() {
        return ff.n(this.j, this.size());
    }

    public synchronized int size() {
        return this.d ? this.n : this.i + 1;
    }

    public synchronized double getX(int n2) {
        if (n2 < 0 || this.size() <= n2) {
            throw new RuntimeException(String.format(hg.eg, n2));
        }
        int n3 = this.d ? (this.i + 1) % this.n : 0;
        return this.h[(n3 + n2) % this.n];
    }

    public synchronized double getY(int n2) {
        if (n2 < 0 || this.size() <= n2) {
            throw new RuntimeException(String.format(hg.eg, n2));
        }
        int n3 = this.d ? (this.i + 1) % this.n : 0;
        return this.j[(n3 + n2) % this.n];
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = Math.min(this.size(), 1000);
        int n3 = 0;
        while (n3 < n2) {
            stringBuilder.append(Utilities.format(this.getX(n3))).append('\t').append(Utilities.format(this.getY(n3))).append(ff.h);
            ++n3;
        }
        if (this.size() > n2) {
            stringBuilder.append(String.format(hg.ah, this.size() - n2));
        }
        return stringBuilder.toString();
    }

    @Override
    @AnyLogicInternalAPI
    public synchronized List<List<Object>> getPlainDataTable() {
        int n2 = Math.min(this.size(), 1000);
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        int n3 = 0;
        while (n3 < n2) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(this.getX(n3));
            arrayList2.add(this.getY(n3));
            arrayList.add(arrayList2);
            ++n3;
        }
        if (this.size() > n2) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            arrayList3.add(String.format(hg.ah, this.size() - n2));
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    @Override
    protected final void a(ga ga2, boolean bl2) {
        ga2.n("\"x\";\"y\"");
        int n2 = 0;
        int n3 = this.size();
        while (n2 < n3) {
            ga2.a(com.anylogic.engine.internal.n.a(this.getX(n2)));
            ga2.a(';');
            ga2.a(com.anylogic.engine.internal.n.a(this.getY(n2)));
            ga2.a();
            ++n2;
        }
        ga2.a();
    }

    @Override
    protected final String a(gk gk2) throws Exception {
        String string = gk2.a();
        if (!"\"x\";\"y\"".equals(string)) {
            throw new Exception(String.format(hg.cc, string));
        }
        this.reset();
        while (true) {
            if ((string = gk2.a()) == null) {
                throw com.anylogic.engine.internal.n.a();
            }
            if (string.length() == 0) {
                return null;
            }
            int n2 = string.indexOf(59);
            if (n2 < 0) {
                throw new Exception(hg.lc);
            }
            this.add(com.anylogic.engine.internal.n.a(string.substring(0, n2)), com.anylogic.engine.internal.n.a(string.substring(n2 + 1)));
        }
    }
}

