/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.analysis.Chart;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.d;
import com.anylogic.engine.internal.b;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.n;
import com.anylogic.engine.internal.presentation.e;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Histogram
extends Chart {
    private static final long serialVersionUID = 7136519752178127449L;
    private List<HistogramData> ac;
    private List<Appearance> mk;
    private double nd;
    private double mf;
    private double ha;
    private d en;
    private d fj;
    private transient Rectangle2D.Double me = new Rectangle2D.Double();

    @Deprecated
    public Histogram(Presentable presentable, boolean bl2, int n2, int n3, int n4, int n5, Color color, Color color2, int n6, int n7, int n8, int n9, Color color3, Color color4, Color color5, int n10, Chart.Direction direction, Chart.GridPosition gridPosition, Chart.GridPosition gridPosition2, Color color6, Color color7, boolean bl3, boolean bl4, boolean bl5, double d2, List<HistogramData> list, List<String> list2, List<Appearance> list3) {
        this(presentable, bl2, (double)n2, (double)n3, (double)n4, (double)n5, color, color2, (double)n6, (double)n7, (double)n8, (double)n9, color3, color4, color5, (double)n10, direction, gridPosition, gridPosition2, color6, color7, bl3, bl4, bl5, d2, list, list2, list3);
    }

    public Histogram(Presentable presentable, boolean bl2, double d2, double d3, double d4, double d5, Color color, Color color2, double d6, double d7, double d8, double d9, Color color3, Color color4, Color color5, double d10, Chart.Direction direction, Chart.GridPosition gridPosition, Chart.GridPosition gridPosition2, Color color6, Color color7, boolean bl3, boolean bl4, boolean bl5, double d11, List<HistogramData> list, List<String> list2, List<Appearance> list3) {
        super(presentable, bl2, d2, d3, d4, d5, color, color2, d6, d7, d8, d9, color3, color4, color5, d10, direction, list2);
        this.c.showPDF = bl3;
        this.c.showCDF = bl4;
        this.c.showMean = bl5;
        this.c.relativeBarWidth = d11;
        this.c.gridPositionX = gridPosition;
        this.c.gridPositionY = gridPosition2;
        this.c.gridLineColor = color6;
        this.c.gridTextColor = color7;
        if (list == null) {
            this.ac = new ArrayList<HistogramData>();
            this.mk = new ArrayList<Appearance>();
        } else {
            this.ac = list;
            this.mk = list3;
        }
        this.ac();
    }

    @AnyLogicInternalAPI
    public Histogram(Presentable presentable, int n2, int n3) {
        super(presentable, n2, n3);
        this.ac = this.jj.getShapeChartHistograms(n2, n3);
        this.mk = this.jj.getShapeChartHistogramOptions(n2, n3);
        this.ac();
    }

    public void addHistogram(HistogramData histogramData, String string, Color color, Color color2, Color color3, Color color4, float f2, Color color5) {
        this.addHistogram(histogramData, string, new Appearance(color, color2, color3, color4, f2, color5));
    }

    public void addHistogram(HistogramData histogramData, String string, Appearance appearance) {
        this.ac.add(histogramData);
        this.f.add(string);
        this.mk.add(appearance);
        this.a(string);
        this.j();
    }

    @Override
    protected int a(ChartItem chartItem) {
        int n2 = super.a(chartItem);
        if (n2 >= 0) {
            this.mk.remove(n2);
        }
        return n2;
    }

    public Appearance getAppearance(int n2) {
        return this.mk.get(n2);
    }

    @Override
    public void refresh() {
        this.nd = Double.POSITIVE_INFINITY;
        this.mf = Double.NEGATIVE_INFINITY;
        this.ha = 0.0;
        for (HistogramData histogramData : this.ac) {
            if (histogramData.getXMin() < this.nd) {
                this.nd = histogramData.getXMin();
            }
            if (histogramData.getXMax() > this.mf) {
                this.mf = histogramData.getXMax();
            }
            if (!(histogramData.getMaxPDF() > this.ha)) continue;
            this.ha = histogramData.getMaxPDF();
        }
        this.ha *= 100.0;
        if (this.en != null) {
            this.en.a(this.nd, this.mf);
        }
        if (this.fj != null) {
            this.fj.a(0.0, this.ha);
        }
        super.refresh();
    }

    private void ac() {
        for (HistogramData histogramData : this.ac) {
            if (histogramData != null) continue;
            throw ff.a(this.jj, hg.lam);
        }
        if (this.f.size() != this.ac.size() || this.mk.size() != this.ac.size()) {
            throw ff.a(this.jj, hg.egl);
        }
        this.b = this.ac;
        if (this.c.gridPositionX != GRID_NONE) {
            this.en = new d(EAST, false, false, this.c.gridPositionX, com.anylogic.engine.internal.presentation.e.a(), this.c.gridLineColor, this.c.gridTextColor, true);
            this.en.n(this.c.picWidth, this.c.picHeight);
        }
        if (this.c.gridPositionY != GRID_NONE) {
            this.fj = new d(NORTH, false, false, this.c.gridPositionY, com.anylogic.engine.internal.presentation.e.a(), this.c.gridLineColor, this.c.gridTextColor, true);
            this.en.n(this.c.picWidth, this.c.picHeight);
            this.fj.a("#0'%'");
        }
        int n2 = 0;
        while (n2 < this.ac.size()) {
            this.a((String)this.f.get(n2));
            ++n2;
        }
    }

    @Override
    protected void a(Graphics2D graphics2D, int n2, int n3) {
        super.a(graphics2D, n2, n3);
        if (this.en != null) {
            this.en.n(n2, n3);
        }
        if (this.fj != null) {
            this.fj.n(n2, n3);
        }
        if (this.ac.size() > 0) {
            graphics2D.setClip(0, 0, n2, n3);
            double d2 = this.en == null ? this.nd : this.en.k();
            double d3 = this.en == null ? this.mf : this.en.m();
            double d4 = (this.fj == null ? this.ha : this.fj.m()) / 100.0;
            if (!this.i()) {
                int n4 = 0;
                while (n4 < this.ac.size()) {
                    this.a(graphics2D, n4, false, d2, d3, d4, n2, n3);
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this.ac.size()) {
                    if (!this.a(n5)) {
                        this.a(graphics2D, n5, true, d2, d3, d4, n2, n3);
                    }
                    ++n5;
                }
                n5 = 0;
                while (n5 < this.ac.size()) {
                    if (this.a(n5)) {
                        this.a(graphics2D, n5, false, d2, d3, d4, n2, n3);
                    }
                    ++n5;
                }
            }
            graphics2D.setClip(null);
        }
        if (this.en != null) {
            this.en.a(graphics2D);
        }
        if (this.fj != null) {
            this.fj.a(graphics2D);
        }
    }

    private void a(Graphics2D graphics2D, int n2, boolean bl2, double d2, double d3, double d4, int n3, int n4) {
        int n5;
        HistogramData histogramData = this.ac.get(n2);
        Appearance appearance = this.mk.get(n2);
        if (histogramData.count() == 0) {
            return;
        }
        int n6 = histogramData.n();
        int n7 = n6 + histogramData.k();
        double d5 = (histogramData.getXMin() - d2) / (d3 - d2) * (double)n3;
        double d6 = (histogramData.getXMax() - histogramData.getXMin()) / (d3 - d2) * (double)n3;
        double d7 = d6 / (double)histogramData.k();
        double d8 = d7 * this.c.relativeBarWidth;
        double d9 = (d7 - d8) / 2.0;
        if (this.c.showPDF) {
            n5 = n6;
            while (n5 < n7) {
                double d10 = (int)(d5 + (double)(n5 - n6) * d7 + d9);
                double d11 = histogramData.getPDF(n5) / d4 * (double)n4;
                this.a(graphics2D, histogramData, appearance, n5, d10, d8, d11, bl2, n4);
                ++n5;
            }
        }
        if (histogramData.i && this.c.showCDF) {
            graphics2D.setColor(bl2 ? a : appearance.m);
            graphics2D.setStroke(appearance.h);
            n5 = n6;
            while (n5 < n7) {
                int n8 = (int)(d5 + (double)(n5 - n6) * d7);
                int n9 = (int)((double)n4 * (1.0 - (n5 == n6 ? 0.0 : histogramData.getCDF(n5 - 1))));
                int n10 = (int)((double)n4 * (1.0 - histogramData.getCDF(n5)));
                graphics2D.drawLine(n8, n9, n8 + (int)d7, n10);
                ++n5;
            }
        }
        if (this.c.showMean) {
            n5 = (int)(d5 + (histogramData.mean() - histogramData.getXMin()) / (histogramData.getXMax() - histogramData.getXMin()) * d6);
            graphics2D.setColor(bl2 ? a : appearance.j);
            graphics2D.setStroke(appearance.h);
            graphics2D.drawLine(n5, 0, n5, n4);
        }
    }

    private void a(Graphics2D graphics2D, HistogramData histogramData, Appearance appearance, int n2, double d2, double d3, double d4, boolean bl2, int n3) {
        if (!bl2 && histogramData.i && histogramData.m) {
            if (n2 < histogramData.b) {
                graphics2D.setColor(appearance.a);
            } else {
                if (n2 == histogramData.b) {
                    double d5 = d3 / 2.0;
                    graphics2D.setColor(appearance.a);
                    this.me.setFrame(d2, (double)n3 - d4, d5, d4);
                    graphics2D.fill(this.me);
                    graphics2D.setColor(n2 == histogramData.f ? appearance.n : appearance.k);
                    this.me.setFrame(d2 + d5, (double)n3 - d4, d5, d4);
                    graphics2D.fill(this.me);
                    return;
                }
                if (histogramData.b < n2 && n2 < histogramData.f) {
                    graphics2D.setColor(appearance.k);
                } else {
                    if (n2 == histogramData.f) {
                        double d6 = d3 / 2.0;
                        graphics2D.setColor(appearance.k);
                        this.me.setFrame(d2, (double)n3 - d4, d6, d4);
                        graphics2D.fill(this.me);
                        graphics2D.setColor(appearance.n);
                        this.me.setFrame(d2 + d6, (double)n3 - d4, d6, d4);
                        graphics2D.fill(this.me);
                        return;
                    }
                    graphics2D.setColor(appearance.n);
                }
            }
        } else {
            graphics2D.setColor(bl2 ? a : appearance.k);
        }
        this.me.setFrame(d2, (double)n3 - d4, d3, d4);
        graphics2D.fill(this.me);
        if (bl2) {
            graphics2D.setColor(n);
            graphics2D.setStroke(com.anylogic.engine.internal.presentation.e.n());
            graphics2D.draw(this.me);
        }
    }

    @Override
    protected void a(Graphics2D graphics2D, int n2) {
        HistogramData histogramData = this.ac.get(n2);
        Appearance appearance = this.mk.get(n2);
        graphics2D.setColor(histogramData.i && histogramData.m ? appearance.a : appearance.k);
        graphics2D.fillRect(5, 10, 2, 4);
        graphics2D.setColor(appearance.k);
        graphics2D.fillRect(7, 7, 2, 7);
        graphics2D.fillRect(9, 5, 2, 9);
        graphics2D.fillRect(11, 6, 2, 8);
        graphics2D.fillRect(13, 8, 2, 6);
        graphics2D.setColor(histogramData.i && histogramData.m ? appearance.n : appearance.k);
        graphics2D.fillRect(15, 10, 2, 4);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.me = new Rectangle2D.Double();
    }

    public static class Appearance
    extends b
    implements Serializable {
        private static final String i = "Mean color";
        private static final String d = "CDF line width";
        private static final String l = "CDF color";
        private static final String g = "PDF color";
        private static final String c = "High percent color";
        private static final String b = "Low percent color";
        private static final long serialVersionUID = 1284306480267868680L;
        Color a;
        Color n;
        Color k;
        Color m;
        transient BasicStroke h;
        Color j;

        public Appearance(Color color, Color color2, Color color3, Color color4, float f2, Color color5) {
            this.a = color;
            this.n = color2;
            this.k = color3;
            this.m = color4;
            this.h = new BasicStroke(f2);
            this.j = color5;
        }

        @Override
        protected void n(Map<String, String> map) {
            map.put(b, com.anylogic.engine.internal.n.a(this.a));
            map.put(c, com.anylogic.engine.internal.n.a(this.n));
            map.put(g, com.anylogic.engine.internal.n.a(this.k));
            map.put(l, com.anylogic.engine.internal.n.a(this.m));
            map.put(d, com.anylogic.engine.internal.n.a(this.h.getLineWidth()));
            map.put(i, com.anylogic.engine.internal.n.a(this.j));
        }

        @Override
        protected void a(Map<String, String> map) throws Exception {
            String string = map.get(b);
            if (string == null) {
                throw Appearance.n(b);
            }
            this.a = com.anylogic.engine.internal.n.n(string);
            string = map.get(c);
            if (string == null) {
                throw Appearance.n(c);
            }
            this.n = com.anylogic.engine.internal.n.n(string);
            string = map.get(g);
            if (string == null) {
                throw Appearance.n(g);
            }
            this.k = com.anylogic.engine.internal.n.n(string);
            string = map.get(l);
            if (string == null) {
                throw Appearance.n(l);
            }
            this.m = com.anylogic.engine.internal.n.n(string);
            string = map.get(d);
            if (string == null) {
                throw Appearance.n(d);
            }
            this.h = new BasicStroke((float)com.anylogic.engine.internal.n.a(string));
            string = map.get(i);
            if (string == null) {
                throw Appearance.n(i);
            }
            this.j = com.anylogic.engine.internal.n.n(string);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeFloat(this.h.getLineWidth());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.h = new BasicStroke(objectInputStream.readFloat());
        }
    }
}

