/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.analysis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalCodegenAPI;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.analysis.ChartItem;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.analysis.DataUpdater_xjal;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.ga;
import com.anylogic.engine.internal.gk;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.in;
import com.anylogic.engine.internal.n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class Histogram2DData
extends ChartItem {
    private static final long serialVersionUID = -788586858355134292L;
    private static final String j = new in(new long[]{2152653032586120000L}).toString();
    private final int i;
    private final int d;
    private final double l;
    private final double g;
    private final double c;
    private final double b;
    double[] n = new double[]{0.4, 0.6, 0.8};
    private int[] f;
    int[][] k;
    int[][] m;
    int[] h;
    private int[] e;
    private int[] ac;
    private int[] mk;
    private int[] nd;
    private DataUpdater_xjal mf;

    public Histogram2DData(int n2, double d2, double d3, int n3, double d4, double d5, double[] dArray) {
        this(n2, d2, d3, n3, d4, d5, dArray, null);
    }

    public Histogram2DData(int n2, double d2, double d3, int n3, double d4, double d5, double[] dArray, DataUpdater_xjal dataUpdater_xjal) {
        if (d2 >= d3) {
            throw ff.m(hg.gci);
        }
        if (d4 >= d5) {
            throw ff.m(hg.fff);
        }
        this.i = n2;
        this.d = n3;
        this.l = d2;
        this.g = d3;
        this.c = d4;
        this.b = d5;
        this.k = new int[n2][n3];
        this.m = new int[n2][n3];
        this.h = new int[n2];
        this.e = new int[n2];
        this.ac = new int[n2];
        this.mk = new int[n2];
        this.nd = new int[n2];
        this.f = new int[n2];
        if (dArray != null) {
            this.setEnvelopes(dArray);
        }
        this.mf = dataUpdater_xjal != null ? dataUpdater_xjal : DataUpdater_xjal.a;
    }

    @AnyLogicInternalCodegenAPI
    public void destroyUpdater_xjal() {
        this.mf = DataUpdater_xjal.a;
    }

    public synchronized void reset() {
        int n2 = 0;
        while (n2 < this.i) {
            Arrays.fill(this.k[n2], 0);
            Arrays.fill(this.m[n2], 0);
            ++n2;
        }
        Arrays.fill(this.h, 0);
        Arrays.fill(this.e, 0);
        Arrays.fill(this.ac, 0);
        Arrays.fill(this.mk, 0);
        Arrays.fill(this.nd, 0);
        Arrays.fill(this.f, 0);
        ++this.a;
    }

    public synchronized void add(double d2, double d3) {
        int n2;
        int n3;
        if (!(d2 >= this.l) || !(d2 < this.g)) {
            return;
        }
        int n4 = (int)((double)this.i * (d2 - this.l) / (this.g - this.l));
        if (d3 < this.c) {
            int n5 = n4;
            this.e[n5] = this.e[n5] + 1;
            n3 = this.e[n4];
        } else if (this.b <= d3) {
            int n6 = n4;
            this.ac[n6] = this.ac[n6] + 1;
            n3 = this.ac[n4];
        } else {
            if (Double.isNaN(d3)) {
                throw new RuntimeException(String.format(hg.cj, d3));
            }
            n2 = (int)((double)this.d * (d3 - this.c) / (this.b - this.c));
            int[] nArray = this.k[n4];
            int n7 = n2;
            nArray[n7] = nArray[n7] + 1;
            n3 = this.k[n4][n2];
        }
        if (n3 > this.h[n4]) {
            this.h[n4] = n3;
        }
        int n8 = n4;
        this.f[n8] = this.f[n8] + 1;
        this.mk[n4] = this.e[n4];
        n2 = 0;
        while (n2 < this.d) {
            int n9 = n2 == 0 ? this.mk[n4] : this.m[n4][n2 - 1];
            this.m[n4][n2] = n9 + this.k[n4][n2];
            ++n2;
        }
        this.nd[n4] = this.m[n4][this.d - 1] + this.ac[n4];
        ++this.a;
    }

    public synchronized void add(DataSet dataSet) {
        int n2 = 0;
        while (n2 < dataSet.size()) {
            this.add(dataSet.getX(n2), dataSet.getY(n2));
            ++n2;
        }
    }

    @Override
    public void update() {
        this.mf.update(this);
    }

    public void setEnvelopes(double[] dArray) {
        if (dArray.length == 0) {
            throw ff.m(hg.bnl);
        }
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n2 == 0 && dArray[n2] < 0.0 || n2 > 0 && dArray[n2] <= dArray[n2 - 1] || dArray[n2] > 1.0) {
                throw ff.m(hg.bfl);
            }
            ++n2;
        }
        this.n = dArray;
        ++this.a;
    }

    public int getNumberOfXIntervals() {
        return this.i;
    }

    public int getNumberOfYIntervals() {
        return this.d;
    }

    public synchronized double getPDF(int n2, int n3) {
        if (this.f[n2] == 0) {
            return 0.0;
        }
        return (double)this.k[n2][n3] / (double)this.f[n2];
    }

    public synchronized double getCDF(int n2, int n3) {
        if (this.f[n2] == 0) {
            return 0.0;
        }
        return (double)this.m[n2][n3] / (double)this.f[n2];
    }

    public double getPDFOutsideLow(int n2) {
        if (this.f[n2] == 0) {
            return 0.0;
        }
        return this.e[n2] / this.f[n2];
    }

    public double getPDFOutsideHigh(int n2) {
        if (this.f[n2] == 0) {
            return 0.0;
        }
        return this.ac[n2] / this.f[n2];
    }

    public int count(int n2) {
        return this.f[n2];
    }

    public double getXMin() {
        return this.l;
    }

    public double getXMax() {
        return this.g;
    }

    public double getYMin() {
        return this.c;
    }

    public double getYMax() {
        return this.b;
    }

    public synchronized String toString() {
        double d2 = (this.getXMax() - this.getXMin()) / (double)this.i;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\t').append(hg.aag).append('\t');
        int n2 = 0;
        while (n2 < this.i) {
            stringBuilder.append(Utilities.format(this.getXMin() + d2 * (double)n2)).append('\t');
            ++n2;
        }
        stringBuilder.append(ff.h);
        stringBuilder.append(hg.aag).append('\t').append(hg.hjb).append('\t');
        n2 = 0;
        while (n2 < this.i) {
            stringBuilder.append(Utilities.format(this.getXMin() + d2 * (double)(n2 + 1))).append('\t');
            ++n2;
        }
        stringBuilder.append(ff.h);
        double d3 = this.getYMax();
        double d4 = (this.getYMax() - this.getYMin()) / (double)this.d;
        int n3 = this.d - 1;
        while (n3 >= 0) {
            double d5 = d3;
            d3 = this.getYMin() + d4 * (double)n3;
            stringBuilder.append(Utilities.format(d3)).append('\t');
            stringBuilder.append(Utilities.format(d5)).append('\t');
            int n4 = 0;
            while (n4 < this.i) {
                stringBuilder.append(this.k[n4][n3]).append('\t');
                ++n4;
            }
            stringBuilder.append(ff.h);
            --n3;
        }
        return stringBuilder.toString();
    }

    @Override
    @AnyLogicInternalAPI
    public synchronized List<List<Object>> getPlainDataTable() {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        double d2 = (this.getXMax() - this.getXMin()) / (double)this.i;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList.add(arrayList2);
        arrayList2.add("");
        arrayList2.add(hg.aag);
        int n2 = 0;
        while (n2 < this.i) {
            arrayList2.add(this.getXMin() + d2 * (double)n2);
            ++n2;
        }
        arrayList2 = new ArrayList();
        arrayList.add(arrayList2);
        arrayList2.add(hg.aag);
        arrayList2.add(hg.hjb);
        n2 = 0;
        while (n2 < this.i) {
            arrayList2.add(this.getXMin() + d2 * (double)(n2 + 1));
            ++n2;
        }
        double d3 = this.getYMax();
        double d4 = (this.getYMax() - this.getYMin()) / (double)this.d;
        int n3 = this.d - 1;
        while (n3 >= 0) {
            double d5 = d3;
            d3 = this.getYMin() + d4 * (double)n3;
            arrayList2 = new ArrayList();
            arrayList.add(arrayList2);
            arrayList2.add(d3);
            arrayList2.add(d5);
            int n4 = 0;
            while (n4 < this.i) {
                arrayList2.add(this.k[n4][n3]);
                ++n4;
            }
            --n3;
        }
        return arrayList;
    }

    @Override
    protected final void a(ga ga2, boolean bl2) {
        double d2;
        ga2.a("\"Envelopes\";");
        int n2 = 0;
        while (n2 < this.n.length) {
            ga2.a(com.anylogic.engine.internal.n.a(this.n[n2]));
            if (n2 + 1 < this.n.length) {
                ga2.a(';');
            }
            ++n2;
        }
        ga2.a();
        double d3 = (this.getXMax() - this.getXMin()) / (double)this.i;
        ga2.a(";\"From\"");
        int n3 = 0;
        while (n3 < this.i) {
            ga2.a(';');
            d2 = this.getXMin() + d3 * (double)n3;
            ga2.a(com.anylogic.engine.internal.n.a(d2));
            ++n3;
        }
        ga2.a();
        ga2.a("\"From\";\"To\"");
        n3 = 0;
        while (n3 < this.i) {
            ga2.a(';');
            d2 = this.getXMin() + d3 * (double)(n3 + 1);
            ga2.a(com.anylogic.engine.internal.n.a(d2));
            ++n3;
        }
        ga2.a();
        double d4 = this.getYMax();
        ga2.a(com.anylogic.engine.internal.n.a(d4));
        ga2.a(";");
        ga2.a(com.anylogic.engine.internal.n.a(Double.POSITIVE_INFINITY));
        int n4 = 0;
        while (n4 < this.i) {
            ga2.a(';');
            ga2.a(this.ac[n4]);
            ++n4;
        }
        ga2.a();
        double d5 = (this.getYMax() - this.getYMin()) / (double)this.d;
        int n5 = this.d - 1;
        while (n5 >= 0) {
            double d6 = d4;
            d4 = this.getYMin() + d5 * (double)n5;
            ga2.a(com.anylogic.engine.internal.n.a(d4));
            ga2.a(';');
            ga2.a(com.anylogic.engine.internal.n.a(d6));
            int n6 = 0;
            while (n6 < this.i) {
                ga2.a(';');
                ga2.a(this.k[n6][n5]);
                ++n6;
            }
            ga2.a();
            --n5;
        }
        ga2.a(com.anylogic.engine.internal.n.a(Double.NEGATIVE_INFINITY));
        ga2.a(";");
        ga2.a(com.anylogic.engine.internal.n.a(d4));
        n5 = 0;
        while (n5 < this.i) {
            ga2.a(';');
            ga2.a(this.e[n5]);
            ++n5;
        }
        ga2.a();
        ga2.n(j);
    }

    @Override
    protected final String a(gk gk2) throws Exception {
        String string = gk2.a();
        if (string == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        if (!string.startsWith("\"Envelopes\";")) {
            throw new Exception(hg.lkn);
        }
        this.reset();
        Pattern pattern = Pattern.compile("\\s*\\;\\s*");
        String[] stringArray = pattern.split(string.substring("\"Envelopes\";".length()));
        double[] dArray = new double[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            dArray[n2] = com.anylogic.engine.internal.n.a(stringArray[n2]);
            ++n2;
        }
        this.setEnvelopes(dArray);
        string = gk2.a();
        if (string == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        if (!string.startsWith(";\"From\"")) {
            throw new Exception(hg.din);
        }
        string = gk2.a();
        if (string == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        if (!string.startsWith("\"From\";\"To\"")) {
            throw new Exception(hg.din);
        }
        this.a(gk2, this.ac, pattern);
        n2 = this.d - 1;
        while (n2 >= 0) {
            this.a(gk2, this.k, n2, pattern);
            --n2;
        }
        this.a(gk2, this.e, pattern);
        n2 = 0;
        while (n2 < this.k.length) {
            this.mk[n2] = this.e[n2];
            int n3 = 0;
            while (n3 < this.d) {
                int n4 = n3 == 0 ? this.mk[n2] : this.m[n2][n3 - 1];
                this.m[n2][n3] = n4 + this.k[n2][n3];
                ++n3;
            }
            this.nd[n2] = this.m[n2][this.d - 1] + this.ac[n2];
            ++n2;
        }
        ++this.a;
        String string2 = gk2.a();
        if (string2 == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        return string2.length() > 0 ? string2 : null;
    }

    private void a(gk gk2, int[] nArray, Pattern pattern) throws Exception {
        String string = gk2.a();
        if (string == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        String[] stringArray = pattern.split(string);
        if (stringArray.length < nArray.length + 2) {
            throw new Exception(String.format(hg.mlm, nArray.length + 2));
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            nArray[n2] = n3 = Integer.parseInt(stringArray[n2 + 2]);
            if (n3 > this.h[n2]) {
                this.h[n2] = n3;
            }
            int n4 = n2++;
            this.f[n4] = this.f[n4] + n3;
        }
    }

    private void a(gk gk2, int[][] nArray, int n2, Pattern pattern) throws Exception {
        String string = gk2.a();
        if (string == null) {
            throw com.anylogic.engine.internal.n.a();
        }
        String[] stringArray = pattern.split(string);
        if (stringArray.length < nArray.length + 2) {
            throw new Exception(String.format(hg.mlm, nArray.length + 2));
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4;
            nArray[n3][n2] = n4 = Integer.parseInt(stringArray[n3 + 2]);
            if (n4 > this.h[n3]) {
                this.h[n3] = n4;
            }
            int n5 = n3++;
            this.f[n5] = this.f[n5] + n4;
        }
    }
}

