/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine;

import com.anylogic.engine.AbstractShapeGISMap;
import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentExtension;
import com.anylogic.engine.AgentExtensionFactory;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.ExtAgentGIS;
import com.anylogic.engine.ExtAgentInteractive;
import com.anylogic.engine.ExtEnvironmentGIS;
import com.anylogic.engine.ExtEnvironmentInteractive;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.SpaceType;
import com.anylogic.engine.TimeUnits;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.b;
import com.anylogic.engine.cb;
import com.anylogic.engine.f;
import com.anylogic.engine.g;
import com.anylogic.engine.gis.IGISRouteProvider;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.k;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.GISRoute;
import com.anylogic.engine.n;
import com.anylogic.engine.presentation.AgentAnimationSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class cm
extends cb<b, GISNode, GISRoute, IGISRouteProvider>
implements ExtAgentGIS {
    private static final long serialVersionUID = -1907413971104002697L;
    private static final Set<Class<?>> c;

    static {
        AgentExtensionFactory.register(ExtAgentGIS.class, new AgentExtensionFactory<ExtAgentGIS>(){

            public ExtAgentGIS a(Agent agent) {
                ExtAgentInteractive extAgentInteractive = (ExtAgentInteractive)agent.tryExt(EXT_AGENT_INTERACTIVE);
                if (extAgentInteractive != null) {
                    agent.error(hg.ecc, extAgentInteractive.getSpaceType().formatName(), SPACE_GIS.formatName());
                }
                return new cm(agent);
            }

            @Override
            public /* synthetic */ AgentExtension create(Agent agent) {
                return this.a(agent);
            }
        });
        c = cm.getSupportedInterfaces_xjal(cm.class);
    }

    @Override
    @AnyLogicInternalAPI
    public boolean supportsInterface_xjal(Class<?> clazz) {
        return c.contains(clazz);
    }

    public cm(Agent agent) {
        super(agent);
        this.mk();
    }

    private void mk() {
    }

    @Override
    public SpaceType getSpaceType() {
        return SPACE_GIS;
    }

    @Override
    void a(StringBuilder stringBuilder) {
        stringBuilder.append(hg.ak).append(Utilities.formatLatitude(this.a.getLatitude())).append(ff.h);
        stringBuilder.append(hg.gc).append(Utilities.formatLongitude(this.a.getLongitude())).append(ff.h);
        stringBuilder.append(hg.bh).append(Utilities.format(this.a.getRotation())).append(ff.h);
        stringBuilder.append(hg.bf).append(Utilities.formatGeoHeading(this.getGISHeading())).append(ff.h);
        stringBuilder.append(hg.bi).append(this.getSpeed()).append(hg.be).append(ff.h);
        stringBuilder.append(hg.ca);
        if (this.isMoving()) {
            stringBuilder.append(String.format(hg.kn, Utilities.formatLatitude(this.getTargetLat()), Utilities.formatLongitude(this.getTargetLon())));
        } else {
            stringBuilder.append(hg.kh);
        }
        stringBuilder.append(ff.h);
    }

    @Override
    public double getAnimationX() {
        return this.nd().x;
    }

    @Override
    public double getAnimationY() {
        return this.nd().y;
    }

    private Point nd() {
        Point point = this.a.getXYZ();
        AbstractShapeGISMap abstractShapeGISMap = this.mf();
        abstractShapeGISMap.convertForward(point.x, point.y, point);
        Point point2 = e.a(abstractShapeGISMap, point);
        return point2;
    }

    @Override
    public double getAnimationZ() {
        return this.a.getZ();
    }

    @Override
    public Position getAnimationPosition(Position position) {
        position = this.a.getPosition(position);
        AbstractShapeGISMap abstractShapeGISMap = this.mf();
        abstractShapeGISMap.convertForward(position.x, position.y, position);
        return e.a(abstractShapeGISMap, position);
    }

    @Override
    @AnyLogicInternalAPI
    public boolean isAnimationVisible_xjal() {
        return super.isAnimationVisible_xjal() && this.mf().projectionContains(this.a.getX(), this.a.getY());
    }

    @Override
    public double getPresentationScaleOnOwnerSpace() {
        AgentList<?> agentList = this.a.getPopulation();
        AgentAnimationSettings agentAnimationSettings = agentList != null ? agentList.getOwner().getAnimationSettingsOf(agentList) : this.a.getOwner().getAnimationSettingsOf(this.a);
        if (agentAnimationSettings != null) {
            double d2 = 1.0 / this.mf().getMapScale();
            if (d2 > (double)agentAnimationSettings.getFixedSizeScaleValue()) {
                return 0.0;
            }
            if (d2 < (double)agentAnimationSettings.getRealSizeScaleValue()) {
                return 1.0 / this.getAgent().getScale().pixelsPerUnit(LengthUnits.METER) / this.mf().getMPP();
            }
        }
        return 1.0;
    }

    @Override
    public double getLat() {
        return this.a.getX();
    }

    @Override
    public double getLon() {
        return this.a.getY();
    }

    @Override
    public double getGISHeading() {
        this.mf();
        if (this.i == null) {
            return 0.0;
        }
        return ((b)this.c()).mk();
    }

    @Override
    public double distanceTo(Agent agent) {
        return this.mf().getDistance(this.a.getX(), this.a.getY(), agent.getX(), agent.getY());
    }

    @Override
    public double distanceByRoute(Agent agent) {
        return this.hl().getDistance(this.a.getX(), this.a.getY(), agent.getX(), agent.getY());
    }

    @Override
    public double distanceTo(Agent agent, LengthUnits lengthUnits) {
        double d2 = this.distanceTo(agent);
        return LengthUnits.METER.convertTo(d2, lengthUnits);
    }

    @Override
    public double distanceTo(Point point) {
        return this.distanceTo(point.x, point.y);
    }

    @Override
    public double distanceTo(Point point, LengthUnits lengthUnits) {
        double d2 = this.distanceTo(point.x, point.y);
        return LengthUnits.METER.convertTo(d2, lengthUnits);
    }

    @Override
    public double distanceTo(double d2, double d3) {
        return this.mf().getDistance(this.a.getX(), this.a.getY(), d2, d3);
    }

    @Override
    public double distanceTo(double d2, double d3, LengthUnits lengthUnits) {
        double d4 = this.distanceTo(d2, d3);
        return LengthUnits.METER.convertTo(d4, lengthUnits);
    }

    @Override
    public <T extends Agent> T getNearestAgent(Iterable<T> iterable) {
        Agent agent = null;
        double d2 = Double.POSITIVE_INFINITY;
        for (Agent agent2 : iterable) {
            double d3 = this.distanceTo(agent2);
            if (!(d3 < d2) || agent2 == this.a) continue;
            agent = agent2;
            d2 = d3;
        }
        return (T)agent;
    }

    @Override
    public <T extends Agent> T getNearestAgentByRoute(Iterable<T> iterable) {
        Agent agent = null;
        double d2 = Double.POSITIVE_INFINITY;
        for (Agent agent2 : iterable) {
            double d3 = this.distanceByRoute(agent2);
            if (!(d3 < d2) || agent2 == this.a) continue;
            agent = agent2;
            d2 = d3;
        }
        return (T)agent;
    }

    @Override
    public void moveToNearestAgent(Iterable<? extends Agent> iterable) {
        this.moveToNearestAgent(iterable, -1.0);
    }

    @Override
    public void moveToNearestAgent(Iterable<? extends Agent> iterable, double d2) {
        this.stop();
        Agent agent = this.getNearestAgent(iterable);
        if (agent != null) {
            this.moveToInTime(agent.getX(), agent.getY(), d2);
        }
    }

    @Override
    public <T extends Agent> List<T> agentsInRange(Iterable<T> iterable, double d2) {
        ArrayList<Agent> arrayList = new ArrayList<Agent>();
        for (Agent agent : iterable) {
            if (!(this.distanceTo(agent) <= d2) || agent == this.a) continue;
            arrayList.add(agent);
        }
        return arrayList;
    }

    @Override
    public <T extends Agent> List<T> agentsInRange(Iterable<T> iterable, double d2, LengthUnits lengthUnits) {
        this.k();
        double d3 = lengthUnits.convertTo(d2, LengthUnits.METER);
        return this.agentsInRange(iterable, d3);
    }

    @Override
    public void jumpTo(Point point) {
        this.jumpTo(point.x, point.y);
    }

    @Override
    public void jumpTo(double d2, double d3) {
        this.mf();
        this.stop();
        this.a.setXY(d2, d3);
    }

    @Override
    public void moveTo(double d2, double d3) {
        this.moveToInTime(d2, d3, -1.0);
    }

    @Override
    public void moveToInTime(double d2, double d3, double d4) {
        if (d4 == 0.0) {
            this.jumpTo(d2, d3);
            return;
        }
        this.mf();
        this.stop();
        this.i().a(new Position(d2, d3, ff.a(ff.n(this.a.getX(), this.a.getY(), d2, d3))), d4);
    }

    @Override
    public void moveToStraight(Point point) {
        this.moveToStraightInTime(point, -1.0);
    }

    @Override
    public void moveToStraightInTime(Point point, double d2, TimeUnits timeUnits) {
        double d3 = this.getAgent().toModelTime(d2, timeUnits);
        this.moveToStraightInTime(point, d3);
    }

    @Override
    public void moveToStraightInTime(Point point, double d2) {
        if (d2 == 0.0) {
            this.jumpTo(point);
            return;
        }
        this.mf();
        this.stop();
        if (this.d() && d2 < 0.0) {
            return;
        }
        this.i().a(point, d2);
        if (this.j != null) {
            this.j.a(this.j.h(), null, null);
        }
    }

    @Override
    public void moveTo(String string) {
        GISPoint gISPoint = this.mf().searchFirst(string);
        if (gISPoint != null) {
            this.moveTo(gISPoint.getLatitude(), gISPoint.getLongitude());
        }
    }

    @Override
    public void jumpTo(String string) {
        GISPoint gISPoint = this.mf().searchFirst(string);
        if (gISPoint != null) {
            this.jumpTo(gISPoint.getLatitude(), gISPoint.getLongitude());
        }
    }

    @Override
    public double getTargetX() {
        this.mf();
        if (this.isMoving()) {
            return this.i.b();
        }
        return this.a.getX();
    }

    @Override
    public double getTargetY() {
        this.mf();
        if (this.isMoving()) {
            return AbstractShapeGISMap.a(this.i.f());
        }
        return AbstractShapeGISMap.a(this.a.getY());
    }

    @Override
    public double getTargetLon() {
        return this.getTargetY();
    }

    @Override
    public double getTargetLat() {
        return this.getTargetX();
    }

    @Override
    @AnyLogicInternalAPI
    public void onDestroy() {
        this.stop();
        if (this.i != null) {
            this.i.d();
        }
        super.onDestroy();
    }

    ExtEnvironmentGIS e() {
        if (this.m == null) {
            throw this.error(hg.na);
        }
        return (ExtEnvironmentGIS)this.m.ext(EXT_ENVIRONMENT_GIS);
    }

    @Override
    public void updatePosition() {
        if (this.isMoving()) {
            this.i.c();
        }
    }

    @Override
    @Deprecated
    public double getVelocity() {
        return this.getSpeed();
    }

    @Override
    @Deprecated
    public void setVelocity(double d2) {
        this.setSpeed(d2);
    }

    @Override
    double l() {
        return this.g() / this.a.second();
    }

    @Override
    void a(double d2) {
        this.n(d2 * this.a.second());
    }

    @Override
    boolean isAutomaticVerticalRotation() {
        return false;
    }

    @Override
    @AnyLogicInternalAPI
    public AbstractShapeGISMap getGISMap() {
        return this.mf();
    }

    private AbstractShapeGISMap mf() {
        AbstractShapeGISMap abstractShapeGISMap = this.k().getGISMap();
        if (abstractShapeGISMap == null) {
            this.error("GIS space required (the space agent %s has no GIS map object)", this.getSpace());
        }
        return abstractShapeGISMap;
    }

    private IGISRouteProvider hl() {
        this.h();
        Object r = this.j.d();
        if (r == null) {
            this.j.a(this.mf().getRouteProvider());
        }
        return (IGISRouteProvider)this.j.d();
    }

    b ac() {
        return new b((cb)this, this.hl());
    }

    b k(k k2) {
        return new b(k2, this.hl());
    }

    @Override
    g f() {
        return new f(this);
    }

    @Override
    g n(k k2) {
        return new f(k2);
    }

    @Override
    /* synthetic */ ExtEnvironmentInteractive a() {
        return this.e();
    }

    @Override
    /* synthetic */ n a(k k2) {
        return this.k(k2);
    }

    @Override
    /* synthetic */ n b() {
        return this.ac();
    }
}

