/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.database.DatabaseLogFunctions;
import com.anylogic.engine.database.DatabaseLogTableType;
import com.anylogic.engine.database.DatabaseLoggingObjectDescriptor;
import com.anylogic.engine.database.LoggingType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@AnyLogicInternalAPI
public enum DatabaseLogViews implements DatabaseLoggingObjectDescriptor
{
    AGENTS("agents", "SELECT %4$s(agent_types.NAME) type, %5$s(agents.NAME, agents.ID) name, agents.DATE BirthDate, destroyed_agents.DATE DeathDate FROM %1$s agent_types INNER JOIN %2$s agents ON agent_types.ID = agents.AGENT_TYPE_ID LEFT JOIN %3$s destroyed_agents ON agents.ID = destroyed_agents.AGENT_ID WHERE agent_types.NAME NOT LIKE 'com.anylogic.libraries.%%' ORDER BY type, name", DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.DESTROYED_AGENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    LIBRARY_BLOCKS("library_blocks", "SELECT %4$s(agent_types.NAME) type, %5$s(agents.NAME, agents.ID) name, agents.DATE BirthDate, destroyed_agents.DATE DeathDate FROM %1$s agent_types INNER JOIN %2$s agents ON agent_types.ID = agents.AGENT_TYPE_ID LEFT JOIN %3$s destroyed_agents ON agents.ID = destroyed_agents.AGENT_ID WHERE agent_types.NAME LIKE 'com.anylogic.libraries.%%' ORDER BY type, name", DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.DESTROYED_AGENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_PARAMETERS("agent_parameters", "SELECT %4$s(agent_types.NAME) agent_type, %5$s(agents.NAME, agents.ID) agent, parameters.PARAMETER_NAME parameter_name, parameters.PARAMETER_VALUE parameter_value FROM %1$s parameters INNER JOIN %2$s agents ON parameters.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID WHERE agent_types.NAME NOT LIKE 'com.anylogic.libraries.%%' ORDER BY agent_type, agent", DatabaseLogTableType.AGENT_PARAMETERS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    LIBRARY_BLOCK_PARAMETERS("library_block_parameters", "SELECT %4$s(agent_types.NAME) block_type, %5$s(agents.NAME, agents.ID) block, parameters.PARAMETER_NAME parameter_name, parameters.PARAMETER_VALUE parameter_value FROM %1$s parameters INNER JOIN %2$s agents ON parameters.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID WHERE agent_types.NAME LIKE 'com.anylogic.libraries.%%' ORDER BY block_type, block", DatabaseLogTableType.AGENT_PARAMETERS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_MOVEMENT("agent_movement", "SELECT %4$s(agent_types.NAME) type, %5$s(agents.NAME, agents.ID) agent, agent_movement.SPEED speed, agent_movement.START_DATE start_date, agent_movement.STOP_DATE stop_date FROM %1$s agent_movement INNER JOIN %2$s agents ON agent_movement.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY start_date", DatabaseLogTableType.AGENT_MOVEMENT, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_MOVEMENT_STATS("agent_movement_stats", "SELECT %4$s(agent_types.NAME) type, %5$s(agents.NAME, agents.ID) agent, agent_movement.total_meters total_meters, agent_movement.total_seconds total_seconds, agent_movement.avg_speed_mps avg_speed_mps FROM (   SELECT     AGENT_ID,     SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE ) * SPEED) / 1000 total_meters,     SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 total_seconds,     SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE ) * SPEED)       / SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) avg_speed_mps   FROM %1$s   GROUP BY AGENT_ID) agent_movement INNER JOIN %2$s agents ON agent_movement.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY type, agent", DatabaseLogTableType.AGENT_MOVEMENT, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_MESSAGES("agent_messages", "SELECT am.MESSAGE message, %5$s(a1.NAME, a1.ID) recipient, %4$s(at1.NAME) recipient_type, %5$s(a2.NAME, a2.ID) sender, %4$s(at2.NAME) sender_type, am.DATE date, am.COUNTER counter FROM %1$s am INNER JOIN %2$s a1 ON am.AGENT_ID = a1.ID INNER JOIN %3$s at1 ON a1.AGENT_TYPE_ID = at1.ID LEFT JOIN %2$s a2 ON am.SENDER_ID = a2.ID LEFT JOIN %3$s at2 ON a2.AGENT_TYPE_ID = at2.ID ORDER BY am.COUNTER", DatabaseLogTableType.AGENT_MESSAGES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    EVENTS("events", "SELECT agent_type_elements.NAME event_name, events.DATE date, %5$s(agent_types.NAME) agent_type, %6$s(agents.NAME, agents.ID) agent FROM %1$s events INNER JOIN %2$s agent_type_elements ON events.EVENT_ID = agent_type_elements.ID INNER JOIN %3$s agents ON agent_type_elements.AGENT_TYPE_ID = agents.ID INNER JOIN %4$s agent_types ON agent_type_elements.AGENT_TYPE_ID = agent_types.ID ORDER BY events.DATE", DatabaseLogTableType.EVENTS, DatabaseLogTableType.AGENT_TYPE_ELEMENTS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLOWCHART_ENTRIES("flowchart_entries", "SELECT \tflowchart_entries.COUNTER counter, \t%4$s(agent_types.NAME) agent_type, \t%5$s(agents.NAME, agents.ID) agent, \t%4$s(block_types.NAME) block_type, \t%5$s(blocks.NAME, blocks.ID) block, \tflowchart_entries.ENTRY_DATE entry_date FROM %1$s flowchart_entries INNER JOIN %2$s agents ON flowchart_entries.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID LEFT JOIN %2$s blocks ON flowchart_entries.BLOCK_ID = blocks.ID LEFT JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY flowchart_entries.ENTRY_DATE", DatabaseLogTableType.FLOWCHART_ENTRIES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLOWCHART_PROCESS_STATES("flowchart_process_states", "SELECT %4$s(agent_types.NAME) agent_type, %5$s(agents.NAME, agents.ID) agent, %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, flowchart_process_states.ACTIVITY_TYPE activity_type, flowchart_process_states.START_DATE start_date, flowchart_process_states.STOP_DATE stop_date FROM %1$s flowchart_process_states INNER JOIN %2$s agents ON flowchart_process_states.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID INNER JOIN %2$s blocks ON flowchart_process_states.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY flowchart_process_states.START_DATE", DatabaseLogTableType.FLOWCHART_PROCESS_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLOWCHART_STATS_TIME_IN_STATE("flowchart_stats_time_in_state", "SELECT %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, flowchart_process_states.activity_type activity_type, flowchart_process_states.mean_seconds mean_seconds, flowchart_process_states.total_seconds total_seconds, flowchart_process_states.min_seconds min_seconds, flowchart_process_states.max_seconds max_seconds, flowchart_process_states.n_agents n_agents FROM (   SELECT     BLOCK_ID block_id,     ACTIVITY_TYPE activity_type,     AVG(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 mean_seconds,     SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 total_seconds,     MIN(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 min_seconds,     MAX(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 max_seconds,     COUNT( DISTINCT AGENT_ID ) n_agents   FROM %1$s flowchart_process_states   GROUP BY BLOCK_ID, ACTIVITY_TYPE) flowchart_process_states INNER JOIN %2$s blocks ON flowchart_process_states.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY block_type, block, activity_type", DatabaseLogTableType.FLOWCHART_PROCESS_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    RESOURCE_UNIT_STATES("resource_unit_states", "SELECT %4$s(unit_types.NAME) unit_type, %5$s(units.NAME, units.ID) unit, %5$s(pools.NAME, pools.ID) resource_pool, resource_unit_states.USAGE_STATE usage_state, CASE WHEN resource_unit_states.TASK_TYPE = 'TASK_CUSTOM' THEN %5$s(tasks.NAME, tasks.ID) ELSE resource_unit_states.TASK_TYPE END task, %4$s(agent_types.NAME) agent_type, %5$s(agents.NAME, agents.ID) agent, resource_unit_states.START_DATE start_date, resource_unit_states.STOP_DATE stop_date FROM %1$s resource_unit_states INNER JOIN %2$s units ON resource_unit_states.UNIT_ID = units.ID INNER JOIN %3$s unit_types ON units.AGENT_TYPE_ID = unit_types.ID INNER JOIN %2$s pools ON resource_unit_states.POOL_ID = pools.ID LEFT JOIN %2$s agents ON resource_unit_states.AGENT_ID = agents.ID LEFT JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID LEFT JOIN %2$s tasks ON resource_unit_states.TASK_ID = tasks.ID ORDER BY resource_unit_states.START_DATE", DatabaseLogTableType.RESOURCE_UNIT_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    RESOURCE_UNIT_TASK_STATS("resource_unit_task_stats", "SELECT %4$s(unit_types.NAME) unit_type, %5$s(pools.NAME, pools.ID) resource_pool, %5$s(units.NAME, units.ID) unit, CASE WHEN resource_unit_states.TASK_TYPE = 'TASK_CUSTOM' THEN %5$s(tasks.NAME, tasks.ID) ELSE resource_unit_states.TASK_TYPE END task, resource_unit_states.mean_seconds mean_seconds, resource_unit_states.total_seconds total_seconds, resource_unit_states.n_tasks n_tasks FROM (   SELECT     UNIT_ID unit_id,     POOL_ID pool_id,     TASK_TYPE task_type,     TASK_ID task_id,     AVG(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 mean_seconds,     SUM(CAST( DATEDIFF('millisecond', START_DATE, STOP_DATE) AS DOUBLE )) / 1000 total_seconds,     COUNT(START_DATE) n_tasks   FROM %1$s   GROUP BY UNIT_ID, POOL_ID, TASK_TYPE, TASK_ID ) resource_unit_states INNER JOIN %2$s units ON resource_unit_states.UNIT_ID = units.ID INNER JOIN %3$s unit_types ON units.AGENT_TYPE_ID = unit_types.ID INNER JOIN %2$s pools ON resource_unit_states.POOL_ID = pools.ID LEFT JOIN %2$s tasks ON resource_unit_states.TASK_ID = tasks.ID ORDER BY unit_type, resource_pool, unit, resource_unit_states.TASK_TYPE, tasks.NAME", DatabaseLogTableType.RESOURCE_UNIT_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    RESOURCE_POOL_TASK_STATS("resource_pool_task_stats", "SELECT %4$s(unit_types.NAME) unit_type, %5$s(pools.NAME, pools.ID) resource_pool, CASE WHEN resource_unit_states.TASK_TYPE = 'TASK_CUSTOM' THEN tasks.NAME ELSE resource_unit_states.TASK_TYPE END task, resource_unit_states.mean_seconds mean_seconds, resource_unit_states.total_seconds total_seconds, resource_unit_states.n_tasks n_tasks FROM (   SELECT     u.AGENT_TYPE_ID unit_type_id,     s.POOL_ID pool_id,     s.TASK_TYPE task_type,     s.TASK_ID task_id,     AVG(CAST( DATEDIFF('millisecond', s.START_DATE, s.STOP_DATE) AS DOUBLE )) / 1000 mean_seconds,     SUM(CAST( DATEDIFF('millisecond', s.START_DATE, s.STOP_DATE) AS DOUBLE )) / 1000 total_seconds,     COUNT(s.START_DATE) n_tasks   FROM %1$s s   INNER JOIN %2$s u ON s.UNIT_ID = u.ID   GROUP BY u.AGENT_TYPE_ID, s.POOL_ID, s.TASK_TYPE, s.TASK_ID ) resource_unit_states INNER JOIN %3$s unit_types ON resource_unit_states.unit_type_id = unit_types.ID INNER JOIN %2$s pools ON resource_unit_states.POOL_ID = pools.ID LEFT JOIN %2$s tasks ON resource_unit_states.TASK_ID = tasks.ID ORDER BY unit_type, resource_pool, resource_unit_states.TASK_TYPE, tasks.NAME", DatabaseLogTableType.RESOURCE_UNIT_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    RESOURCE_POOL_UTILIZATION("resource_pool_utilization", "SELECT %3$s(pools.NAME, pools.ID) resource_pool, resource_pool_utilization.UTILIZATION utilization, resource_pool_utilization.SIZE size FROM %1$s resource_pool_utilization INNER JOIN %2$s pools ON resource_pool_utilization.POOL_ID = pools.ID ORDER BY resource_pool", DatabaseLogTableType.RESOURCE_POOL_UTILIZATION, DatabaseLogTableType.AGENTS, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    RESOURCE_UNIT_UTILIZATION("resource_unit_utilization", "SELECT %4$s(unit_types.NAME) unit_type, %5$s(pools.NAME, pools.ID) resource_pool, %5$s(units.NAME, units.ID) unit, resource_unit_utilization.UTILIZATION utilization FROM %1$s resource_unit_utilization INNER JOIN %2$s units ON resource_unit_utilization.UNIT_ID = units.ID INNER JOIN %3$s unit_types ON units.AGENT_TYPE_ID = unit_types.ID INNER JOIN %2$s pools ON resource_unit_utilization.POOL_ID = pools.ID ORDER BY unit_type, resource_pool", DatabaseLogTableType.RESOURCE_UNIT_UTILIZATION, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLUID_UNITS("fluid_units", "SELECT %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, units.AMOUNT_UNITS amount_units, units.RATE_UNITS rate_units FROM %1$s units INNER JOIN %2$s blocks ON units.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY block_type, block", DatabaseLogTableType.FLUID_UNITS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLUID_STORAGES("fluid_storages", "SELECT %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, storages.MINIMUM minimum, storages.MAXIMUM maximum, storages.AVERAGE average FROM %1$s storages INNER JOIN %2$s blocks ON storages.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY block_type, block", DatabaseLogTableType.FLUID_STORAGES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLUID_RATES("fluid_rates", "SELECT %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, rates.PORT port, rates.TOTAL total_amount,rates.MINIMUM minimum_rate, rates.MAXIMUM maximum_rate, rates.AVERAGE average_rate FROM %1$s rates INNER JOIN %2$s blocks ON rates.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY block_type, block", DatabaseLogTableType.FLUID_RATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    FLUID_UTILIZATION("fluid_utilization", "SELECT %4$s(block_types.NAME) block_type, %5$s(blocks.NAME, blocks.ID) block, utilization.UTILIZATION utilization FROM %1$s utilization INNER JOIN %2$s blocks ON utilization.BLOCK_ID = blocks.ID INNER JOIN %3$s block_types ON blocks.AGENT_TYPE_ID = block_types.ID ORDER BY block_type, block", DatabaseLogTableType.FLUID_UTILIZATION, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    STATECHART_TRANSITIONS("statechart_transitions", "SELECT %5$s(agent_types.NAME) agent_type, %6$s(agents.NAME, agents.ID) agent, transitions.NAME transition, states.NAME from_state, statechart_transitions.DATE date FROM %1$s statechart_transitions INNER JOIN %2$s agents ON statechart_transitions.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID LEFT JOIN %4$s transitions ON statechart_transitions.TRANSITION_ID = transitions.ID INNER JOIN %4$s states ON statechart_transitions.FROM_STATE_ID = states.ID ORDER BY statechart_transitions.DATE", DatabaseLogTableType.STATECHART_TRANSITIONS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENT_TYPE_ELEMENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_STATECHART_STATES("agent_statechart_states", "SELECT %6$s(agent_types.NAME) agent_type, %7$s(agents.NAME, agents.ID) agent, elements_statecharts.NAME statechart, elements_states.NAME state, statechart_states.ENTRY_DATE entry_date, statechart_states.EXIT_DATE exit_date FROM %1$s statechart_states INNER JOIN %2$s agents ON statechart_states.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID INNER JOIN %4$s agent_type_statecharts ON agent_type_statecharts.ELEMENT_ID = statechart_states.STATE_ID INNER JOIN %5$s elements_statecharts ON agent_type_statecharts.STATECHART_ID = elements_statecharts.ID INNER JOIN %5$s elements_states ON statechart_states.STATE_ID = elements_states.ID ORDER BY agent_type, agent, statechart, statechart_states.ENTRY_DATE", DatabaseLogTableType.STATECHART_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENT_TYPE_STATECHARTS, DatabaseLogTableType.AGENT_TYPE_ELEMENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_STATECHART_STATS("agent_statechart_stats", "SELECT %6$s(agent_types.NAME) agent_type, %7$s(agents.NAME, agents.ID) agent, elements_statecharts.NAME statechart, elements_states.NAME state, statechart_states.mean_seconds mean_seconds, statechart_states.total_seconds total_seconds, statechart_states.n_entries n_entries FROM (   SELECT     AGENT_ID agent_id,     STATE_ID state_id,     AVG(CAST( DATEDIFF('millisecond', ENTRY_DATE, EXIT_DATE) AS DOUBLE )) / 1000 mean_seconds,     SUM(CAST( DATEDIFF('millisecond', ENTRY_DATE, EXIT_DATE) AS DOUBLE )) / 1000 total_seconds,     COUNT(ENTRY_DATE) n_entries   FROM %1$s   GROUP BY AGENT_ID, STATE_ID ) statechart_states INNER JOIN %2$s agents ON statechart_states.AGENT_ID = agents.ID INNER JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID INNER JOIN %4$s agent_type_statecharts ON agent_type_statecharts.ELEMENT_ID = statechart_states.STATE_ID INNER JOIN %5$s elements_statecharts ON agent_type_statecharts.STATECHART_ID = elements_statecharts.ID INNER JOIN %5$s elements_states ON statechart_states.STATE_ID = elements_states.ID ORDER BY agent_type, agent, statechart, state", DatabaseLogTableType.STATECHART_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENT_TYPE_STATECHARTS, DatabaseLogTableType.AGENT_TYPE_ELEMENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    AGENT_TYPE_STATECHART_STATS("agent_type_statechart_stats", "SELECT %6$s(agent_types.NAME) agent_type, elements_statecharts.NAME statechart, elements_states.NAME state, statechart_states.mean_seconds mean_seconds, statechart_states.total_seconds total_seconds, statechart_states.min_seconds min_seconds, statechart_states.max_seconds max_seconds, statechart_states.n_entries n_entries FROM (   SELECT     a.AGENT_TYPE_ID agent_type_id,     s.STATE_ID state_id,     AVG(CAST( DATEDIFF('millisecond', s.ENTRY_DATE, s.EXIT_DATE) AS DOUBLE )) / 1000 mean_seconds,     SUM(CAST( DATEDIFF('millisecond', s.ENTRY_DATE, s.EXIT_DATE) AS DOUBLE )) / 1000 total_seconds,     MIN(CAST( DATEDIFF('millisecond', s.ENTRY_DATE, s.EXIT_DATE) AS DOUBLE )) / 1000 min_seconds,     MAX(CAST( DATEDIFF('millisecond', s.ENTRY_DATE, s.EXIT_DATE) AS DOUBLE )) / 1000 max_seconds,     COUNT(s.ENTRY_DATE) n_entries   FROM %1$s s   INNER JOIN %2$s a ON s.AGENT_ID = a.ID   GROUP BY a.AGENT_TYPE_ID, s.STATE_ID ) statechart_states INNER JOIN %3$s agent_types ON statechart_states.agent_type_id = agent_types.ID INNER JOIN %4$s agent_type_statecharts ON agent_type_statecharts.ELEMENT_ID = statechart_states.STATE_ID INNER JOIN %5$s elements_statecharts ON agent_type_statecharts.STATECHART_ID = elements_statecharts.ID INNER JOIN %5$s elements_states ON statechart_states.STATE_ID = elements_states.ID ORDER BY agent_type, statechart, state", DatabaseLogTableType.STATECHART_STATES, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogTableType.AGENT_TYPE_STATECHARTS, DatabaseLogTableType.AGENT_TYPE_ELEMENTS, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME),
    STATISTICS("statistics", "SELECT %4$s(agent_types.NAME) agent_type, %5$s(agents.NAME, agents.ID) agent, statistics.NAME name, statistics.MEAN mean, statistics.DEVIATION deviation, statistics.MINIMUM minimum, statistics.MAXIMUM maximum, statistics.MEAN_CONFIDENCE mean_confidence, statistics.NUMBER number FROM %1$s statistics LEFT JOIN %2$s agents ON statistics.AGENT_ID = agents.ID LEFT JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY agent_type, agent, statistics.NAME", DatabaseLogTableType.STATISTICS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    DATASETS("datasets", "SELECT %5$s(agent_types.NAME) agent_type, %6$s(agents.NAME, agents.ID) agent, agent_elements.NAME name, datasets.INDEX index, datasets.X x, datasets.Y y FROM %1$s datasets LEFT JOIN %2$s agent_elements ON datasets.ELEMENT_ID = agent_elements.ID LEFT JOIN %3$s agents ON agent_elements.AGENT_ID = agents.ID LEFT JOIN %4$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY agent_type, agent, agent_elements.NAME, datasets.INDEX", DatabaseLogTableType.DATASETS, DatabaseLogTableType.AGENT_ELEMENTS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    HISTOGRAMS("histograms", "SELECT %5$s(agent_types.NAME) agent_type, %6$s(agents.NAME, agents.ID) agent, agent_elements.NAME name, histograms.START start, histograms.END end, histograms.PDF pdf, histograms.CDF cdf FROM %1$s histograms LEFT JOIN %2$s agent_elements ON histograms.ELEMENT_ID = agent_elements.ID LEFT JOIN %3$s agents ON agent_elements.AGENT_ID = agents.ID LEFT JOIN %4$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY agent_type, agent, agent_elements.NAME, histograms.START", DatabaseLogTableType.HISTOGRAMS, DatabaseLogTableType.AGENT_ELEMENTS, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME),
    TRACE("trace", "SELECT trace.MESSAGE_TEXT message_text, trace.DATE date, trace.COUNTER counter, %4$s(agent_types.NAME) agent_type, %5$s(agents.NAME, agents.ID) agent FROM %1$s trace LEFT JOIN %2$s agents ON trace.AGENT_ID = agents.ID LEFT JOIN %3$s agent_types ON agents.AGENT_TYPE_ID = agent_types.ID ORDER BY trace.COUNTER", DatabaseLogTableType.TRACE_LOG, DatabaseLogTableType.AGENTS, DatabaseLogTableType.AGENT_TYPES, DatabaseLogFunctions.FORMAT_AGENT_TYPE_NAME, DatabaseLogFunctions.FORMAT_AGENT_NAME);

    private final String a;
    private final String n;
    private DatabaseLoggingObjectDescriptor[] k;
    private Set<LoggingType> m;

    private DatabaseLogViews(String string2, String string3, DatabaseLoggingObjectDescriptor ... databaseLoggingObjectDescriptorArray) {
        this.k = databaseLoggingObjectDescriptorArray;
        this.a = String.valueOf(string2) + "_log";
        this.n = DatabaseLogViews.a(this.a, String.format(string3, Arrays.stream(databaseLoggingObjectDescriptorArray).map(databaseLoggingObjectDescriptor -> databaseLoggingObjectDescriptor.getName()).toArray()));
    }

    @Override
    public String getName() {
        return this.a;
    }

    @Override
    public String getCreateSQL() {
        return this.n;
    }

    private static String a(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE VIEW ");
        stringBuilder.append(string);
        stringBuilder.append(" AS ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static DatabaseLogViews value(String string) throws EnumConstantNotPresentException {
        DatabaseLogViews[] databaseLogViewsArray = DatabaseLogViews.values();
        int n2 = databaseLogViewsArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DatabaseLogViews databaseLogViews = databaseLogViewsArray[n3];
            if (databaseLogViews.getName().equals(string)) {
                return databaseLogViews;
            }
            ++n3;
        }
        throw new EnumConstantNotPresentException(DatabaseLogViews.class, string);
    }

    @Override
    public Set<LoggingType> getLoggingTypes() {
        if (this.m == null) {
            EnumSet<LoggingType> enumSet = EnumSet.noneOf(LoggingType.class);
            DatabaseLoggingObjectDescriptor[] databaseLoggingObjectDescriptorArray = this.k;
            int n2 = this.k.length;
            int n3 = 0;
            while (n3 < n2) {
                DatabaseLoggingObjectDescriptor databaseLoggingObjectDescriptor = databaseLoggingObjectDescriptorArray[n3];
                enumSet.addAll(databaseLoggingObjectDescriptor.getLoggingTypes());
                ++n3;
            }
            this.m = Collections.unmodifiableSet(enumSet);
        }
        return this.m;
    }

    @Override
    public String getType() {
        return "VIEW";
    }

    public DatabaseLoggingObjectDescriptor[] getReferences() {
        return this.k;
    }
}

