/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.EventOriginator;
import com.anylogic.engine.Statechart;
import com.anylogic.engine.Transition;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.UtilitiesArray;
import com.anylogic.engine.analysis.DataSet;
import com.anylogic.engine.analysis.HistogramData;
import com.anylogic.engine.analysis.HistogramSimpleData;
import com.anylogic.engine.analysis.StatisticsContinuous;
import com.anylogic.engine.analysis.StatisticsDiscrete;
import com.anylogic.engine.database.DatabaseLogTableType;
import com.anylogic.engine.database.ILogEntry;
import com.anylogic.engine.database.ModelDatabase;
import com.anylogic.engine.database.UtilitiesDatabase;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

@AnyLogicInternalAPI
public class LogEntryFactory {
    private static final String[] a = new String[]{"ELEMENT_ID", "START", "END", "PDF"};
    private static final String[] n = UtilitiesArray.concatenateArrays(a, "CDF");

    public static ILogEntry agentLogEntry(Agent agent) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENTS, new String[]{"ID", "AGENT_TYPE_ID", "NAME", "DATE"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setInt(2, agent.getAgentTypeId());
            preparedStatement.setString(3, agent.getName());
            LogEntryFactory.n(agent, preparedStatement, 4);
            return preparedStatement;
        };
    }

    public static ILogEntry agentParametersLogEntry(final Agent agent) {
        final String[] stringArray = agent.getParameterNames();
        if (stringArray.length == 0) {
            return null;
        }
        return new ILogEntry(){

            @Override
            public boolean isBatch() {
                return true;
            }

            @Override
            public PreparedStatement getSQLStatement(ModelDatabase modelDatabase) throws SQLException {
                PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_PARAMETERS, new String[]{"AGENT_ID", "PARAMETER_NAME", "PARAMETER_VALUE"});
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray2[n3];
                    preparedStatement.setInt(1, agent.getId());
                    preparedStatement.setString(2, string);
                    Object t = agent.getParameter(string);
                    String string2 = UtilitiesDatabase.toStringDB(t);
                    preparedStatement.setString(3, string2);
                    preparedStatement.addBatch();
                    ++n3;
                }
                return preparedStatement;
            }
        };
    }

    public static ILogEntry agentTypeLogEntry(int n2, String string) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_TYPES, new String[]{"ID", "NAME"});
            preparedStatement.setInt(1, n2);
            preparedStatement.setString(2, string);
            return preparedStatement;
        };
    }

    public static ILogEntry agentTypeElementLogEntry(int n2, Agent agent, String string) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_TYPE_ELEMENTS, new String[]{"ID", "AGENT_TYPE_ID", "NAME"});
            preparedStatement.setInt(1, n2);
            preparedStatement.setInt(2, agent.getAgentTypeId());
            preparedStatement.setString(3, string);
            return preparedStatement;
        };
    }

    public static ILogEntry flowchartEntry(Agent agent, Agent agent2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLOWCHART_ENTRIES, new String[]{"AGENT_ID", "BLOCK_ID", "ENTRY_DATE"});
            preparedStatement.setInt(1, agent.getId());
            if (agent2 != null) {
                preparedStatement.setInt(2, agent2.getId());
            } else {
                preparedStatement.setNull(2, 4);
            }
            LogEntryFactory.n(agent, preparedStatement, 3);
            return preparedStatement;
        };
    }

    public static ILogEntry flowchartProcessStateChangedLogEntry(Agent agent, Agent agent2, Object object, long l2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLOWCHART_PROCESS_STATES, new String[]{"AGENT_ID", "BLOCK_ID", "ACTIVITY_TYPE", "START_DATE", "STOP_DATE"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setInt(2, agent2.getId());
            preparedStatement.setString(3, object.toString());
            preparedStatement.setTimestamp(4, new Timestamp(l2));
            LogEntryFactory.n(agent, preparedStatement, 5);
            return preparedStatement;
        };
    }

    public static ILogEntry resourceUnitStateChangedLogEntry(Agent agent, Agent agent2, Object object, Object object2, Agent agent3, Agent agent4, long l2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.RESOURCE_UNIT_STATES, new String[]{"UNIT_ID", "POOL_ID", "USAGE_STATE", "TASK_TYPE", "AGENT_ID", "TASK_ID", "START_DATE", "STOP_DATE"});
            int n2 = 1;
            preparedStatement.setInt(n2++, agent.getId());
            preparedStatement.setInt(n2++, agent2.getId());
            preparedStatement.setString(n2++, object.toString());
            preparedStatement.setString(n2++, object2.toString());
            if (agent3 != null) {
                preparedStatement.setInt(n2++, agent3.getId());
            } else {
                preparedStatement.setNull(n2++, 4);
            }
            if (agent4 != null) {
                preparedStatement.setInt(n2++, agent4.getId());
            } else {
                preparedStatement.setNull(n2++, 4);
            }
            preparedStatement.setTimestamp(n2++, new Timestamp(l2));
            LogEntryFactory.n(agent, preparedStatement, n2++);
            return preparedStatement;
        };
    }

    public static ILogEntry resourcePoolUtilizationLogEntry(Agent agent, double d2, int n2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.RESOURCE_POOL_UTILIZATION, new String[]{"POOL_ID", "UTILIZATION", "SIZE"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setDouble(2, d2);
            preparedStatement.setInt(3, n2);
            return preparedStatement;
        };
    }

    public static ILogEntry resourceUnitUtilizationLogEntry(Agent agent, Agent agent2, double d2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.RESOURCE_UNIT_UTILIZATION, new String[]{"UNIT_ID", "POOL_ID", "UTILIZATION"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setInt(2, agent2.getId());
            preparedStatement.setDouble(3, d2);
            return preparedStatement;
        };
    }

    public static ILogEntry fluidUnitsLogEntry(Agent agent, String string, String string2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLUID_UNITS, new String[]{"BLOCK_ID", "AMOUNT_UNITS", "RATE_UNITS"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            return preparedStatement;
        };
    }

    public static ILogEntry fluidStoragesLogEntry(Agent agent, double d2, double d3, double d4) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLUID_STORAGES, new String[]{"BLOCK_ID", "MINIMUM", "MAXIMUM", "AVERAGE"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setDouble(2, d2);
            preparedStatement.setDouble(3, d3);
            preparedStatement.setDouble(4, d4);
            return preparedStatement;
        };
    }

    public static ILogEntry fluidRatesLogEntry(Agent agent, String string, double d2, double d3, double d4, double d5) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLUID_RATES, new String[]{"BLOCK_ID", "PORT", "TOTAL", "MINIMUM", "MAXIMUM", "AVERAGE"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setDouble(3, d2);
            preparedStatement.setDouble(4, d3);
            preparedStatement.setDouble(5, d4);
            preparedStatement.setDouble(6, d5);
            return preparedStatement;
        };
    }

    public static ILogEntry fluidUtilizationLogEntry(Agent agent, double d2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.FLUID_UTILIZATION, new String[]{"BLOCK_ID", "UTILIZATION"});
            preparedStatement.setInt(1, agent.getId());
            preparedStatement.setDouble(2, d2);
            return preparedStatement;
        };
    }

    public static ILogEntry eventOccurredLogEntry(EventOriginator eventOriginator) {
        if (!eventOriginator.isLoggingToDB()) {
            return null;
        }
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.EVENTS, new String[]{"EVENT_ID", "DATE"});
            preparedStatement.setInt(1, modelDatabase.getEventId(eventOriginator));
            LogEntryFactory.n(eventOriginator.getAgent(), preparedStatement, 2);
            return preparedStatement;
        };
    }

    public static ILogEntry agentDied(Agent agent) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.DESTROYED_AGENTS, new String[]{"AGENT_ID", "DATE"});
            preparedStatement.setInt(1, agent.getId());
            LogEntryFactory.n(agent, preparedStatement, 2);
            return preparedStatement;
        };
    }

    public static ILogEntry changeAgentNameLogEntry(int n2, String string) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENTS, "ID", new String[]{"NAME"});
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n2);
            return preparedStatement;
        };
    }

    public static ILogEntry traceLogEntry(Utilities utilities, String string) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.TRACE_LOG, new String[]{"AGENT_ID", "DATE", "MESSAGE_TEXT"});
            if (utilities instanceof Agent) {
                preparedStatement.setInt(1, ((Agent)utilities).getId());
            } else {
                preparedStatement.setNull(1, 4);
            }
            LogEntryFactory.n(utilities, preparedStatement, 2);
            preparedStatement.setString(3, string);
            return preparedStatement;
        };
    }

    public static ILogEntry statechartTransitionLogEntry(Agent agent, Statechart statechart, Transition transition, short s) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.STATECHART_TRANSITIONS, new String[]{"AGENT_ID", "TRANSITION_ID", "FROM_STATE_ID", "DATE"});
            preparedStatement.setInt(1, agent.getId());
            if (transition != null) {
                preparedStatement.setInt(2, modelDatabase.getEventId(transition));
            } else {
                preparedStatement.setNull(2, 4);
            }
            preparedStatement.setInt(3, modelDatabase.getAgentTypeStateId(agent, statechart, s));
            LogEntryFactory.n(agent, preparedStatement, 4);
            return preparedStatement;
        };
    }

    public static ILogEntry statechartElementLogEntry(Agent agent, Statechart statechart, int n2) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_TYPE_STATECHARTS, new String[]{"STATECHART_ID", "ELEMENT_ID"});
            preparedStatement.setInt(1, modelDatabase.getStatechartId(statechart));
            preparedStatement.setInt(2, n2);
            return preparedStatement;
        };
    }

    private static void n(Utilities utilities, PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setTimestamp(n2, new Timestamp(utilities.getEngine().dateInMillis()));
    }

    public static ILogEntry agentMovementLogEntry(int n2, double d2, long l2, long l3) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_MOVEMENT, new String[]{"AGENT_ID", "SPEED", "START_DATE", "STOP_DATE"});
            preparedStatement.setInt(1, n2);
            preparedStatement.setDouble(2, d2);
            preparedStatement.setTimestamp(3, new Timestamp(l2));
            preparedStatement.setTimestamp(4, new Timestamp(l3));
            return preparedStatement;
        };
    }

    public static ILogEntry messageReceived(Agent agent, Agent agent2, Object object) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_MESSAGES, new String[]{"AGENT_ID", "SENDER_ID", "MESSAGE", "DATE"});
            preparedStatement.setInt(1, agent.getId());
            if (agent2 != null) {
                preparedStatement.setInt(2, agent2.getId());
            } else {
                preparedStatement.setNull(2, 4);
            }
            preparedStatement.setString(3, UtilitiesDatabase.toStringDB(object));
            LogEntryFactory.n(agent, preparedStatement, 4);
            return preparedStatement;
        };
    }

    public static ILogEntry statisticsContinuousLogEntry(Agent agent, String string, StatisticsContinuous statisticsContinuous) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.STATISTICS, new String[]{"AGENT_ID", "NAME", "MINIMUM", "MAXIMUM", "MEAN", "DEVIATION", "MEAN_CONFIDENCE", "NUMBER"});
            if (agent == null) {
                preparedStatement.setNull(1, 4);
            } else {
                preparedStatement.setInt(1, agent.getId());
            }
            preparedStatement.setString(2, string);
            preparedStatement.setDouble(3, statisticsContinuous.min());
            preparedStatement.setDouble(4, statisticsContinuous.max());
            preparedStatement.setDouble(5, statisticsContinuous.mean());
            preparedStatement.setDouble(6, statisticsContinuous.deviation());
            preparedStatement.setDouble(7, statisticsContinuous.meanConfidence());
            preparedStatement.setDouble(8, statisticsContinuous.count());
            return preparedStatement;
        };
    }

    public static ILogEntry statisticsDiscreteLogEntry(Agent agent, String string, StatisticsDiscrete statisticsDiscrete) {
        return modelDatabase -> {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.STATISTICS, new String[]{"AGENT_ID", "NAME", "MINIMUM", "MAXIMUM", "MEAN", "DEVIATION", "MEAN_CONFIDENCE", "NUMBER"});
            if (agent == null) {
                preparedStatement.setNull(1, 4);
            } else {
                preparedStatement.setInt(1, agent.getId());
            }
            preparedStatement.setString(2, string);
            preparedStatement.setDouble(3, statisticsDiscrete.min());
            preparedStatement.setDouble(4, statisticsDiscrete.max());
            preparedStatement.setDouble(5, statisticsDiscrete.mean());
            preparedStatement.setDouble(6, statisticsDiscrete.deviation());
            preparedStatement.setDouble(7, statisticsDiscrete.meanConfidence());
            preparedStatement.setDouble(8, statisticsDiscrete.count());
            return preparedStatement;
        };
    }

    public static ILogEntry dataSetLogEntry(Agent agent, String string, final DataSet dataSet) {
        return new j(agent, string){

            @Override
            PreparedStatement a(ModelDatabase modelDatabase) throws SQLException {
                PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.DATASETS, new String[]{"ELEMENT_ID", "INDEX", "X", "Y"});
                int n2 = 0;
                int n3 = dataSet.size();
                while (n2 < n3) {
                    preparedStatement.setInt(1, this.a);
                    preparedStatement.setInt(2, n2);
                    preparedStatement.setDouble(3, dataSet.getX(n2));
                    preparedStatement.setDouble(4, dataSet.getY(n2));
                    preparedStatement.addBatch();
                    ++n2;
                }
                return preparedStatement;
            }

            @Override
            public boolean nextStatement() {
                return super.nextStatement() && dataSet.size() > 0;
            }
        };
    }

    public static ILogEntry histogramDataLogEntry(Agent agent, String string, final HistogramData histogramData) {
        return new j(agent, string){

            @Override
            PreparedStatement a(ModelDatabase modelDatabase) throws SQLException {
                double d2;
                double d3;
                boolean bl2 = histogramData.isCDFEnabled();
                PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.HISTOGRAMS, bl2 ? n : a);
                double d4 = histogramData.getXMin();
                double d5 = histogramData.getIntervalWidth();
                if (histogramData instanceof HistogramSimpleData && (d3 = ((HistogramSimpleData)histogramData).getPDFOutsideLow()) > 0.0) {
                    this.a(preparedStatement, Double.NEGATIVE_INFINITY, d4, d3);
                    if (bl2) {
                        preparedStatement.setDouble(5, d3);
                    }
                    preparedStatement.addBatch();
                }
                int n2 = 0;
                int n3 = histogramData.getNumberOfIntervals();
                while (n2 < n3) {
                    this.a(preparedStatement, d4 + (double)n2 * d5, d4 + (double)(n2 + 1) * d5, histogramData.getPDF(n2));
                    if (bl2) {
                        preparedStatement.setDouble(5, histogramData.getCDF(n2));
                    }
                    preparedStatement.addBatch();
                    ++n2;
                }
                if (histogramData instanceof HistogramSimpleData && (d2 = ((HistogramSimpleData)histogramData).getPDFOutsideHigh()) > 0.0) {
                    this.a(preparedStatement, histogramData.getXMax(), Double.POSITIVE_INFINITY, d2);
                    if (bl2) {
                        preparedStatement.setDouble(5, 1.0);
                    }
                    preparedStatement.addBatch();
                }
                return preparedStatement;
            }

            private void a(PreparedStatement preparedStatement, double d2, double d3, double d4) throws SQLException {
                preparedStatement.setInt(1, this.a);
                preparedStatement.setDouble(2, d2);
                preparedStatement.setDouble(3, d3);
                preparedStatement.setDouble(4, d4);
            }

            @Override
            public boolean nextStatement() {
                return super.nextStatement() && histogramData.getNumberOfIntervals() > 0;
            }
        };
    }

    public static ILogEntry statechartEnterStateLogEntry(Agent agent, Statechart statechart, short s) {
        return new d(agent, statechart, s);
    }

    public static ILogEntry statechartExitStateLogEntry(Agent agent, Statechart statechart, short s) {
        return new k(agent, s);
    }

    private static class a {
        final Agent a;
        final short n;

        public a(Agent agent, short s) {
            this.a = agent;
            this.n = s;
        }

        public final int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + (this.a == null ? 0 : this.a.hashCode());
            n2 = 31 * n2 + this.n;
            return n2;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            a a2 = (a)object;
            if (this.a == null ? a2.a != null : !this.a.equals(a2.a)) {
                return false;
            }
            return this.n == a2.n;
        }
    }

    private static class d
    extends a
    implements ILogEntry {
        Statechart k;
        long m;
        private ILogEntry h;

        public d(Agent agent, Statechart statechart, short s) {
            super(agent, s);
            this.k = statechart;
            this.m = agent.getEngine().dateInMillis();
        }

        @Override
        public PreparedStatement getSQLStatement(ModelDatabase modelDatabase) throws SQLException {
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.STATECHART_STATES, new String[]{"AGENT_ID", "STATE_ID", "ENTRY_DATE"});
            this.a(modelDatabase, preparedStatement);
            return preparedStatement;
        }

        private void a(ModelDatabase modelDatabase, PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setInt(1, this.a.getId());
            preparedStatement.setInt(2, modelDatabase.getAgentTypeStateId(this.a, this.k, this.n));
            preparedStatement.setTimestamp(3, new Timestamp(this.m));
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        @Override
        public boolean isCompoundLast() {
            return false;
        }

        @Override
        public Object getCompoundKey() {
            return this;
        }

        @Override
        public void initCompound(ILogEntry iLogEntry) {
            this.h = iLogEntry;
        }
    }

    private static class k
    extends a
    implements ILogEntry {
        d k;

        public k(Agent agent, short s) {
            super(agent, s);
        }

        @Override
        public PreparedStatement getSQLStatement(ModelDatabase modelDatabase) throws SQLException {
            if (this.k == null) {
                return null;
            }
            PreparedStatement preparedStatement = modelDatabase.a().a(DatabaseLogTableType.STATECHART_STATES, new String[]{"AGENT_ID", "STATE_ID", "ENTRY_DATE", "EXIT_DATE"});
            this.k.a(modelDatabase, preparedStatement);
            LogEntryFactory.n((Utilities)this.a, preparedStatement, 4);
            return preparedStatement;
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        @Override
        public void initCompound(ILogEntry iLogEntry) {
            this.k = (d)iLogEntry;
        }

        @Override
        public boolean isCompoundLast() {
            return true;
        }

        @Override
        public Object getCompoundKey() {
            return this;
        }
    }

    private static abstract class j
    implements ILogEntry {
        private Agent n;
        private String k;
        private boolean m = true;
        int a;

        j(Agent agent, String string) {
            this.n = agent;
            this.k = string;
        }

        @Override
        public PreparedStatement getSQLStatement(ModelDatabase modelDatabase) throws SQLException {
            PreparedStatement preparedStatement;
            if (this.m) {
                preparedStatement = modelDatabase.a().a(DatabaseLogTableType.AGENT_ELEMENTS, new String[]{"ID", "AGENT_ID", "NAME"});
                this.a = modelDatabase.generateAgentElementId();
                preparedStatement.setInt(1, this.a);
                if (this.n == null) {
                    preparedStatement.setNull(2, 4);
                } else {
                    preparedStatement.setInt(2, this.n.getId());
                }
                preparedStatement.setString(3, this.k);
            } else {
                preparedStatement = this.a(modelDatabase);
            }
            return preparedStatement;
        }

        abstract PreparedStatement a(ModelDatabase var1) throws SQLException;

        @Override
        public boolean isBatch() {
            return !this.m;
        }

        @Override
        public boolean nextStatement() {
            boolean bl2 = this.m;
            this.m = false;
            return bl2;
        }
    }
}

