/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.database;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AgentList;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.CustomDistribution;
import com.anylogic.engine.Engine;
import com.anylogic.engine.HyperArray;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.database.DatabaseColumnTypeEnum;
import com.anylogic.engine.database.DatabaseCustomType;
import com.anylogic.engine.database.ILogEntry;
import com.anylogic.engine.database.LoggingType;
import com.anylogic.engine.database.ModelDatabase;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.markup.AbstractMarkup;
import com.anylogic.engine.markup.AbstractMarkupSubunit;
import com.anylogic.engine.presentation.Light3D;
import com.anylogic.engine.presentation.ProgressConsumer;
import com.anylogic.engine.presentation.Shape;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.HSQLDBTemplates;
import com.mysema.query.sql.codegen.MetaDataExporter;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.query.sql.codegen.OriginalNamingStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UtilitiesDatabase {
    private static final String a = "Copying tables data...";
    private static /* synthetic */ int[] n;

    @AnyLogicInternalAPI
    public static String getIdentifierQuoteString(Connection connection) {
        try {
            return connection.getMetaData().getIdentifierQuoteString();
        }
        catch (UnsupportedOperationException | SQLException exception) {
            return "\"";
        }
    }

    @AnyLogicInternalAPI
    public static void exportTables(ProgressConsumer progressConsumer, Connection connection, Connection connection2, Collection<String> collection, List<String> list) {
        try {
            for (String object2 : collection) {
                Throwable throwable = null;
                Object throwable2 = null;
                try (Statement statement = connection2.createStatement();){
                    statement.executeUpdate(object2);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
        }
        catch (SQLException sQLException) {
            throw ff.m(sQLException);
        }
        List<String> list2 = list.stream().map(string -> UtilitiesDatabase.trimTableName(string)).collect(Collectors.toList());
        UtilitiesDatabase.copyDatabaseTables(progressConsumer, connection, connection2, list, list2, false, true);
    }

    @AnyLogicInternalAPI
    public static String trimTableName(String string) {
        if (string.length() > 30) {
            return string.substring(0, 30);
        }
        return string;
    }

    @AnyLogicInternalAPI
    public static void copyDatabaseTables(ProgressConsumer progressConsumer, Connection connection, Connection connection2, List<String> list, List<String> list2, boolean bl2, boolean bl3) {
        if (progressConsumer != null) {
            progressConsumer.setMessage(a);
        }
        try {
            int n2 = 0;
            while (n2 < list.size()) {
                UtilitiesDatabase.copyDatabaseTable(connection, connection2, list.get(n2), list2.get(n2), bl2, bl3);
                if (progressConsumer != null) {
                    progressConsumer.setProgress((int)((double)(n2 + 1) * 100.0 / (double)list.size()));
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw ff.m(sQLException);
        }
    }

    @AnyLogicInternalAPI
    public static void copyDatabaseTable(Connection connection, Connection connection2, String string, String string2) {
        try {
            UtilitiesDatabase.copyDatabaseTable(connection, connection2, string, string2, true, true);
        }
        catch (SQLException sQLException) {
            throw ff.m(sQLException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AnyLogicInternalAPI
    public static void copyDatabaseTable(Connection connection, Connection connection2, String string, String string2, boolean bl2, boolean bl3) throws SQLException {
        Statement statement;
        Throwable throwable;
        Object object;
        if (bl3) {
            try {
                connection2.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        }
        if (bl2) {
            object = null;
            throwable = null;
            try {
                statement = connection2.createStatement();
                try {
                    statement.execute("DELETE FROM " + string2 + ";");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (object == null) {
                    object = throwable2;
                    throw object;
                } else {
                    if (object == throwable2) throw object;
                    ((Throwable)object).addSuppressed(throwable2);
                }
                throw object;
            }
        }
        object = "SELECT * FROM " + string + ";";
        throwable = null;
        statement = null;
        try {
            Statement statement2 = connection.createStatement();
            try {
                try (ResultSet resultSet = statement2.executeQuery((String)object);){
                    UtilitiesDatabase.a(connection2, string2, resultSet);
                }
                if (statement2 == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (statement2 == null) throw throwable;
                statement2.close();
                throw throwable;
            }
            statement2.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private static void a(Connection connection, String string, ResultSet resultSet) throws SQLException {
        int n2;
        int n3;
        ResultSetMetaData resultSetMetaData;
        AutoCloseable autoCloseable;
        String string2 = UtilitiesDatabase.getIdentifierQuoteString(connection);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO ");
        stringBuilder.append(string);
        stringBuilder.append(" (");
        int n4 = 0;
        Throwable throwable = null;
        Object var7_11 = null;
        try {
            autoCloseable = connection.createStatement().executeQuery("SELECT * FROM " + string + " LIMIT 0;");
            try {
                resultSetMetaData = autoCloseable.getMetaData();
                n3 = 1;
                n2 = 1;
                while (n2 <= resultSetMetaData.getColumnCount()) {
                    String string3 = resultSetMetaData.getColumnName(n2);
                    if (!string3.toLowerCase().equals("al_id")) {
                        if (n3 == 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string2);
                        stringBuilder.append(string3);
                        stringBuilder.append(string2);
                        ++n4;
                        n3 = 0;
                    }
                    ++n2;
                }
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        stringBuilder.append(")");
        stringBuilder.append(" VALUES (");
        int n5 = 1;
        while (n5 <= n4) {
            stringBuilder.append("?");
            if (n5 < n4) {
                stringBuilder.append(",");
            }
            ++n5;
        }
        stringBuilder.append(");");
        Throwable throwable3 = null;
        var7_11 = null;
        try {
            autoCloseable = connection.prepareStatement(stringBuilder.toString());
            try {
                resultSetMetaData = resultSet.getMetaData();
                n3 = -1;
                n2 = 1;
                while (n2 <= resultSetMetaData.getColumnCount()) {
                    if (resultSetMetaData.getColumnName(n2) != null && resultSetMetaData.getColumnName(n2).toLowerCase().equals("al_id")) {
                        n3 = n2;
                    }
                    ++n2;
                }
                while (resultSet.next()) {
                    n2 = 1;
                    int n6 = 1;
                    while (n6 <= resultSetMetaData.getColumnCount()) {
                        if (n6 != n3) {
                            Object object = resultSet.getObject(n6);
                            if (object != null && object.equals("")) {
                                object = null;
                            }
                            autoCloseable.setObject(n2++, object);
                        }
                        ++n6;
                    }
                    autoCloseable.execute();
                }
            }
            finally {
                if (autoCloseable != null) {
                    autoCloseable.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }

    @AnyLogicInternalAPI
    public static boolean logIfNeeded(Utilities utilities, LoggingType loggingType, Supplier<ILogEntry> supplier) {
        return UtilitiesDatabase.logIfNeeded(utilities, loggingType, false, supplier);
    }

    @AnyLogicInternalAPI
    public static boolean logIfNeeded(Utilities utilities, LoggingType loggingType, boolean bl2, Supplier<ILogEntry> supplier) {
        Engine engine;
        if (utilities != null && (engine = utilities.getEngine()) != null) {
            ModelDatabase modelDatabase = engine.getModelDatabase();
            if (loggingType.isLoggingOn(engine)) {
                if (!utilities.isLoggingClassToDB(loggingType) || !bl2 && !utilities.isLoggingToDB(loggingType)) {
                    return false;
                }
                ILogEntry iLogEntry = supplier.get();
                if (iLogEntry != null) {
                    modelDatabase.log(iLogEntry);
                    return true;
                }
            }
        }
        return false;
    }

    @AnyLogicInternalAPI
    public static void generateQClasses(Connection connection, String string, String string2, List<DatabaseCustomType> list) throws SQLException {
        Configuration configuration = new Configuration(HSQLDBTemplates.builder().printSchema().build());
        MetaDataExporter metaDataExporter = new MetaDataExporter();
        metaDataExporter.setPackageName(string);
        metaDataExporter.setTargetFolder(new File(string2));
        metaDataExporter.setSourceEncoding("UTF-8");
        metaDataExporter.setSchemaPattern("PUBLIC");
        metaDataExporter.setNamingStrategy((NamingStrategy)new OriginalNamingStrategy(){

            public String normalizeTableName(String string) {
                return super.normalizeTableName(string).toLowerCase();
            }

            public String normalizeColumnName(String string) {
                return super.normalizeColumnName(string).toLowerCase();
            }

            public String getClassName(String string) {
                return super.getClassName(string).toLowerCase();
            }

            public String getDefaultVariableName(EntityType entityType) {
                return "INSTANCE";
            }

            public String getPropertyName(String string, EntityType entityType) {
                return super.getPropertyName(string, entityType).toLowerCase();
            }

            public String getPropertyNameForInverseForeignKey(String string, EntityType entityType) {
                return "_" + this.getPropertyNameForForeignKey(string, entityType);
            }
        });
        metaDataExporter.setConfiguration(configuration);
        metaDataExporter.export(connection.getMetaData());
        File file = new File(UtilitiesDatabase.a(string2, string));
        UtilitiesDatabase.a(file, list);
    }

    private static String a(String string, String string2) {
        String string3 = String.valueOf(string) + File.separator + string2.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        return string3;
    }

    private static void a(File file, List<DatabaseCustomType> list) {
        Object object;
        String string;
        Object object2;
        Object object3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (file.isDirectory()) {
            object3 = file.listFiles();
            int n2 = ((File[])object3).length;
            int n3 = 0;
            while (n3 < n2) {
                File object4 = object3[n3];
                try {
                    object2 = null;
                    string = null;
                    try {
                        object = new FileInputStream(object4);
                        try {
                            byte[] byArray = new byte[(int)object4.length()];
                            ((FileInputStream)object).read(byArray);
                            String string2 = object4.getName();
                            String string3 = object4.getAbsolutePath();
                            String string4 = new String(byArray, "UTF-8");
                            String string5 = UtilitiesDatabase.k(string4, string2.substring(0, string2.indexOf(46)));
                            hashMap.put(string5, string3);
                            hashMap2.put(string3, string4);
                        }
                        finally {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object2 == null) {
                            object2 = throwable;
                        } else if (object2 != throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                        throw object2;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ++n3;
            }
        }
        for (DatabaseCustomType databaseCustomType : list) {
            String string6 = databaseCustomType.getTableName();
            object3 = databaseCustomType.getColumnName();
            object2 = databaseCustomType.getCategory();
            string = databaseCustomType.getReference();
            object = (String)hashMap2.get(hashMap.get(string6));
            switch (UtilitiesDatabase.a()[((Enum)object2).ordinal()]) {
                case 2: {
                    object = UtilitiesDatabase.a((String)object, (String)object3, string);
                    break;
                }
                case 3: {
                    object = UtilitiesDatabase.n((String)object, (String)object3);
                    break;
                }
                case 1: {
                    break;
                }
            }
            hashMap2.put((String)hashMap.get(string6), object);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string7 = UtilitiesDatabase.a((String)entry.getValue());
            hashMap2.put((String)entry.getKey(), string7);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            try {
                Throwable throwable = null;
                object3 = null;
                try {
                    object2 = new PrintWriter(new File((String)entry.getKey()), "UTF-8");
                    try {
                        ((PrintWriter)object2).print((String)entry.getValue());
                    }
                    finally {
                        if (object2 != null) {
                            ((PrintWriter)object2).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String a(String string, String string2, String string3) {
        Pattern pattern = Pattern.compile(String.format("public final StringPath (.+) = createString\\(\\\"%s\\\"\\);", string2));
        Matcher matcher = pattern.matcher(string);
        String string4 = null;
        if (matcher.find()) {
            String string5 = matcher.group(1);
            string4 = matcher.replaceFirst(String.format("public final EnumPath<%1$s> %2$s = createEnum(\"%3$s\", %1$s.class);", string3, string5, string2));
        }
        return string4;
    }

    private static String n(String string, String string2) {
        String string3 = string.replaceAll("public final StringPath " + string2 + " = createString\\(\\\"" + string2 + "\\\"\\);", "public final SimplePath<com.anylogic.engine.database.CodeValue> " + string2 + " = createSimple(\"" + string2 + "\", com.anylogic.engine.database.CodeValue.class);");
        return string3;
    }

    private static String a(String string) {
        String string2 = string.replace("java.sql.Timestamp", "java.util.Date");
        return string2;
    }

    private static String k(String string, String string2) {
        Pattern pattern = Pattern.compile(String.format("public static final %1$s .+? = new %1$s\\(\\\"(.+?)\\\"\\);", string2));
        Matcher matcher = pattern.matcher(string);
        String string3 = null;
        if (matcher.find()) {
            string3 = matcher.group(1);
        }
        return string3;
    }

    public static String toStringDB(Object object) {
        return UtilitiesDatabase.a(object, 2);
    }

    private static String a(Object object, int n2) {
        String string = null;
        try {
            try {
                if (object instanceof Agent) {
                    string = ((Agent)object).getFullName();
                } else if (object instanceof AgentList) {
                    AgentList agentList = (AgentList)object;
                    string = String.valueOf(agentList.getOwner().getNameOf(agentList)) + "[" + agentList.size() + "]";
                } else if (object != null && object.getClass().isArray()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n3 = Array.getLength(object);
                    if (n2 > 0) {
                        stringBuilder.append("{");
                        int n4 = Math.min(10, n3);
                        int n5 = 0;
                        while (n5 < n4) {
                            stringBuilder.append(UtilitiesDatabase.a(Array.get(object, n5), n2 - 1));
                            if (n5 + 1 < n4) {
                                stringBuilder.append(", ");
                            }
                            ++n5;
                        }
                        if (n4 < n3) {
                            stringBuilder.append(" ...");
                        }
                        stringBuilder.append("}");
                        if (n4 < n3) {
                            stringBuilder.append(", size: ").append(n3);
                        }
                    } else {
                        stringBuilder.append(UtilitiesDatabase.a(object.getClass().getComponentType()));
                        stringBuilder.append('[').append(n3).append("]");
                    }
                    string = stringBuilder.toString();
                } else if (object instanceof Shape) {
                    string = ((Shape)object).getName();
                } else if (object instanceof Light3D) {
                    string = ((Light3D)object).getName();
                } else if (object instanceof AbstractMarkup) {
                    string = ((AbstractMarkup)object).getName();
                } else if (object instanceof AbstractMarkupSubunit) {
                    string = ((AbstractMarkupSubunit)object).getName();
                } else if (object instanceof Collection) {
                    string = String.valueOf(UtilitiesDatabase.a(object.getClass())) + "[" + ((Collection)object).size() + "]";
                } else if (object instanceof Map) {
                    string = String.valueOf(UtilitiesDatabase.a(object.getClass())) + "[" + ((Map)object).size() + "]";
                } else {
                    if (object instanceof HyperArray) {
                        double[] dArray = ((HyperArray)object).getData();
                        if (dArray.length == 1) {
                            return "[ " + dArray[0] + " ]";
                        }
                        return "[ " + dArray[0] + ", " + dArray[1] + (dArray.length > 2 ? " ... ]" : " ]");
                    }
                    if (object instanceof Date) {
                        string = new Timestamp(((Date)object).getTime()).toString();
                    } else if (object instanceof CustomDistribution) {
                        string = ((CustomDistribution)object).toString();
                    }
                }
            }
            catch (Throwable throwable) {}
            if (string == null) {
                string = String.valueOf(object);
            }
        }
        catch (Throwable throwable) {
            string = throwable.toString();
        }
        return string;
    }

    private static String a(Class<?> clazz) {
        String string = clazz.getName();
        return string.startsWith("com.anylogic.") || string.startsWith("java.lang.") || string.startsWith("java.util.") ? clazz.getSimpleName() : string;
    }

    static /* synthetic */ int[] a() {
        if (n != null) {
            return n;
        }
        int[] nArray = new int[DatabaseColumnTypeEnum.values().length];
        try {
            nArray[DatabaseColumnTypeEnum.CODE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseColumnTypeEnum.OPTIONS_LIST.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DatabaseColumnTypeEnum.SQL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        n = nArray;
        return nArray;
    }
}

