/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.GISCoordinates;
import com.anylogic.engine.gis.GISMarkupDescriptor;
import com.anylogic.engine.gis.GISMultiRegionDescriptor;
import com.anylogic.engine.gis.GISPointDescriptor;
import com.anylogic.engine.gis.GISRegionDescriptor;
import com.anylogic.engine.gis.IGeographicSearch;
import com.anylogic.engine.internal.t.f;
import com.anylogic.engine.presentation.NetworkActivityMonitorService;
import com.anylogic.engine.presentation.NetworkConnectionHandler;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@AnyLogicInternalAPI
public abstract class AbstractNominatimSearch<E, P extends E, R extends E>
implements IGeographicSearch<E, P, R> {
    protected static final String a = "type";
    private static final String n = "osm_id";
    private static final String k = "error";
    private static final String m = "Polygon";
    private static final String h = "coordinates";
    private static final String j = "MultiPolygon";
    private static final String i = "geojson";
    private static final String d = "display_name";
    private static final String l = "lon";
    private static final String g = "lat";
    private static final String c = "class";
    private static final String b = "&polygon_geojson=1";
    private static final String f = "http://nominatim.openstreetmap.org/search.php?q=%s&format=json&limit=50";
    private static final String e = "http://nominatim.openstreetmap.org/reverse?format=json&lat=%f&lon=%f&zoom=%d&addressdetails=1";
    private static final String ac = "&viewbox=%s,%s,%s,%s&bounded=1";
    private static final Long mk = null;
    private static final String nd = "<unknown point>";
    private static final String mf = "node";
    private static final String hl = "node";
    private static final int gf = 1;
    private static final int ma = 18;
    private static final double gd = -90.0;
    private static final double nm = 90.0;
    private static final double ib = -180.0;
    private static final double ml = 180.0;
    private static final double dd = 180.0;
    private static final double jj = 360.0;
    private final f<JSONArray> jb = new f();
    private final f<JSONObject> hn = new f();

    @Override
    public List<E> search(String string, boolean bl2, double d2, double d3, double d4, double d5) {
        List<E> list = this.a(string, bl2, true, d2, d3, d4, d5, false);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public List<E> search(String string, boolean bl2) {
        List<E> list = this.a(string, bl2, false, 0.0, 0.0, 0.0, 0.0, false);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    protected List<E> a(String string, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5, boolean bl4) {
        Optional<GISCoordinates> optional = null;
        try {
            optional = GISCoordinates.parse(string);
        }
        catch (ParseException parseException) {
            optional = Optional.empty();
        }
        List<GISMarkupDescriptor> list = optional.isPresent() ? this.a(optional.get(), false, bl3, d2, d3, d4, d5, bl4) : this.k(string, bl2, bl3, d2, d3, d4, d5, bl4);
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (GISMarkupDescriptor gISMarkupDescriptor : list) {
            this.a(arrayList, gISMarkupDescriptor);
        }
        return arrayList;
    }

    void a(List<E> list, GISMarkupDescriptor gISMarkupDescriptor) {
        if (gISMarkupDescriptor instanceof GISPointDescriptor) {
            list.add(this.getPoint((GISPointDescriptor)gISMarkupDescriptor));
        } else if (gISMarkupDescriptor instanceof GISRegionDescriptor) {
            list.add(this.getRegion((GISRegionDescriptor)gISMarkupDescriptor));
        } else if (gISMarkupDescriptor instanceof GISMultiRegionDescriptor) {
            this.addMultiRegion(list, (GISMultiRegionDescriptor)gISMarkupDescriptor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<GISMarkupDescriptor> k(String string, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5, boolean bl4) {
        ArrayList<GISMarkupDescriptor> arrayList = new ArrayList<GISMarkupDescriptor>();
        try {
            string = URLEncoder.encode(string, "UTF-8");
            Throwable throwable = null;
            Object var15_12 = null;
            try {
                NetworkConnectionHandler networkConnectionHandler = NetworkActivityMonitorService.createNetworkConnectionStatusMonitor();
                try {
                    Optional<JSONArray> optional;
                    StringBuilder stringBuilder = new StringBuilder(String.format(f, string.replaceAll(" ", "+")));
                    if (bl2) {
                        stringBuilder.append(b);
                    }
                    if (bl3) {
                        stringBuilder.append(String.format(ac, String.valueOf(d3), String.valueOf(d4), String.valueOf(d5), String.valueOf(d2)));
                    }
                    if ((optional = this.jb.a(stringBuilder.toString(), 15000)) == null) return null;
                    if (!optional.isPresent()) {
                        return null;
                    }
                    JSONArray jSONArray = optional.get();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= jSONArray.size()) {
                            return arrayList;
                        }
                        JSONObject jSONObject = (JSONObject)jSONArray.get(n2);
                        double d6 = Double.valueOf((String)jSONObject.get((Object)g));
                        double d7 = Double.valueOf((String)jSONObject.get((Object)l));
                        this.a(arrayList, jSONObject, d6, d7, bl2);
                        if (bl4 && arrayList.size() > 0) {
                            return arrayList;
                        }
                        ++n2;
                    }
                }
                finally {
                    if (networkConnectionHandler == null) return null;
                    networkConnectionHandler.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<GISMarkupDescriptor> a(GISCoordinates gISCoordinates, boolean bl2, boolean bl3, double d2, double d3, double d4, double d5, boolean bl4) {
        ArrayList<GISMarkupDescriptor> arrayList = new ArrayList<GISMarkupDescriptor>();
        double d6 = gISCoordinates.getLatitude();
        double d7 = gISCoordinates.getLongitude();
        int n2 = AbstractNominatimSearch.a(d2, d3, d4, d5);
        try {
            Throwable throwable = null;
            Object var20_15 = null;
            try {
                NetworkConnectionHandler networkConnectionHandler = NetworkActivityMonitorService.createNetworkConnectionStatusMonitor();
                try {
                    String string = String.format(e, d6, d7, n2);
                    Optional<JSONObject> optional = this.hn.a(string, 15000);
                    if (optional == null || !optional.isPresent() || optional.get().get((Object)k) != null) {
                        arrayList.add(new GISPointDescriptor(mk, nd, "", "node", "node", d6, d7));
                        return arrayList;
                    }
                    this.a(arrayList, optional.get(), d6, d7, bl2);
                    return arrayList;
                }
                finally {
                    if (networkConnectionHandler == null) return arrayList;
                    networkConnectionHandler.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return arrayList;
    }

    private static int a(double d2, double d3, double d4, double d5) {
        d2 = Math.max(d2, -90.0);
        d4 = Math.min(d4, 90.0);
        d3 = Math.max(d3, -180.0);
        d5 = Math.min(d5, 180.0);
        double d6 = Math.abs(1.0 - (d4 - d2) / 180.0);
        double d7 = Math.abs(1.0 - (d5 - d3) / 360.0);
        double d8 = Math.sqrt(d6 * d7);
        double d9 = d8 * 18.0;
        return Math.max(1, Math.round((float)d9));
    }

    void a(List<GISMarkupDescriptor> list, JSONObject jSONObject, double d2, double d3, boolean bl2) {
        String string = (String)jSONObject.get((Object)n);
        Long l2 = string != null ? Long.valueOf(string) : null;
        String string2 = (String)jSONObject.get((Object)c);
        String string3 = (String)jSONObject.get((Object)a);
        String string4 = (String)jSONObject.get((Object)d);
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)i);
        if (bl2) {
            if (jSONObject2 == null) {
                return;
            }
            String string5 = (String)jSONObject2.get((Object)a);
            if (string5.equals(j)) {
                ArrayList<GISRegionDescriptor> arrayList = new ArrayList<GISRegionDescriptor>();
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)h);
                int n2 = 0;
                while (n2 < jSONArray.size()) {
                    JSONArray jSONArray2 = (JSONArray)jSONArray.get(n2);
                    arrayList.add(new GISRegionDescriptor(l2, string4, "", string2, string3, this.a(jSONArray2)));
                    ++n2;
                }
                list.add(new GISMultiRegionDescriptor(l2, string4, "", string2, string3, arrayList));
            } else if (string5.equals(m)) {
                JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)h);
                list.add(new GISRegionDescriptor(l2, string4, "", string2, string3, this.a(jSONArray)));
            }
        } else {
            list.add(new GISPointDescriptor(l2, string4, "", string2, string3, d2, d3));
        }
    }

    public abstract void error(String var1);

    public abstract P getPoint(GISPointDescriptor var1);

    public abstract R getRegion(GISRegionDescriptor var1);

    public abstract void addMultiRegion(List<E> var1, GISMultiRegionDescriptor var2);

    @Override
    public List<P> search(String string, double d2, double d3, double d4, double d5, boolean bl2) {
        List<E> list = this.a(string, false, true, d2, d3, d4, d5, bl2);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        if (list.size() > 0) {
            return list;
        }
        return this.a(string, false, false, d2, d3, d4, d5, bl2);
    }

    @Override
    public List<R> searchRegion(String string, double d2, double d3, double d4, double d5, boolean bl2) {
        List<E> list = this.a(string, true, true, d2, d3, d4, d5, bl2);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        if (list.size() > 0) {
            return list;
        }
        return this.a(string, true, false, d2, d3, d4, d5, bl2);
    }

    protected final double[] a(JSONArray jSONArray) {
        JSONArray jSONArray2 = (JSONArray)jSONArray.get(0);
        int n2 = jSONArray2.size();
        double[] dArray = new double[n2 * 2];
        int n3 = 0;
        while (n3 < n2) {
            double d2;
            JSONArray jSONArray3 = (JSONArray)jSONArray2.get(n3);
            double d3 = ((Number)jSONArray3.get(0)).doubleValue();
            dArray[n3 * 2] = d2 = ((Number)jSONArray3.get(1)).doubleValue();
            dArray[n3 * 2 + 1] = d3;
            ++n3;
        }
        return dArray;
    }
}

