/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.AbstractGISRouteProvider;
import com.anylogic.engine.gis.RoutingMethod;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.markup.Curve;
import com.anylogic.engine.markup.GISMarkupSegmentLine;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import java.io.File;
import java.util.ArrayList;

public class GraphHopperRouteProvider
extends AbstractGISRouteProvider {
    private static final int a = 4000;
    private static final long serialVersionUID = 4444172578851461686L;
    private transient GraphHopper n;
    private final String k;
    private String m;
    private RoutingMethod h;

    public GraphHopperRouteProvider(String string, String string2, RoutingMethod routingMethod) {
        this.k = string;
        this.m = string2;
        this.h = routingMethod;
    }

    @Override
    Curve a(double d2, double d3, double d4, double d5) {
        return this.getPathData(new double[]{d2, d3, d4, d5});
    }

    public Curve getPathData(double ... dArray) {
        Curve<GISMarkupSegmentLine> curve = new Curve<GISMarkupSegmentLine>();
        GHResponse gHResponse = this.a(dArray);
        PointList pointList = gHResponse.getPoints();
        int n2 = pointList.size();
        if (n2 == 0) {
            return curve;
        }
        if (pointList.getLat(0) != dArray[0] || pointList.getLon(0) != dArray[1]) {
            curve.addSegment(new GISMarkupSegmentLine(dArray[0], dArray[1], pointList.getLat(0), pointList.getLon(0)));
        }
        int n3 = 0;
        while (n3 < pointList.size() - 1) {
            curve.addSegment(new GISMarkupSegmentLine(pointList.getLat(n3), pointList.getLon(n3), pointList.getLat(n3 + 1), pointList.getLon(n3 + 1)));
            ++n3;
        }
        if (pointList.getLat(n2 - 1) != dArray[dArray.length - 2] || pointList.getLon(n2 - 1) != dArray[dArray.length - 1]) {
            curve.addSegment(new GISMarkupSegmentLine(pointList.getLat(n2 - 1), pointList.getLon(n2 - 1), dArray[dArray.length - 2], dArray[dArray.length - 1]));
        }
        curve.initialize();
        return curve;
    }

    @Override
    public double getDistance(double d2, double d3, double d4, double d5) {
        GHResponse gHResponse = this.a(new double[]{d2, d3, d4, d5});
        return gHResponse.getDistance();
    }

    private GHResponse a(double ... dArray) {
        ArrayList<GHPoint> arrayList = new ArrayList<GHPoint>();
        int n2 = 0;
        while (n2 < dArray.length) {
            arrayList.add(new GHPoint(dArray[n2], dArray[n2 + 1]));
            n2 += 2;
        }
        GHRequest gHRequest = new GHRequest(arrayList);
        gHRequest.setAlgorithm(this.m);
        gHRequest.getHints().put("simplifyRequest", (Object)true);
        gHRequest.getHints().put("douglas.minprecision", (Object)this.getPrecisionInMeters());
        gHRequest.setWeighting(this.h == RoutingMethod.FASTEST ? "fastest" : "shortest");
        GHResponse gHResponse = this.a().route(gHRequest);
        return gHResponse;
    }

    private GraphHopper a() {
        if (this.n == null) {
            String string = new File(this.k).getAbsolutePath();
            if (!SharedUtils.folderContainsGraphHopperRoutingGraph(string)) {
                String string2 = new File(new File(this.k).getName()).getAbsolutePath();
                if (SharedUtils.folderContainsGraphHopperRoutingGraph(string2)) {
                    string = string2;
                } else {
                    throw new RuntimeException(String.format(hg.gbc, string));
                }
            }
            this.n = GraphHopperRouteProvider.createGraphhopperInstance();
            this.n.setMemoryMapped();
            boolean bl2 = false;
            try {
                bl2 = this.n.load(string);
            }
            catch (Exception exception) {
                this.n = null;
                if (exception instanceof IllegalStateException && "Version of nodes unsupported: 3, expected:4".equals(exception.getLocalizedMessage())) {
                    throw new IllegalStateException(String.format(hg.ffi, string), exception);
                }
                throw exception;
            }
            if (!bl2) {
                this.n = null;
                throw new RuntimeException(hg.ngf);
            }
        }
        return this.n;
    }

    @AnyLogicInternalAPI
    public static GraphHopper createGraphhopperInstance() {
        GraphHopper graphHopper = new GraphHopper().forDesktop();
        graphHopper.setPreciseIndexResolution(4000);
        graphHopper.setCHEnable(false);
        return graphHopper;
    }

    @AnyLogicInternalAPI
    public String getGraphFilesPath() {
        return this.k;
    }

    @AnyLogicInternalAPI
    public RoutingMethod getRoutingMethod() {
        return this.h;
    }

    @AnyLogicInternalAPI
    public void setRoutingMethod(RoutingMethod routingMethod) {
        this.h = routingMethod;
    }

    @AnyLogicInternalAPI
    public String getPathFindingAlgorithm() {
        return this.m;
    }

    @AnyLogicInternalAPI
    public void setPathFindingAlgorithm(String string) {
        this.m = string;
    }

    @AnyLogicInternalAPI
    public void close() {
        if (this.n != null) {
            this.n.close();
        }
    }
}

