/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.AbstractCachedNominatimSearch;
import com.anylogic.engine.gis.GISMarkupDescriptor;
import com.anylogic.engine.gis.GISMultiRegion;
import com.anylogic.engine.gis.GISMultiRegionDescriptor;
import com.anylogic.engine.gis.GISPointDescriptor;
import com.anylogic.engine.gis.GISRegionDescriptor;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.markup.GISPoint;
import com.anylogic.engine.markup.GISRegion;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.ShapeGISMap;
import com.anylogic.engine.presentation.UtilitiesColor;
import java.util.ArrayList;
import java.util.List;

@AnyLogicInternalAPI
public class NominatimSearch
extends AbstractCachedNominatimSearch<GISNode, GISPoint, GISRegion> {
    private static final long n = 6823128966916504537L;
    private int k = 0;

    public NominatimSearch(ShapeGISMap shapeGISMap, String string) {
        super(shapeGISMap, string);
    }

    @Override
    public GISPoint getPoint(GISPointDescriptor gISPointDescriptor) {
        GISPoint gISPoint = new GISPoint(this.a(), false, gISPointDescriptor.getLatitude(), gISPointDescriptor.getLongitude());
        gISPoint.setTitle(gISPointDescriptor.getName());
        return gISPoint;
    }

    @Override
    public GISRegion getRegion(GISRegionDescriptor gISRegionDescriptor) {
        double[] dArray;
        double[] dArray2 = dArray = this.k == 0 ? gISRegionDescriptor.getCoords() : SharedUtils.getSimplifiedPointList(gISRegionDescriptor.getCoords(), this.k, null);
        if (dArray.length < 6) {
            dArray = SharedUtils.get3PointBasedRegion(gISRegionDescriptor.getCoords());
        }
        return new GISRegion(this.a(), false, dArray, UtilitiesColor.defaultGisFillColor, UtilitiesColor.defaultGisLineColor, 2.0, LineStyle.LINE_STYLE_DASHED, gISRegionDescriptor.getName(), SharedUtils.getGISRegionArea(gISRegionDescriptor.getCoords()));
    }

    @Override
    public final void addMultiRegion(List<GISNode> list, GISMultiRegionDescriptor gISMultiRegionDescriptor) {
        for (GISRegionDescriptor gISRegionDescriptor : gISMultiRegionDescriptor.getRegionDescriptors()) {
            list.add(this.getRegion(gISRegionDescriptor));
        }
    }

    public void setPrecisionInMeters(int n2) {
        this.k = n2;
    }

    public List<GISMultiRegion> searchMultiRegion(String string, double d2, double d3, double d4, double d5, boolean bl2) {
        ArrayList<GISMultiRegion> arrayList = new ArrayList<GISMultiRegion>();
        List<GISMarkupDescriptor> list = this.n(string, true, true, d2, d3, d4, d5, bl2);
        if (list != null) {
            if (list.size() == 0) {
                list = this.n(string, true, false, 0.0, 0.0, 0.0, 0.0, bl2);
            }
            for (GISMarkupDescriptor gISMarkupDescriptor : list) {
                GISMultiRegion gISMultiRegion = this.a(gISMarkupDescriptor);
                if (gISMultiRegion == null) continue;
                arrayList.add(gISMultiRegion);
            }
        }
        return arrayList;
    }

    private GISMultiRegion a(GISMarkupDescriptor gISMarkupDescriptor) {
        GISMultiRegion gISMultiRegion = null;
        if (gISMarkupDescriptor instanceof GISRegionDescriptor) {
            gISMultiRegion = new GISMultiRegion();
            gISMultiRegion.setTitle(gISMarkupDescriptor.getName());
            gISMultiRegion.add(this.getRegion((GISRegionDescriptor)gISMarkupDescriptor));
        } else if (gISMarkupDescriptor instanceof GISMultiRegionDescriptor) {
            GISMultiRegionDescriptor gISMultiRegionDescriptor = (GISMultiRegionDescriptor)gISMarkupDescriptor;
            gISMultiRegion = new GISMultiRegion();
            gISMultiRegion.setTitle(gISMarkupDescriptor.getName());
            for (GISRegionDescriptor gISRegionDescriptor : gISMultiRegionDescriptor.getRegionDescriptors()) {
                gISMultiRegion.add(this.getRegion(gISRegionDescriptor));
            }
        }
        return gISMultiRegion;
    }

    @Override
    public void error(String string) {
        System.err.println(string);
    }
}

