/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.TileImageProvider;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.OSMMapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.ServerMapTileFactory;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMTextLabeler;
import com.bbn.openmap.proj.Projection;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

@AnyLogicInternalAPI
public class TileFactory
extends ServerMapTileFactory {
    private int a;
    private TileImageProvider n;

    public TileFactory(TileImageProvider tileImageProvider) {
        this.n = tileImageProvider;
        this.verbose = true;
        this.rootDir = "http://otile{rand4N}.mqcdn.com/tiles/1.0.0/osm/{zoom}/{x}/{y}.jpg";
        this.setMtcTransform((MapTileCoordinateTransform)new OSMMapTileCoordinateTransform(){

            public int[] getTileBoundsForProjection(Point2D point2D, Point2D point2D2, int n2) {
                TileFactory.this.a(point2D);
                TileFactory.this.a(point2D2);
                int[] nArray = super.getTileBoundsForProjection(point2D, point2D2, n2);
                int n3 = (int)Math.pow(2.0, n2);
                int n4 = 0;
                while (n4 < nArray.length) {
                    if (nArray[n4] < 0) {
                        nArray[n4] = 0;
                    } else if (n3 < nArray[n4]) {
                        nArray[n4] = n3;
                    }
                    ++n4;
                }
                return nArray;
            }
        });
    }

    private void a(Point2D point2D) {
        double d2 = point2D.getX();
        if (d2 < -180.0) {
            d2 = -180.0;
        } else if (d2 > 180.0) {
            d2 = 180.0;
        }
        double d3 = point2D.getY();
        if (d3 < -90.0) {
            d3 = -90.0;
        } else if (d3 > 90.0) {
            d3 = 90.0;
        }
        point2D.setLocation(d2, d3);
    }

    protected void getTiles(int n2, int n3, int n4, int n5, ZoomLevelInfo zoomLevelInfo, Projection projection, OMGraphicList oMGraphicList) {
        int n6 = zoomLevelInfo.getZoomLevel();
        int n7 = Math.min(n2, n3);
        int n8 = Math.max(n2, n3);
        int n9 = Math.min(n5, n4);
        int n10 = Math.max(n5, n4);
        int n11 = n7;
        while (n11 < n8) {
            int n12 = n9;
            while (n12 < n10) {
                if (this.mapTileRequester != null && !this.mapTileRequester.shouldContinue()) {
                    return;
                }
                OMGraphic oMGraphic = this.getTileFromProvider(n11, n12, n6, projection);
                if (oMGraphic != null) {
                    if (mapTileLogger.isLoggable(Level.FINE)) {
                        oMGraphic.putAttribute((Object)"Label", (Object)new OMTextLabeler("Tile: " + n6 + "|" + n11 + "|" + n12, 1));
                        oMGraphic.setSelected(true);
                    }
                    oMGraphic.generate(projection);
                    oMGraphicList.add(oMGraphic);
                }
                ++n12;
            }
            ++n11;
        }
    }

    public OMGraphic getTileFromProvider(int n2, int n3, int n4, Projection projection) {
        BufferedImage bufferedImage = this.n.getImage(n2, n3, n4);
        try {
            OMGraphic oMGraphic = this.createOMGraphicFromBufferedImage(bufferedImage, n2, n3, n4, projection);
            return oMGraphic;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    protected BufferedImage preprocessImage(Image image, int n2, int n3) throws InterruptedException {
        return BufferedImageHelper.getBufferedImage((Image)image, (int)0, (int)0, (int)256, (int)256, (int)2);
    }

    public TileImageProvider getTileImageProvider() {
        return this.n;
    }
}

