/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.gis;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.gis.AnyLogicMapDB;
import com.anylogic.engine.gis.IImageLoadedListener;
import com.anylogic.engine.gis.ITileURLProvider;
import com.anylogic.engine.gis.d;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.presentation.NetworkActivityMonitorService;
import com.anylogic.engine.presentation.NetworkConnectionHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.mapdb.DB;
import org.mapdb.HTreeMap;

@AnyLogicInternalAPI
public class TileImageProvider
extends com.anylogic.engine.gis.a {
    private final ThreadPoolExecutor a = (ThreadPoolExecutor)Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors() - 1, 1));
    private final Map<String, BufferedImage> n = Collections.synchronizedMap(new a(200));
    private final Set<String> k = Collections.synchronizedSet(new HashSet());
    private final Set<String> m = new HashSet<String>();
    private final BufferedImage h = ff.a(256, 256, true);
    private final com.anylogic.engine.internal.a<IImageLoadedListener> j = new com.anylogic.engine.internal.a();
    private DB i;
    private HTreeMap<int[], byte[]> d;

    public TileImageProvider(d d2) {
        super(d2);
        this.n();
    }

    public TileImageProvider(ITileURLProvider iTileURLProvider) {
        super(iTileURLProvider);
        this.n();
    }

    private void n() {
        Graphics2D graphics2D = this.h.createGraphics();
        try {
            graphics2D.setPaint(new Color(255, 255, 255, 255));
            graphics2D.fillRect(0, 0, 256, 256);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public void cancelLoading() {
        this.a.getQueue().clear();
        this.a.purge();
        this.k.clear();
    }

    @Override
    public byte[] internalGetFromCache(int n2, int n3, int n4) {
        int[] nArray = new int[]{n2, n3, n4};
        byte[] byArray = null;
        try {
            byArray = (byte[])this.m().get((Object)nArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public BufferedImage getImage(final int n2, final int n3, final int n4) {
        final String string = this.k(n2, n3, n4);
        BufferedImage bufferedImage = this.n.get(string);
        if ((bufferedImage == null || this.m.contains(string)) && this.k.add(string)) {
            this.a.execute(new Runnable(){

                @Override
                public void run() {
                    block8: {
                        try {
                            byte[] byArray = TileImageProvider.this.getFromCache(n2, n3, n4);
                            if (byArray == null) {
                                byArray = TileImageProvider.this.a(n2, n3, n4);
                            }
                            if (byArray == null) break block8;
                            BufferedImage bufferedImage = TileImageProvider.this.a(byArray);
                            if (bufferedImage == null) {
                                return;
                            }
                            try {
                                TileImageProvider.this.n.put(string, bufferedImage);
                                TileImageProvider.this.m.remove(string);
                                TileImageProvider.this.k();
                            }
                            catch (Throwable throwable) {}
                        }
                        finally {
                            TileImageProvider.this.k.remove(string);
                        }
                    }
                }
            });
        }
        if (bufferedImage != null && bufferedImage != this.h) {
            return bufferedImage;
        }
        return this.n(n2, n3, n4);
    }

    @AnyLogicInternalAPI
    public boolean isLoading() {
        return !this.k.isEmpty();
    }

    private BufferedImage n(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0) {
            return this.h;
        }
        int n5 = n2;
        int n6 = n3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        while (n9 < 5) {
            int n10 = n5 % 2;
            int n11 = n6 % 2;
            BufferedImage bufferedImage = this.n.get(this.k(n5 /= 2, n6 /= 2, n4 - 1));
            if (bufferedImage != null) {
                n7 = 128 * n10;
                n8 = 128 * n11;
                BufferedImage bufferedImage2 = ff.a(256, 256, true);
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                int n12 = 256 / (int)Math.pow(2.0, n9);
                graphics2D.drawImage(bufferedImage.getSubimage(n7, n8, n12, n12), 0, 0, 256, 256, null);
                String string = this.k(n2, n3, n4);
                this.n.put(string, bufferedImage2);
                this.m.add(string);
                return bufferedImage2;
            }
            ++n9;
        }
        return this.h;
    }

    private String k(int n2, int n3, int n4) {
        return String.valueOf(n4) + "/" + n2 + "/" + n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] a(int n2, int n3, int n4) {
        try {
            String string = this.getTileURLProvider().getTileURL(n2, n3, n4);
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setReadTimeout(15000);
            String string2 = uRLConnection.getContentType();
            if (string2 == null || !"image/jpeg".equals(string2) && !"image/png".equals(string2) && !"image/gif".equals(string2)) {
                String string3 = this.k(n2, n3, n4);
                if (this.n.containsKey(string3)) return null;
                this.n.put(string3, this.h);
                return null;
            }
            Throwable throwable = null;
            Object var9_12 = null;
            try {
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    byte[] byArray;
                    block27: {
                        NetworkConnectionHandler networkConnectionHandler = NetworkActivityMonitorService.createNetworkConnectionStatusMonitor();
                        try {
                            byte[] byArray2;
                            Throwable throwable2 = null;
                            Object var14_19 = null;
                            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                                byte[] byArray3 = new byte[8192];
                                int n5 = 0;
                                while (true) {
                                    if ((n5 = inputStream.read(byArray3)) <= 0) {
                                        byArray2 = byteArrayOutputStream.toByteArray();
                                        break;
                                    }
                                    byteArrayOutputStream.write(byArray3, 0, n5);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                }
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                                throw throwable2;
                            }
                            this.a(n2, n3, n4, byArray2);
                            byArray = byArray2;
                            return byArray;
                        }
                        finally {
                            if (networkConnectionHandler == null) break block27;
                            networkConnectionHandler.close();
                        }
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    return byArray;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void k() {
        for (IImageLoadedListener iImageLoadedListener : this.j) {
            iImageLoadedListener.imageLoaded();
        }
    }

    public void addImageLoadedListener(IImageLoadedListener iImageLoadedListener) {
        this.j.a(iImageLoadedListener);
    }

    public void removeImageLoadedListener(IImageLoadedListener iImageLoadedListener) {
        this.j.n(iImageLoadedListener);
    }

    private HTreeMap<int[], byte[]> m() {
        if (this.d == null) {
            this.d = AnyLogicMapDB.getTileCache(this.h(), this.getTileURLProvider().getSourceName());
        }
        return this.d;
    }

    private DB h() {
        if (this.i == null) {
            this.i = AnyLogicMapDB.getDatabase();
        }
        return this.i;
    }

    @Override
    void a(int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int[] nArray = new int[]{n2, n3, n4};
        try {
            if (!this.h().getEngine().isReadOnly() && !this.m().containsKey((Object)nArray)) {
                this.m().put((Object)nArray, (Object)byArray);
                this.h().commit();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class a<A, B>
    extends LinkedHashMap<A, B> {
        private static final long serialVersionUID = -9034931629652579411L;
        private final int a;

        public a(int n2) {
            super(n2 + 1, 1.0f, true);
            this.a = n2;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<A, B> entry) {
            return super.size() > this.a;
        }
    }
}

