/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Graph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Edge> a = new LinkedHashSet<Edge>();
    private Set<Vertex> n = new LinkedHashSet<Vertex>();

    public Set<Vertex> getVertices() {
        return this.n;
    }

    public Vertex addVertex() {
        Vertex vertex = new Vertex(this);
        this.getVertices().add(vertex);
        return vertex;
    }

    public void removeVertex(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (!this.getVertices().contains(vertex)) {
            throw new IllegalArgumentException("Argument 'vertex' not found in graph");
        }
        HashSet<Edge> hashSet = new HashSet<Edge>(vertex.getIncidents());
        this.removeEdges(hashSet);
        this.getVertices().remove(vertex);
    }

    public void removeVertices(Collection<Vertex> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 'vertices' is null");
        }
        HashSet<Edge> hashSet = new HashSet<Edge>();
        for (Vertex vertex : collection) {
            if (!this.getVertices().contains(vertex)) continue;
            hashSet.addAll(vertex.getIncidents());
        }
        this.removeEdges(hashSet);
        this.getVertices().removeAll(collection);
    }

    public void removeAllVetices() {
        this.removeVertices(new HashSet<Vertex>(this.getVertices()));
    }

    public Set<Edge> getEdges() {
        return this.a;
    }

    public Edge addEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'source' is null");
        }
        if (vertex2 == null) {
            throw new IllegalArgumentException("Argument 'target' is null");
        }
        if (!this.getVertices().contains(vertex)) {
            throw new IllegalArgumentException("Argument 'source' not found in graph");
        }
        if (!this.getVertices().contains(vertex2)) {
            throw new IllegalArgumentException("Argument 'target' not found in graph");
        }
        Edge edge = new Edge(this, vertex, vertex2);
        edge.getSource().addIncident(edge);
        edge.getTarget().addIncident(edge);
        this.getEdges().add(edge);
        return edge;
    }

    public void removeEdge(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!this.getEdges().contains(edge)) {
            throw new IllegalArgumentException("Argument 'edge' not found in graph");
        }
        edge.getSource().removeIncident(edge);
        edge.getTarget().removeIncident(edge);
        this.getEdges().remove(edge);
    }

    public void removeEdges(Collection<Edge> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 'edges' is null");
        }
        for (Edge edge : collection) {
            if (!this.getEdges().contains(edge)) continue;
            edge.getSource().removeIncident(edge);
            edge.getTarget().removeIncident(edge);
        }
        this.getEdges().removeAll(collection);
    }

    public void removeAllEdges() {
        this.removeEdges(new HashSet<Edge>(this.getEdges()));
    }

    public void dispose() {
        for (Edge abstractGraphNode : this.a) {
            abstractGraphNode.dispose();
        }
        this.a.clear();
        for (Vertex vertex : this.n) {
            vertex.dispose();
        }
        this.n.clear();
    }
}

