/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.GraphUtils;
import com.anylogic.engine.graph.Vertex;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GraphPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Graph a;
    @AnyLogicCustomSerialization
    private transient Vertex n;
    @AnyLogicCustomSerialization
    private transient Vertex k;
    @AnyLogicCustomSerialization
    private transient List<Vertex> m;
    @AnyLogicCustomSerialization
    private transient List<Edge> h;

    public GraphPath(Graph graph, List<Vertex> list) {
        this(graph);
        this.a(list);
    }

    private GraphPath(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.a = graph;
        this.h = new LinkedList<Edge>();
        this.m = new LinkedList<Vertex>();
    }

    private void a(List<Vertex> list) {
        if (list == null) {
            return;
        }
        this.m.addAll(list);
        this.h.addAll(GraphUtils.getPathEdges(list));
        if (list.isEmpty()) {
            return;
        }
        this.n = list.get(0);
        this.k = list.get(list.size() - 1);
    }

    public Graph getGraph() {
        return this.a;
    }

    public Vertex getSourceVertex() {
        return this.n;
    }

    public Vertex getTargetVertex() {
        return this.k;
    }

    public List<Vertex> getVertices() {
        return this.m;
    }

    public List<Edge> getEdges() {
        return this.h;
    }

    public GraphPath getReversedPath() {
        LinkedList<Vertex> linkedList = new LinkedList<Vertex>(this.m);
        Collections.reverse(linkedList);
        LinkedList<Edge> linkedList2 = new LinkedList<Edge>(this.h);
        Collections.reverse(linkedList2);
        GraphPath graphPath = new GraphPath(this.a);
        graphPath.m = linkedList;
        graphPath.h = linkedList2;
        graphPath.n = this.k;
        graphPath.k = this.n;
        return graphPath;
    }

    public void dispose() {
        this.a = null;
        this.n = null;
        this.k = null;
        this.m.clear();
        this.h.clear();
    }
}

