/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.AbstractGraphNode;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.IGraphNodeInfo;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class Vertex
extends AbstractGraphNode<IGraphNodeInfo>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Graph a;
    @AnyLogicCustomSerialization
    private transient Set<Edge> n;
    @AnyLogicCustomSerialization
    private transient Set<Edge> k;
    @AnyLogicCustomSerialization
    private transient Set<Edge> m;

    protected Vertex(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.a = graph;
        this.n = new LinkedHashSet<Edge>();
        this.k = new LinkedHashSet<Edge>();
        this.m = new LinkedHashSet<Edge>();
    }

    public Graph getGraph() {
        return this.a;
    }

    public Set<Edge> getInternalEdges() {
        return this.n;
    }

    public Set<Edge> getExternalEdges() {
        return this.k;
    }

    public Set<Edge> getIncidents() {
        return this.m;
    }

    public void addIncident(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (edge.getSource() == this) {
            this.n.add(edge);
        } else if (edge.getTarget() == this) {
            this.k.add(edge);
        } else {
            throw new IllegalArgumentException("Incorrect 'edge' state");
        }
        this.m.add(edge);
    }

    public void removeIncident(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (edge.getSource() == this) {
            this.n.remove(edge);
        } else if (edge.getTarget() == this) {
            this.k.remove(edge);
        } else {
            throw new IllegalArgumentException("Incorrect 'edge' state");
        }
        this.m.remove(edge);
    }

    public Edge findEdge(Vertex vertex, boolean bl2) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'target' is null");
        }
        Set<Edge> set = this.m;
        if (bl2) {
            set = this.n;
        }
        Edge edge = null;
        for (Edge edge2 : set) {
            if (edge2.getOpposite(this) != vertex) continue;
            edge = edge2;
            break;
        }
        return edge;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.a = null;
        this.n.clear();
        this.k.clear();
        this.m.clear();
    }
}

