/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.graph.algorithms.IEdgeGeometryInfo;
import java.io.Serializable;

public class EdgeGeometryInfoImpl
implements IEdgeGeometryInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Edge a;
    private double n;
    private double k;
    private double m;
    private double h;
    private double j;

    public EdgeGeometryInfoImpl(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        this.a = edge;
        this.initialize();
    }

    protected void initialize() {
        Object t = GeometryUtils.getGeometryInfo(this.a.getSource());
        this.n = t.getX();
        this.k = t.getY();
        Object t2 = GeometryUtils.getGeometryInfo(this.a.getTarget());
        this.m = t2.getX();
        this.h = t2.getY();
        this.j = Utilities.getDistance(this.n, this.k, this.m, this.h);
    }

    @Override
    public Edge getEdge() {
        return this.a;
    }

    @Override
    public double getSourceX() {
        return this.n;
    }

    @Override
    public double getSourceY() {
        return this.k;
    }

    @Override
    public double getTargetX() {
        return this.m;
    }

    @Override
    public double getTargetY() {
        return this.h;
    }

    @Override
    public double getLength() {
        return this.j;
    }

    @Override
    public void dispose() {
        this.a = null;
    }
}

