/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.impl;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.IEdgeGeometryInfo;
import com.anylogic.engine.graph.algorithms.IGeometryInfoFactory;
import com.anylogic.engine.graph.algorithms.IVertexGeometryInfo;
import com.anylogic.engine.graph.algorithms.impl.EdgeGeometryInfoImpl;
import com.anylogic.engine.graph.algorithms.impl.VertexGeometryInfoImpl;
import java.util.Map;

public class GeometryInfoFactoryImpl
implements IGeometryInfoFactory {
    @Override
    public <T extends IVertexGeometryInfo> T createVertexInfo(Vertex vertex, Map<String, Object> map) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Argument 'params' is null");
        }
        if (!map.containsKey("X")) {
            throw new IllegalArgumentException("Argument 'params' not contains 'X' property");
        }
        if (!map.containsKey("Y")) {
            throw new IllegalArgumentException("Argument 'params' not contains 'Y' property");
        }
        Double d2 = (Double)map.get("X");
        Double d3 = (Double)map.get("Y");
        return (T)new VertexGeometryInfoImpl(vertex, d2, d3);
    }

    @Override
    public <T extends IEdgeGeometryInfo> T createEdgeInfo(Edge edge, Map<String, Object> map) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        return (T)new EdgeGeometryInfoImpl(edge);
    }
}

