/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class Triangle
implements Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Triangulation a;
    @AnyLogicCustomSerialization
    private transient Set<Vertex> n;
    @AnyLogicCustomSerialization
    private transient Set<Edge> k;
    @AnyLogicCustomSerialization
    private transient Set<Triangle> m;

    protected Triangle(Triangulation triangulation, Edge edge, Edge edge2, Edge edge3) {
        if (triangulation == null) {
            throw new IllegalArgumentException("Argument 'triangulation' is null");
        }
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge1' is null");
        }
        if (edge2 == null) {
            throw new IllegalArgumentException("Argument 'edge2' is null");
        }
        if (edge3 == null) {
            throw new IllegalArgumentException("Argument 'edge3' is null");
        }
        this.a = triangulation;
        this.a();
        this.initialize(edge, edge2, edge3);
    }

    private void a() {
        this.n = new LinkedHashSet<Vertex>();
        this.k = new LinkedHashSet<Edge>();
        this.m = new LinkedHashSet<Triangle>();
    }

    protected void initialize(Edge edge, Edge edge2, Edge edge3) {
        this.k.add(edge);
        this.k.add(edge2);
        this.k.add(edge3);
        if (this.k.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
        this.n.addAll(edge.getIncidents());
        this.n.addAll(edge2.getIncidents());
        this.n.addAll(edge3.getIncidents());
        if (this.n.size() != 3) {
            throw new RuntimeException("Cannot create triangle");
        }
    }

    public Triangulation getTriangulation() {
        return this.a;
    }

    public Set<Vertex> getVertices() {
        return this.n;
    }

    public Set<Edge> getEdges() {
        return this.k;
    }

    public Set<Triangle> getIncidents() {
        return this.m;
    }

    public void addIncident(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        Set<Edge> set = this.getEdge(triangle);
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.m.add(triangle);
    }

    public void removeIncident(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!this.m.contains(triangle)) {
            throw new IllegalArgumentException("Incorrect 'triangle' not found");
        }
        this.m.remove(triangle);
    }

    public Set<Vertex> getVertices(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>(this.n);
        linkedHashSet.retainAll(triangle.getVertices());
        return linkedHashSet;
    }

    public Set<Edge> getEdge(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        LinkedHashSet<Edge> linkedHashSet = new LinkedHashSet<Edge>(this.k);
        linkedHashSet.retainAll(triangle.getEdges());
        return linkedHashSet;
    }

    public Triangle getOppositeTriangle(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!this.k.contains(edge)) {
            throw new IllegalArgumentException("Argument 'edge' not found in tirangle");
        }
        Triangle triangle = null;
        for (Triangle triangle2 : this.m) {
            if (!triangle2.getEdges().contains(edge)) continue;
            triangle = triangle2;
            break;
        }
        return triangle;
    }

    public Edge getEdge(Vertex vertex, Vertex vertex2) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'sourceVertex' is null");
        }
        if (vertex2 == null) {
            throw new IllegalArgumentException("Argument 'targetVertex' is null");
        }
        if (!this.n.contains(vertex)) {
            throw new IllegalArgumentException("Argument 'sourceVertex' not found in triangle");
        }
        if (!this.n.contains(vertex2)) {
            throw new IllegalArgumentException("Argument 'targetVertex' not found in triangle");
        }
        Edge edge = null;
        for (Edge edge2 : this.k) {
            Vertex vertex3 = edge2.getSource();
            Vertex vertex4 = edge2.getTarget();
            if ((vertex3 != vertex || vertex4 != vertex2) && (vertex3 != vertex2 || vertex4 != vertex)) continue;
            edge = edge2;
            break;
        }
        return edge;
    }

    public void dispose() {
        this.a = null;
        this.n.clear();
        this.k.clear();
        this.m.clear();
    }
}

