/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GraphNodeInfos;
import com.anylogic.engine.graph.algorithms.triangulation.ITriangulationInfoFactory;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import com.anylogic.engine.graph.algorithms.triangulation.TriangulationUtils;
import com.anylogic.engine.graph.algorithms.triangulation.impl.EdgeTriangulationInfoImpl;
import com.anylogic.engine.graph.algorithms.triangulation.impl.TriangulationInfoFactoryImpl;
import com.anylogic.engine.graph.algorithms.triangulation.impl.VertexTriangulationInfoImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Triangulation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ITriangulationInfoFactory a;
    private Graph n;
    private Set<Triangle> k;

    public Triangulation(Graph graph) {
        this(graph, new TriangulationInfoFactoryImpl());
    }

    public Triangulation(Graph graph, ITriangulationInfoFactory iTriangulationInfoFactory) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        if (iTriangulationInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'triangulationInfoFactory' is null");
        }
        this.n = graph;
        this.a = iTriangulationInfoFactory;
        this.a();
    }

    private void a() {
        this.k = new LinkedHashSet<Triangle>();
        for (Vertex abstractGraphNode : this.n.getVertices()) {
            this.a(abstractGraphNode);
        }
        for (Edge edge : this.n.getEdges()) {
            this.a(edge);
        }
    }

    public Graph getGraph() {
        return this.n;
    }

    public Set<Triangle> getTriangles() {
        return this.k;
    }

    public ITriangulationInfoFactory getTriangulationInfoFactory() {
        return this.a;
    }

    public Triangle addTriangle(Edge edge, Edge edge2, Edge edge3) {
        if (edge == null) {
            throw new IllegalArgumentException("Argumet 'edge1' is null");
        }
        if (edge2 == null) {
            throw new IllegalArgumentException("Argumet 'edge2' is null");
        }
        if (edge3 == null) {
            throw new IllegalArgumentException("Argumet 'edge3' is null");
        }
        if (!this.n.getEdges().contains(edge)) {
            throw new IllegalArgumentException("Argumet 'edge1' not found in graph");
        }
        if (!this.n.getEdges().contains(edge2)) {
            throw new IllegalArgumentException("Argumet 'edge2' not found in graph");
        }
        if (!this.n.getEdges().contains(edge3)) {
            throw new IllegalArgumentException("Argumet 'edge3' not found in graph");
        }
        Triangle triangle = new Triangle(this, edge, edge2, edge3);
        this.a(triangle);
        this.k.add(triangle);
        return triangle;
    }

    public void removeTriangle(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!this.k.contains(triangle)) {
            throw new IllegalArgumentException("Argument 'triangle' not found in triangulation");
        }
        this.n(triangle);
        this.k.remove(triangle);
    }

    public Set<Triangle> findTriangles(Edge edge, Edge edge2, Edge edge3) {
        if (edge == null) {
            throw new IllegalArgumentException("Argumet 'edge1' is null");
        }
        if (edge2 == null) {
            throw new IllegalArgumentException("Argumet 'edge2' is null");
        }
        if (edge3 == null) {
            throw new IllegalArgumentException("Argumet 'edge3' is null");
        }
        HashSet<Triangle> hashSet = new HashSet<Triangle>();
        Object t = TriangulationUtils.getTriangulationInfo(edge);
        hashSet.addAll(t.getTriangles());
        Object t2 = TriangulationUtils.getTriangulationInfo(edge2);
        hashSet.retainAll(t2.getTriangles());
        Object t3 = TriangulationUtils.getTriangulationInfo(edge3);
        hashSet.retainAll(t3.getTriangles());
        return hashSet;
    }

    public Set<Triangle> findTriangles(Vertex vertex, Vertex vertex2, Vertex vertex3) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argumet 'vertex1' is null");
        }
        if (vertex2 == null) {
            throw new IllegalArgumentException("Argumet 'vertex2' is null");
        }
        if (vertex3 == null) {
            throw new IllegalArgumentException("Argumet 'vertex3' is null");
        }
        HashSet<Triangle> hashSet = new HashSet<Triangle>();
        Object t = TriangulationUtils.getTriangulationInfo(vertex);
        hashSet.addAll(t.getTriangles());
        Object t2 = TriangulationUtils.getTriangulationInfo(vertex2);
        hashSet.retainAll(t2.getTriangles());
        Object t3 = TriangulationUtils.getTriangulationInfo(vertex3);
        hashSet.retainAll(t3.getTriangles());
        return hashSet;
    }

    private void a(Triangle triangle) {
        for (Edge abstractGraphNode : triangle.getEdges()) {
            this.a(abstractGraphNode, triangle);
        }
        for (Vertex vertex : triangle.getVertices()) {
            this.a(vertex, triangle);
        }
    }

    private void a(Edge edge, Triangle triangle) {
        EdgeTriangulationInfoImpl edgeTriangulationInfoImpl = (EdgeTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(edge);
        for (Triangle triangle2 : edgeTriangulationInfoImpl.getTriangles()) {
            if (triangle == triangle2) continue;
            triangle2.addIncident(triangle);
            triangle.addIncident(triangle2);
        }
        edgeTriangulationInfoImpl.addTriangle(triangle);
    }

    private void a(Vertex vertex, Triangle triangle) {
        VertexTriangulationInfoImpl vertexTriangulationInfoImpl = (VertexTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(vertex);
        vertexTriangulationInfoImpl.addTriangle(triangle);
    }

    private void n(Triangle triangle) {
        for (Edge abstractGraphNode : triangle.getEdges()) {
            this.n(abstractGraphNode, triangle);
        }
        for (Vertex vertex : triangle.getVertices()) {
            this.n(vertex, triangle);
        }
    }

    private void n(Edge edge, Triangle triangle) {
        EdgeTriangulationInfoImpl edgeTriangulationInfoImpl = (EdgeTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(edge);
        for (Triangle triangle2 : edgeTriangulationInfoImpl.getTriangles()) {
            if (triangle2 == triangle) continue;
            triangle2.removeIncident(triangle);
            triangle.removeIncident(triangle2);
        }
        edgeTriangulationInfoImpl.removeTriangle(triangle);
    }

    private void n(Vertex vertex, Triangle triangle) {
        VertexTriangulationInfoImpl vertexTriangulationInfoImpl = (VertexTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(vertex);
        vertexTriangulationInfoImpl.removeTriangle(triangle);
    }

    public Edge addEdge(Vertex vertex, Vertex vertex2) {
        Edge edge = this.n.addEdge(vertex, vertex2);
        this.a(edge);
        return edge;
    }

    public void removeEdge(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!this.n.getEdges().contains(edge)) {
            throw new IllegalArgumentException("Argument 'edge' not found in graph");
        }
        EdgeTriangulationInfoImpl edgeTriangulationInfoImpl = (EdgeTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(edge);
        LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>(edgeTriangulationInfoImpl.getTriangles());
        for (Triangle triangle : linkedHashSet) {
            this.removeTriangle(triangle);
        }
        this.n.removeEdge(edge);
    }

    private void a(Edge edge) {
        TriangulationUtils.addTriangulationInfo(edge, this.a, Collections.emptyMap());
    }

    public Vertex addVertex() {
        Vertex vertex = this.n.addVertex();
        this.a(vertex);
        return vertex;
    }

    public void removeVertex(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (!this.n.getVertices().contains(vertex)) {
            throw new IllegalArgumentException("Argument 'vertex' not found in graph");
        }
        VertexTriangulationInfoImpl vertexTriangulationInfoImpl = (VertexTriangulationInfoImpl)TriangulationUtils.getTriangulationInfo(vertex);
        LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>(vertexTriangulationInfoImpl.getTriangles());
        for (Triangle triangle : linkedHashSet) {
            this.removeTriangle(triangle);
        }
        this.n.removeVertex(vertex);
    }

    private void a(Vertex vertex) {
        TriangulationUtils.addTriangulationInfo(vertex, this.a, Collections.emptyMap());
    }

    public void dispose() {
        Object v;
        for (Vertex abstractGraphNode : this.n.getVertices()) {
            v = abstractGraphNode.removeInfo(GraphNodeInfos.Triangulation.getName());
            v.dispose();
        }
        for (Edge edge : this.n.getEdges()) {
            v = edge.removeInfo(GraphNodeInfos.Triangulation.getName());
            v.dispose();
        }
        this.n = null;
        this.a = null;
        this.k.clear();
    }
}

