/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Graph;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import com.anylogic.engine.graph.algorithms.triangulation.Triangulation;
import java.util.LinkedHashSet;
import java.util.Set;

public class TriangulationBuilder {
    protected Graph graph;

    public TriangulationBuilder(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Triangulation build() {
        Triangulation triangulation = new Triangulation(this.graph);
        this.a(triangulation);
        return triangulation;
    }

    private Set<Triangle> a(Triangulation triangulation) {
        LinkedHashSet<Triangle> linkedHashSet = new LinkedHashSet<Triangle>();
        Graph graph = triangulation.getGraph();
        for (Edge edge : graph.getEdges()) {
            Vertex vertex;
            Vertex vertex2 = edge.getSource();
            if (vertex2 == (vertex = edge.getTarget())) continue;
            Set<Vertex> set = this.a(graph, edge);
            for (Vertex vertex3 : set) {
                Set<Triangle> set2 = triangulation.findTriangles(vertex2, vertex, vertex3);
                if (!set2.isEmpty()) continue;
                Edge edge2 = vertex2.findEdge(vertex3, false);
                Edge edge3 = vertex.findEdge(vertex3, false);
                Triangle triangle = triangulation.addTriangle(edge2, edge3, edge);
                linkedHashSet.add(triangle);
            }
        }
        return linkedHashSet;
    }

    private Set<Vertex> a(Graph graph, Edge edge) {
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>();
        Vertex vertex = edge.getSource();
        Vertex vertex2 = edge.getTarget();
        Set<Edge> set = vertex.getIncidents();
        Set<Edge> set2 = vertex2.getIncidents();
        for (Edge edge2 : set) {
            if (edge2 == edge) continue;
            for (Edge edge3 : set2) {
                Vertex vertex3;
                Vertex vertex4;
                if (edge3 == edge || (vertex4 = edge2.getOpposite(vertex)) != (vertex3 = edge3.getOpposite(vertex2)) || vertex4 == vertex || vertex4 == vertex2) continue;
                linkedHashSet.add(vertex4);
            }
        }
        return linkedHashSet;
    }

    public void dispose() {
        this.graph = null;
    }
}

