/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation;

import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.graph.algorithms.GraphNodeInfos;
import com.anylogic.engine.graph.algorithms.triangulation.IEdgeTriangulationInfo;
import com.anylogic.engine.graph.algorithms.triangulation.ITriangulationInfoFactory;
import com.anylogic.engine.graph.algorithms.triangulation.IVertexTriangulationInfo;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import java.util.Iterator;
import java.util.Map;

public final class TriangulationUtils {
    private TriangulationUtils() {
        throw new UnsupportedOperationException();
    }

    public static <T extends IVertexTriangulationInfo> T addTriangulationInfo(Vertex vertex, ITriangulationInfoFactory iTriangulationInfoFactory, Map<String, Object> map) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (iTriangulationInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        Object t = iTriangulationInfoFactory.createVertexInfo(vertex, map);
        vertex.addInfo(GraphNodeInfos.Triangulation.getName(), t);
        return t;
    }

    public static <T extends IVertexTriangulationInfo> T getTriangulationInfo(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        if (!vertex.isSupportedInfo(GraphNodeInfos.Triangulation.getName())) {
            throw new IllegalArgumentException("Argument 'vertex' not supported triangulation info");
        }
        return (T)((IVertexTriangulationInfo)vertex.getInfo(GraphNodeInfos.Triangulation.getName()));
    }

    public static <T extends IEdgeTriangulationInfo> T addTriangulationInfo(Edge edge, ITriangulationInfoFactory iTriangulationInfoFactory, Map<String, Object> map) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (iTriangulationInfoFactory == null) {
            throw new IllegalArgumentException("Argument 'factory' is null");
        }
        Object t = iTriangulationInfoFactory.createEdgeInfo(edge, map);
        edge.addInfo(GraphNodeInfos.Triangulation.getName(), t);
        return t;
    }

    public static <T extends IEdgeTriangulationInfo> T getTriangulationInfo(Edge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Argument 'edge' is null");
        }
        if (!edge.isSupportedInfo(GraphNodeInfos.Triangulation.getName())) {
            throw new IllegalArgumentException("Argument 'edge' not supported triangulation info");
        }
        return (T)((IEdgeTriangulationInfo)edge.getInfo(GraphNodeInfos.Triangulation.getName()));
    }

    public static boolean inCircumcircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12;
        if (Math.abs(d5 - d7) < d10 && Math.abs(d7 - d9) < d10) {
            return false;
        }
        if (Math.abs(d7 - d5) < d10) {
            double d13 = -(d8 - d6) / (d9 - d7);
            double d14 = (d6 + d8) * 0.5;
            double d15 = (d7 + d9) * 0.5;
            d12 = (d6 + d4) * 0.5;
            d11 = d13 * (d12 - d14) + d15;
        } else if (Math.abs(d9 - d7) < d10) {
            double d16 = -(d6 - d4) / (d7 - d5);
            double d17 = (d4 + d6) * 0.5;
            double d18 = (d5 + d7) * 0.5;
            d12 = (d8 + d6) * 0.5;
            d11 = d16 * (d12 - d17) + d18;
        } else {
            double d19 = -(d6 - d4) / (d7 - d5);
            double d20 = -(d8 - d6) / (d9 - d7);
            double d21 = (d4 + d6) * 0.5;
            double d22 = (d6 + d8) * 0.5;
            double d23 = (d5 + d7) * 0.5;
            double d24 = (d7 + d9) * 0.5;
            d12 = (d19 * d21 - d20 * d22 + d24 - d23) / (d19 - d20);
            d11 = d19 * (d12 - d21) + d23;
        }
        double d25 = d6 - d12;
        double d26 = d7 - d11;
        double d27 = d25 * d25 + d26 * d26;
        d25 = d2 - d12;
        d26 = d3 - d11;
        double d28 = d25 * d25 + d26 * d26;
        return d28 <= d27 || Math.abs(d28 - d27) < d10;
    }

    public static GeometryUtils.Point getCentroidPoint(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        Iterator<Vertex> iterator = triangle.getVertices().iterator();
        Vertex vertex = iterator.next();
        Vertex vertex2 = iterator.next();
        Vertex vertex3 = iterator.next();
        Object t = GeometryUtils.getGeometryInfo(vertex);
        double d2 = t.getX();
        double d3 = t.getY();
        Object t2 = GeometryUtils.getGeometryInfo(vertex2);
        double d4 = t2.getX();
        double d5 = t2.getY();
        Object t3 = GeometryUtils.getGeometryInfo(vertex3);
        double d6 = t3.getX();
        double d7 = t3.getY();
        double d8 = (d2 + d4) * 0.5;
        double d9 = (d3 + d5) * 0.5;
        double d10 = (d6 + d2) * 0.5;
        double d11 = (d7 + d3) * 0.5;
        GeometryUtils.Point point = GeometryUtils.intersectionSegments(new GeometryUtils.Point(), d4, d5, d10, d11, d6, d7, d8, d9, false);
        return point;
    }
}

