/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Edge;
import com.anylogic.engine.graph.algorithms.triangulation.IEdgeTriangulationInfo;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class EdgeTriangulationInfoImpl
implements IEdgeTriangulationInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    private transient Edge a;
    @AnyLogicCustomSerialization
    private transient Set<Triangle> n;

    public EdgeTriangulationInfoImpl(Edge edge) {
        this.a = edge;
        this.n = new LinkedHashSet<Triangle>();
    }

    public Edge getEdge() {
        return this.a;
    }

    @Override
    public Set<Triangle> getTriangles() {
        return this.n;
    }

    public void addTriangle(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!triangle.getEdges().contains(this.a)) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.n.add(triangle);
    }

    public void removeTriangle(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!triangle.getEdges().contains(this.a)) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.n.remove(triangle);
    }

    @Override
    public void dispose() {
        this.a = null;
        this.n.clear();
    }
}

