/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.graph.algorithms.triangulation.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.graph.Vertex;
import com.anylogic.engine.graph.algorithms.triangulation.IVertexTriangulationInfo;
import com.anylogic.engine.graph.algorithms.triangulation.Triangle;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public class VertexTriangulationInfoImpl
implements IVertexTriangulationInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    protected transient Vertex vertex;
    @AnyLogicCustomSerialization
    protected transient Set<Triangle> triangles;

    public VertexTriangulationInfoImpl(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("Argument 'vertex' is null");
        }
        this.vertex = vertex;
        this.triangles = new LinkedHashSet<Triangle>();
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    @Override
    public Set<Triangle> getTriangles() {
        return this.triangles;
    }

    public void addTriangle(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!triangle.getVertices().contains(this.vertex)) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.triangles.add(triangle);
    }

    public void removeTriangle(Triangle triangle) {
        if (triangle == null) {
            throw new IllegalArgumentException("Argument 'triangle' is null");
        }
        if (!triangle.getVertices().contains(this.vertex)) {
            throw new IllegalArgumentException("Incorrect 'triangle' state");
        }
        this.triangles.remove(triangle);
    }

    @Override
    public void dispose() {
        this.vertex = null;
        this.triangles.clear();
    }
}

