/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.graph.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.IGVertex;
import com.anylogic.engine.internal.graph.impl.GAbstractEdge;
import com.anylogic.engine.internal.graph.impl.GAbstractGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GAbstractVertex<G extends GAbstractGraph<G, V, E>, V extends GAbstractVertex<G, V, E>, E extends GAbstractEdge<G, V, E>>
implements IGVertex<G, V, E>,
Serializable {
    private static final long serialVersionUID = 1L;
    @AnyLogicCustomSerialization
    protected transient G graph;
    @AnyLogicCustomSerialization
    protected transient List<E> edges = new ArrayList(0);
    @AnyLogicCustomSerialization
    protected transient List<E> outcomingEdges = new ArrayList(0);
    @AnyLogicCustomSerialization
    protected transient List<E> incomingEdges = new ArrayList(0);
    @AnyLogicCustomSerialization
    protected transient List<E> unmodifiableEdges = Collections.unmodifiableList(this.edges);
    @AnyLogicCustomSerialization
    protected transient List<E> unmodifiableOutcomingEdges = Collections.unmodifiableList(this.outcomingEdges);
    @AnyLogicCustomSerialization
    protected transient List<E> unmodifiableIncomingEdges = Collections.unmodifiableList(this.incomingEdges);

    public G getGraph() {
        return this.graph;
    }

    protected void setGraph(G g2) {
        this.graph = g2;
    }

    @Override
    public List<E> getEdges() {
        return this.unmodifiableEdges;
    }

    @Override
    public List<E> getOutcomingEdges() {
        return this.unmodifiableOutcomingEdges;
    }

    @Override
    public List<E> getIncomingEdges() {
        return this.unmodifiableIncomingEdges;
    }

    @Override
    public E findEdge(V v) {
        return this.a(this.edges, v);
    }

    @Override
    public E findIncomingEdge(V v) {
        return this.a(this.incomingEdges, v);
    }

    @Override
    public E findOutcomingEdge(V v) {
        return this.a(this.outcomingEdges, v);
    }

    private E a(Collection<? extends E> collection, V v) {
        for (GAbstractEdge gAbstractEdge : collection) {
            if (gAbstractEdge.getOpposite(v) != this) continue;
            return (E)gAbstractEdge;
        }
        return null;
    }

    @Override
    public List<E> findAllEdges(V v) {
        return this.n(this.edges, v);
    }

    @Override
    public List<E> findAllIncomingEdges(V v) {
        return this.n(this.incomingEdges, v);
    }

    @Override
    public List<E> findAllOutcomingEdges(V v) {
        return this.n(this.outcomingEdges, v);
    }

    private List<E> n(Collection<? extends E> collection, V v) {
        ArrayList<GAbstractEdge> arrayList = new ArrayList<GAbstractEdge>(1);
        for (GAbstractEdge gAbstractEdge : collection) {
            if (gAbstractEdge.getOpposite(v) != this) continue;
            arrayList.add(gAbstractEdge);
        }
        return arrayList;
    }

    protected void addEdge(E e2) {
        if (((GAbstractEdge)e2).getSource() == this) {
            this.outcomingEdges.add(e2);
        }
        if (((GAbstractEdge)e2).getTarget() == this) {
            this.incomingEdges.add(e2);
        }
        this.edges.add(e2);
    }

    protected void removeEdge(E e2) {
        if (((GAbstractEdge)e2).getSource() == this) {
            this.outcomingEdges.remove(e2);
        }
        if (((GAbstractEdge)e2).getTarget() == this) {
            this.incomingEdges.remove(e2);
        }
        this.edges.remove(e2);
    }
}

