/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.graph.pathfinding;

import com.anylogic.engine.internal.graph.IGEdge;
import com.anylogic.engine.internal.graph.IGGraph;
import com.anylogic.engine.internal.graph.IGVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GPath<G extends IGGraph<G, V, E>, V extends IGVertex<G, V, E>, E extends IGEdge<G, V, E>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private G a;
    private V n;
    private V k;
    private List<V> m;
    private List<E> h;

    private GPath(G g2) {
        if (g2 == null) {
            throw new IllegalArgumentException("Argument 'graph' is null");
        }
        this.a = g2;
        this.h = new ArrayList();
        this.m = new ArrayList<V>();
    }

    public GPath(G g2, List<V> list) {
        this(g2);
        super.a(list);
    }

    private void a(List<V> list) {
        if (list == null) {
            return;
        }
        this.m.addAll(list);
        this.h.addAll(this.getPathEdges(list));
        if (list.isEmpty()) {
            return;
        }
        this.n = (IGVertex)list.get(0);
        this.k = (IGVertex)list.get(list.size() - 1);
    }

    public List<E> getPathEdges(List<V> list) {
        LinkedList linkedList = new LinkedList();
        if (list == null) {
            return linkedList;
        }
        Iterator<V> iterator = list.iterator();
        Iterator<V> iterator2 = list.iterator();
        if (!iterator2.hasNext()) {
            return linkedList;
        }
        iterator2.next();
        while (iterator2.hasNext()) {
            IGVertex iGVertex = (IGVertex)iterator.next();
            IGVertex iGVertex2 = (IGVertex)iterator2.next();
            Object e2 = iGVertex.findEdge(iGVertex2);
            linkedList.add(e2);
        }
        return linkedList;
    }

    public G getGraph() {
        return this.a;
    }

    public V getSourceVertex() {
        return this.n;
    }

    public V getTargetVertex() {
        return this.k;
    }

    public List<V> getVertices() {
        return this.m;
    }

    public List<E> getEdges() {
        return this.h;
    }

    public GPath<G, V, E> inverse() {
        LinkedList<V> linkedList = new LinkedList<V>(this.m);
        Collections.reverse(linkedList);
        LinkedList<E> linkedList2 = new LinkedList<E>(this.h);
        Collections.reverse(linkedList2);
        GPath<G, V, E> gPath = new GPath<G, V, E>(this.a);
        gPath.m = linkedList;
        gPath.h = linkedList2;
        gPath.n = this.k;
        gPath.k = this.n;
        return gPath;
    }

    public void dispose() {
        this.a = null;
        this.n = null;
        this.k = null;
        this.m.clear();
        this.h.clear();
    }
}

