/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh;

import com.anylogic.engine.Utilities;
import com.anylogic.engine.graph.algorithms.GeometryUtils;
import com.anylogic.engine.internal.mesh.MPoint;
import java.util.List;

public class MUtilities {
    public static final boolean DEBUG = false;

    public static double sign(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (d2 - d6) * (d5 - d7) - (d4 - d6) * (d3 - d7);
    }

    public static boolean isInTriangle(MPoint mPoint, MPoint mPoint2, MPoint mPoint3, double d2, double d3) {
        boolean bl2;
        boolean bl3 = MUtilities.sign(d2, d3, mPoint.getX(), mPoint.getY(), mPoint2.getX(), mPoint2.getY()) < 0.0;
        boolean bl4 = MUtilities.sign(d2, d3, mPoint2.getX(), mPoint2.getY(), mPoint3.getX(), mPoint3.getY()) < 0.0;
        boolean bl5 = bl2 = MUtilities.sign(d2, d3, mPoint3.getX(), mPoint3.getY(), mPoint.getX(), mPoint.getY()) < 0.0;
        return bl3 == bl4 && bl4 == bl2;
    }

    public static double getDistance(MPoint mPoint, MPoint mPoint2) {
        return Utilities.getDistance(mPoint.getX(), mPoint.getY(), mPoint2.getX(), mPoint2.getY());
    }

    public static MPoint getLinePointByOffset(MPoint mPoint, MPoint mPoint2, double d2) {
        double d3 = MUtilities.getDistance(mPoint, mPoint2);
        double d4 = (mPoint2.getX() - mPoint.getX()) / d3;
        double d5 = (mPoint2.getY() - mPoint.getY()) / d3;
        double d6 = mPoint.getX() + d4 * d2;
        double d7 = mPoint.getY() + d5 * d2;
        return new MPoint(d6, d7);
    }

    public static MPoint getTriangleCentroid(MPoint mPoint, MPoint mPoint2, MPoint mPoint3) {
        double d2 = (mPoint.x + mPoint2.x + mPoint3.x) / 3.0;
        double d3 = (mPoint.y + mPoint2.y + mPoint3.y) / 3.0;
        return new MPoint(d2, d3);
    }

    public static MPoint getPolygonCentroid(List<MPoint> list) {
        MPoint mPoint;
        if (list.size() == 3) {
            return MUtilities.getTriangleCentroid(list.get(0), list.get(1), list.get(2));
        }
        MPoint mPoint2 = new MPoint();
        double d2 = 0.0;
        double d3 = 0.0;
        MPoint mPoint3 = mPoint = list.get(0);
        int n2 = 0;
        while (n2 < list.size() - 1) {
            MPoint mPoint4;
            MPoint mPoint5 = list.get(n2);
            mPoint3 = mPoint4 = list.get(n2 + 1);
            d3 = mPoint5.getX() * mPoint4.getY() - mPoint4.getX() * mPoint5.getY();
            d2 += d3;
            mPoint2.x += (mPoint5.getX() + mPoint4.getX()) * d3;
            mPoint2.y += (mPoint5.getY() + mPoint4.getY()) * d3;
            ++n2;
        }
        d3 = mPoint3.getX() * mPoint.getY() - mPoint.getX() * mPoint3.getY();
        d2 += d3;
        mPoint2.x += (mPoint3.getX() + mPoint.getX()) * d3;
        mPoint2.y += (mPoint3.getY() + mPoint.getY()) * d3;
        mPoint2.x /= 6.0 * (d2 *= 0.5);
        mPoint2.y /= 6.0 * d2;
        return mPoint2;
    }

    public static boolean isInPolygon(List<MPoint> list, double d2, double d3) {
        boolean bl2 = false;
        if (list.size() < 3) {
            return bl2;
        }
        MPoint mPoint = list.get(list.size() - 1);
        int n2 = 0;
        while (n2 < list.size()) {
            MPoint mPoint2;
            MPoint mPoint3;
            MPoint mPoint4 = list.get(n2);
            if (mPoint4.getX() > mPoint.getX()) {
                mPoint3 = mPoint;
                mPoint2 = mPoint4;
            } else {
                mPoint3 = mPoint4;
                mPoint2 = mPoint;
            }
            if (mPoint4.getX() < d2 == d2 <= mPoint.getX() && (d3 - mPoint3.getY()) * (mPoint2.getX() - mPoint3.getX()) < (mPoint2.getY() - mPoint3.getY()) * (d2 - mPoint3.getX())) {
                bl2 = !bl2;
            }
            mPoint = mPoint4;
            ++n2;
        }
        return bl2;
    }

    public static MPoint intersect(MPoint mPoint, MPoint mPoint2, MPoint mPoint3, MPoint mPoint4) {
        GeometryUtils.Point point = GeometryUtils.intersectionSegments(mPoint.getX(), mPoint.getY(), mPoint2.getX(), mPoint2.getY(), mPoint3.getX(), mPoint3.getY(), mPoint4.getX(), mPoint4.getY(), false);
        return new MPoint(point.getX(), point.getY());
    }
}

