/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.impl;

import com.anylogic.engine.internal.graph.impl.GAbstractEdge;
import com.anylogic.engine.internal.mesh.IMEdge;
import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.impl.MAbstractMesh;
import com.anylogic.engine.internal.mesh.impl.MAbstractVertex;
import java.awt.geom.Line2D;

public abstract class MAbstractEdge<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
extends GAbstractEdge<G, V, E>
implements IMEdge<G, V, E> {
    private static final long serialVersionUID = 1L;
    protected MPoint gateLeft;
    protected MPoint gateRight;
    protected MPoint portalLeft;
    protected MPoint portalRight;
    protected MPoint centroid;

    @Override
    public MPoint getGateLeft() {
        return this.gateLeft;
    }

    @Override
    public MPoint getGateRight() {
        return this.gateRight;
    }

    @Override
    public MPoint getPortalLeft() {
        return this.portalLeft;
    }

    @Override
    public MPoint getPortalRight() {
        return this.portalRight;
    }

    @Override
    public MPoint getCentroid() {
        return this.centroid;
    }

    protected void setGate(MPoint mPoint, MPoint mPoint2) {
        if (mPoint == null) {
            throw new IllegalArgumentException("Argument 'p0' is null");
        }
        if (mPoint2 == null) {
            throw new IllegalArgumentException("Argument 'p1' is null");
        }
        if (Line2D.relativeCCW(mPoint.getX(), mPoint.getY(), mPoint2.getX(), mPoint2.getY(), ((MAbstractVertex)this.source).getCentroid().getX(), ((MAbstractVertex)this.source).getCentroid().getY()) > 0) {
            this.gateLeft = mPoint;
            this.gateRight = mPoint2;
        } else {
            this.gateLeft = mPoint2;
            this.gateRight = mPoint;
        }
        this.centroid = new MPoint((this.gateLeft.x + this.gateRight.x) / 2.0, (this.gateLeft.y + this.gateRight.y) / 2.0);
    }

    protected void setPortal(MPoint mPoint, MPoint mPoint2) {
        if (mPoint == null) {
            throw new IllegalArgumentException("Argument 'p0' is null");
        }
        if (mPoint2 == null) {
            throw new IllegalArgumentException("Argument 'p1' is null");
        }
        if (Line2D.relativeCCW(mPoint.getX(), mPoint.getY(), mPoint2.getX(), mPoint2.getY(), ((MAbstractVertex)this.source).getCentroid().getX(), ((MAbstractVertex)this.source).getCentroid().getY()) > 0) {
            this.portalLeft = mPoint;
            this.portalRight = mPoint2;
        } else {
            this.portalLeft = mPoint2;
            this.portalRight = mPoint;
        }
    }
}

