/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.impl;

import com.anylogic.engine.internal.graph.impl.GAbstractEdge;
import com.anylogic.engine.internal.graph.impl.GAbstractGraph;
import com.anylogic.engine.internal.mesh.IMMesh;
import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.impl.MAbstractEdge;
import com.anylogic.engine.internal.mesh.impl.MAbstractVertex;
import com.anylogic.engine.internal.mesh.impl.MMeshGrid;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public abstract class MAbstractMesh<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
extends GAbstractGraph<G, V, E>
implements IMMesh<G, V, E> {
    private static final long serialVersionUID = 1L;
    private Set<MPoint> a = new LinkedHashSet<MPoint>();
    protected MMeshGrid<G, V, E> grid;

    public MAbstractMesh() {
        this.initializeGrid();
    }

    protected abstract void initializeGrid();

    @Override
    public Set<MPoint> getPoints() {
        return this.a;
    }

    @Override
    public void addPoint(MPoint mPoint) {
        if (this.a.contains(mPoint)) {
            throw new RuntimeException("'point' exists in mesh");
        }
        this.a.add(mPoint);
    }

    @Override
    public void addVertex(V v, List<MPoint> list) {
        super.addVertex(v);
        if (!this.a.containsAll(list)) {
            throw new RuntimeException("Cannot found 'contour' in mesh");
        }
        ((MAbstractVertex)v).setContour(list);
    }

    @Override
    public void addEdge(E e2, V v, V v2, MPoint mPoint, MPoint mPoint2, MPoint mPoint3, MPoint mPoint4) {
        super.addEdge(e2, v, v2);
        ((MAbstractEdge)e2).setGate(mPoint, mPoint2);
        ((MAbstractEdge)e2).setPortal(mPoint3, mPoint4);
        ((MAbstractVertex)v).updateCentroid();
        ((MAbstractVertex)v2).updateCentroid();
    }

    @Override
    public void addEdge(E e2, V v, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEdge(E e2) {
        MAbstractVertex mAbstractVertex = (MAbstractVertex)((GAbstractEdge)e2).getSource();
        MAbstractVertex mAbstractVertex2 = (MAbstractVertex)((GAbstractEdge)e2).getTarget();
        super.removeEdge(e2);
        mAbstractVertex.updateCentroid();
        mAbstractVertex2.updateCentroid();
    }

    @Override
    public V findVertex(MPoint mPoint) {
        return (V)this.findVertex(mPoint.getX(), mPoint.getY());
    }

    @Override
    public V findVertex(double d2, double d3) {
        Collection collection = this.getVertices();
        if (this.grid != null) {
            collection = this.grid.getVertices(d2, d3);
        }
        for (MAbstractVertex mAbstractVertex : collection) {
            if (!mAbstractVertex.contains(d2, d3)) continue;
            return (V)mAbstractVertex;
        }
        return null;
    }

    public void generateGrid(double d2, int n2) {
        if (this.grid == null) {
            return;
        }
        this.grid.generateGrid(d2, n2);
    }
}

