/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.mesh.impl;

import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.internal.graph.impl.GAbstractVertex;
import com.anylogic.engine.internal.mesh.IMVertex;
import com.anylogic.engine.internal.mesh.MPoint;
import com.anylogic.engine.internal.mesh.MUtilities;
import com.anylogic.engine.internal.mesh.impl.MAbstractEdge;
import com.anylogic.engine.internal.mesh.impl.MAbstractMesh;
import java.util.ArrayList;
import java.util.List;

public abstract class MAbstractVertex<G extends MAbstractMesh<G, V, E>, V extends MAbstractVertex<G, V, E>, E extends MAbstractEdge<G, V, E>>
extends GAbstractVertex<G, V, E>
implements IMVertex<G, V, E> {
    private static final long serialVersionUID = 1L;
    protected int treeId = 0;
    protected MPoint centroid;
    @AnyLogicCustomSerialization
    protected transient List<MPoint> contour = new ArrayList<MPoint>(0);

    @Override
    public MPoint getCentroid() {
        return this.centroid;
    }

    @Override
    public List<MPoint> getContour() {
        return this.contour;
    }

    protected void setContour(List<MPoint> list) {
        this.contour.addAll(list);
        this.centroid = MUtilities.getPolygonCentroid(list);
    }

    protected void updateCentroid() {
        if (this.getOutcomingEdges().size() == 2) {
            MAbstractEdge mAbstractEdge = (MAbstractEdge)this.getOutcomingEdges().get(0);
            MAbstractEdge mAbstractEdge2 = (MAbstractEdge)this.getOutcomingEdges().get(1);
            this.centroid.setX((mAbstractEdge2.getCentroid().x + mAbstractEdge.getCentroid().x) / 2.0);
            this.centroid.setY((mAbstractEdge2.getCentroid().y + mAbstractEdge.getCentroid().y) / 2.0);
        } else {
            MPoint mPoint = MUtilities.getPolygonCentroid(this.contour);
            this.centroid.setX(mPoint.x);
            this.centroid.setY(mPoint.y);
        }
    }

    @Override
    public int getTreeId() {
        return this.treeId;
    }

    public void setTreeId(int n2) {
        this.treeId = n2;
    }

    @Override
    public boolean contains(MPoint mPoint) {
        return this.contains(mPoint.getX(), mPoint.getY());
    }

    @Override
    public boolean contains(double d2, double d3) {
        return MUtilities.isInPolygon(this.contour, d2, d3);
    }
}

