/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.internal.triangulation.rc;

import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.triangulation.ITEdge;
import com.anylogic.engine.internal.triangulation.ITTriangle;
import com.anylogic.engine.internal.triangulation.ITTriangulation;
import com.anylogic.engine.internal.triangulation.ITVertex;

public class TDelaunayValidator<G extends ITTriangulation<G, V, E, T>, V extends ITVertex<G, V, E, T>, E extends ITEdge<G, V, E, T>, T extends ITTriangle<G, V, E, T>> {
    private G a;

    public TDelaunayValidator(G g2) {
        this.a = g2;
    }

    public void validate() {
        this.a();
        this.n();
    }

    private void a() {
        for (ITEdge iTEdge : this.a.getEdges()) {
            ITVertex iTVertex;
            ITVertex iTVertex2 = (ITVertex)iTEdge.getSource();
            if (iTVertex2 == (iTVertex = (ITVertex)iTEdge.getTarget())) {
                throw new RuntimeException("Triangulation: Illegal " + iTEdge.toString());
            }
            if (iTVertex2.findAllEdges(iTVertex).size() == 1) continue;
            throw new RuntimeException("Triangulation: Duplicate " + iTEdge.toString());
        }
    }

    private void n() {
        for (ITTriangle iTTriangle : this.a.getTriangles()) {
            ITVertex iTVertex;
            ITVertex iTVertex2;
            ITVertex iTVertex3 = (ITVertex)iTTriangle.getVertices().get(0);
            if (this.isPointOnTheLine(iTVertex3, iTVertex2 = (ITVertex)iTTriangle.getVertices().get(1), iTVertex = (ITVertex)iTTriangle.getVertices().get(2))) {
                throw new RuntimeException("Triangulation: Illegal " + iTTriangle.toString());
            }
            if (this.a.findTriangles((ITVertex)iTVertex3, (ITVertex)iTVertex2, (ITVertex)iTVertex).size() == 1) continue;
            throw new RuntimeException("Triangulation: Duplicate " + iTTriangle.toString());
        }
    }

    protected boolean isPointOnTheLine(V v, V v2, V v3) {
        return Utilities.isPointOnTheSameLine(v.getX(), v.getY(), v2.getX(), v2.getY(), v3.getX(), v3.getY());
    }
}

