/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.markup.GISMarkupSegment;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.Intersection;
import java.awt.geom.Path2D;

public class GISMarkupSegmentLine
extends GISMarkupSegment {
    private static final long serialVersionUID = 8730348091371353008L;
    private double i;
    double j = 1.0;
    private Geo d;
    private Geo l;
    private Geo g = new Geo();
    private Geo c;

    public GISMarkupSegmentLine() {
    }

    public GISMarkupSegmentLine(double d2, double d3, double d4, double d5) {
        super(d2, d3, d4, d5);
        this.initialize();
    }

    public GISMarkupSegmentLine(double d2, double d3, double d4, double d5, double d6) {
        super(d2, d3, d4, d5);
        this.a = d6;
        this.initialize();
    }

    @Override
    public void initialize() {
        double d2 = Utilities.getDistanceGIS(this.n, this.k, this.m, this.h);
        if (this.a == -1.0) {
            this.a = d2;
        } else {
            this.j = d2 / this.a;
        }
        this.i = ff.n(this.n, this.k, this.m, this.h);
        this.d = new Geo(this.n, this.k);
        this.l = new Geo(this.m, this.h);
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        Point point2 = ff.a(point, this.n, this.k, this.m, this.h, d2, d3);
        double d4 = Utilities.getDistanceGIS(point2.x, point2.y, d2, d3);
        return d4 * d4;
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        return this.getNearestPoint(point.x, point.y, point2);
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        return Utilities.getDistanceGIS(this.n, this.k, d2, d3) / this.j;
    }

    @Override
    public Point getStart(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.setLocation(this.n, this.k);
        return point;
    }

    @Override
    public Point getEnd(Point point) {
        if (point == null) {
            point = new Point();
        }
        point.setLocation(this.m, this.h);
        return point;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        Geo geo;
        Geo geo2;
        if (point == null) {
            point = new Point();
        }
        if (this.getDistanceSq(d2, d3) <= 1.0E-30) {
            point.setLocation(d2, d3);
            return 0.0;
        }
        Geo geo3 = Intersection.getIntersectionGeo((double)d2, (double)d3, (double)d4, (double)d5, (double)this.n, (double)this.k, (double)this.m, (double)this.h);
        Geo geo4 = this.d;
        if ((Double.isNaN(geo3.x()) || Double.isNaN(geo3.y()) || Double.isNaN(geo3.z())) && (Geo.distance((Geo)(geo2 = new Geo(d2, d3)), (Geo)(geo = Intersection.getIntersectionGeo((double)d2, (double)d3, (double)d4, (double)d5, (double)this.n, (double)this.k, (double)this.m, (double)this.h))) <= 1.0E-15 || Geo.distance((Geo)geo2, (Geo)geo.antipode()) <= 1.0E-15)) {
            if (ff.a(geo4, this.l, geo2)) {
                point.setLocation(d2, d3);
                return 0.0;
            }
            double d6 = ff.a(d2, d3, this.n, this.k);
            double d7 = ff.a(d2, d3, this.m, this.h);
            if (Geo.angle((Geo)new Geo(d4, d5), (Geo)geo2, (Geo)geo4) != 0.0) {
                d6 = Math.PI * 2 - d6;
                d7 = Math.PI * 2 - d7;
            }
            if (d6 < d7) {
                point.setLocation(this.n, this.k);
                return ff.k(d6);
            }
            point.setLocation(this.m, this.h);
            return ff.k(d7);
        }
        if (!ff.a(geo4, this.l, geo3)) {
            return -1.0;
        }
        point.setLocation(geo3.getLatitude(), geo3.getLongitude());
        return Utilities.getDistanceGIS(d2, d3, geo3.getLatitude(), geo3.getLongitude());
    }

    @Override
    public void addTo(Path2D path2D) {
        path2D.lineTo(this.m, this.h);
    }

    @Override
    public void setStart(Point point) {
        this.setStart(point.x, point.y);
    }

    public double getDistanceSq(double d2, double d3) {
        return this.getNearestPoint(d2, d3, null);
    }

    @Override
    public double getDistanceSq(Point point) {
        return this.getNearestPoint(point.x, point.y, null);
    }

    @Override
    void a(double d2, Position position) {
        this.a(d2, (Point)position);
        position.verticalRotation = Double.NaN;
        if (this.a == 0.0) {
            position.rotation = Double.NaN;
            return;
        }
        if (position.getLatitude() == this.m && position.getLongitude() == this.h) {
            double d3;
            position.rotation = d3 + ((d3 = ff.a(ff.n(this.m, this.h, this.n, this.k))) > 0.0 ? Math.PI : -Math.PI);
            return;
        }
        position.setRotation(ff.a(ff.n(position.getLatitude(), position.getLongitude(), this.m, this.h)));
    }

    @Override
    void a(double d2, Point point) {
        this.g = this.d.offset(ff.n(d2) * this.j, this.i, this.g);
        if (ff.a(this.d, this.l, this.g)) {
            point.setLocation(this.g.getLatitude(), this.g.getLongitude());
            return;
        }
        this.c = ff.n(this.d, this.l, this.g);
        if (ff.a(this.d, this.l, this.c)) {
            point.setLocation(this.c.getLatitude(), this.c.getLongitude());
        } else {
            point.setLocation(this.m, this.h);
        }
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.n, this.k, 0.0, ff.a(this.i), 0.0);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.m, this.h, 0.0, ff.a(this.i), 0.0);
        return position;
    }
}

