/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AreaUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.SharedUtils;
import com.anylogic.engine.markup.GISNode;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.ShapeGISMap;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.geo.GeoArray;
import com.bbn.openmap.geo.Intersection;
import com.bbn.openmap.geo.OMGeo;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class GISRegion
extends GISNode {
    private static final long serialVersionUID = -6480633512264496299L;
    private transient GeoArray b;
    private final double f;
    private double e = 90.0;
    private double ac = 180.0;
    private double mk = -90.0;
    private double nd = -180.0;
    private Position[] mf = null;
    private static final int hl = 1000;

    public GISRegion(ShapeGISMap shapeGISMap, double[] dArray) {
        super(shapeGISMap, true);
        this.b = GeoArray.Double.createFromLatLonDegrees((double[])dArray);
        this.f = SharedUtils.getGISRegionArea(dArray);
        this.initialize();
    }

    public GISRegion(ShapeGISMap shapeGISMap, boolean bl2, double[] dArray, double[] dArray2, Paint paint, Paint paint2, double d2, LineStyle lineStyle, String string, double d3) {
        super(shapeGISMap, bl2, paint, paint2, d2, lineStyle, string);
        this.f = d3;
        if (dArray2 == null || dArray == null || dArray2.length == 0 || dArray2.length != dArray.length) {
            throw ff.a(shapeGISMap.getPresentable(), hg.dhh, new Object[]{"lat/lon", hg.fdi});
        }
        Geo[] geoArray = new Geo[dArray2.length];
        int n2 = 0;
        while (n2 < geoArray.length) {
            geoArray[n2] = new Geo(dArray[n2], dArray2[n2]);
            ++n2;
        }
        this.b = new GeoArray.Double(geoArray);
        this.initialize();
    }

    public GISRegion(ShapeGISMap shapeGISMap, boolean bl2, double[] dArray, Paint paint, Paint paint2, double d2, LineStyle lineStyle, String string, double d3) {
        super(shapeGISMap, bl2, paint, paint2, d2, lineStyle, string);
        this.f = d3;
        if (dArray == null || dArray.length == 0) {
            throw ff.a(shapeGISMap.getPresentable(), hg.dhh, new Object[]{"lat/lon", hg.fdi});
        }
        this.b = GeoArray.Double.createFromLatLonDegrees((double[])dArray);
        this.initialize();
    }

    @Override
    public void doInitialize() {
        super.doInitialize();
        int n2 = this.b.getSize();
        if (n2 < 3) {
            throw this.error("Error: node polygon should have at least 3 vertices");
        }
        Geo geo = new Geo();
        int n3 = 0;
        while (n3 < this.b.getSize()) {
            geo = this.b.get(n3, geo);
            this.e = Math.min(this.e, geo.getLatitude());
            this.mk = Math.max(this.mk, geo.getLatitude());
            this.ac = Math.min(this.ac, geo.getLongitude());
            this.nd = Math.max(this.nd, geo.getLongitude());
            ++n3;
        }
    }

    @Override
    public boolean contains(double d2, double d3) {
        return Intersection.isPointInPolygon((Geo)new Geo(d2, d3), (GeoArray)this.b);
    }

    public double getNearestPoint(double d2, double d3, Point point) {
        this.h();
        if (point == null) {
            point = new Point();
        }
        if (this.contains(d2, d3)) {
            point.setLocation(d2, d3);
            return 0.0;
        }
        int n2 = this.b.getSize();
        if (n2 < 2) {
            return -1.0;
        }
        double d4 = Double.POSITIVE_INFINITY;
        int n3 = 0;
        while (n3 < n2) {
            Geo geo = this.b.get(n3);
            Geo geo2 = this.b.get(n3 + 1 == n2 ? 0 : n3 + 1);
            Point point2 = ff.a(point, geo.getLatitude(), geo.getLongitude(), geo2.getLatitude(), geo2.getLongitude(), d2, d3);
            double d5 = ff.a(d2, d3, point2.x, point2.y);
            if (d4 > d5) {
                point.setLocation(point2);
                d4 = d5;
            }
            ++n3;
        }
        return ff.k(d4 * d4);
    }

    @Override
    public double getNearestPoint(Point point, Point point2) {
        double d2 = this.getNearestPoint(point.x, point.y, point2);
        return d2 * d2;
    }

    @Override
    @AnyLogicInternalAPI
    public OMGraphic createOMGraphicObject() {
        OMGeo.Polygon polygon = new OMGeo.Polygon(this.b);
        polygon.setFillPaint(this.c);
        this.a((OMGraphic)polygon);
        return polygon;
    }

    private Position[] a(int n2) {
        Position[] positionArray;
        if (n2 <= 0 || n2 > 1000) {
            n2 = 1000;
        }
        if ((positionArray = this.mf) == null || positionArray.length < n2) {
            positionArray = new Position[n2];
            int n3 = 0;
            while (n3 < positionArray.length) {
                Position position = new Position();
                this.randomPointInside(position);
                position.rotation = this.getSpace().uniform(Math.PI * 2);
                position.verticalRotation = Double.NaN;
                positionArray[n3] = position;
                ++n3;
            }
            this.mf = positionArray;
        }
        return positionArray;
    }

    Position a(int n2, int n3, Position position) {
        if (n2 >= n3) {
            n2 %= n3;
        }
        Position[] positionArray = this.a(n3);
        return positionArray[n2 % positionArray.length].clone(position);
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        return this.a(n2, n3, position);
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.SQ_METER)
    public double area() {
        return this.f;
    }

    public double area(AreaUnits areaUnits) {
        return AreaUnits.SQ_METER.convertTo(this.f, areaUnits);
    }

    @Override
    public Point randomPointInside(Random random, Point point) {
        this.h();
        Geo geo = new Geo();
        do {
            geo.initialize(Utilities.uniform(this.e, this.mk, random), Utilities.uniform(this.ac, this.nd, random));
        } while (!Intersection.isPointInPolygon((Geo)geo, (GeoArray)this.b));
        if (point == null) {
            point = new Point();
        }
        return point.setLatLon(geo.getLatitude(), geo.getLongitude());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        double[] dArray = this.b.toLLDegrees();
        objectOutputStream.writeObject(dArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.b = GeoArray.Double.createFromLatLonDegrees((double[])((double[])objectInputStream.readObject()));
    }

    public double[] getPoints() {
        return this.b.toLLDegrees();
    }
}

