/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.AnyLogicInternalLibraryAPI;
import com.anylogic.engine.Pair;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.y.d;
import com.anylogic.engine.internal.y.db;
import com.anylogic.engine.internal.y.eb;
import com.anylogic.engine.internal.y.fd;
import com.anylogic.engine.internal.y.l;
import com.anylogic.engine.markup.AbstractRoadConnectableElement;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadBasicDataSource;
import com.anylogic.engine.markup.RoadConnectionPoint;
import com.anylogic.engine.markup.RoadDrivingDirection;
import com.anylogic.engine.markup.RoadEnd;
import com.anylogic.engine.markup.RoadLanesConnector;
import com.anylogic.engine.markup.j;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Intersection
extends AbstractRoadConnectableElement {
    private static final long serialVersionUID = -6412114235027299404L;
    private final List<RoadConnectionPoint> d = new ArrayList<RoadConnectionPoint>();
    private final List<RoadConnectionPoint> l = new ArrayList<RoadConnectionPoint>();
    private final List<RoadConnectionPoint> g = new ArrayList<RoadConnectionPoint>();
    private final Map<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>> c = new LinkedHashMap<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>>();
    private final List<List<MarkupSegment>> b = new ArrayList<List<MarkupSegment>>();
    private final Map<List<MarkupSegment>, RoadLanesConnector> f = new LinkedHashMap<List<MarkupSegment>, RoadLanesConnector>();
    private List<RoadLanesConnector> e = new ArrayList<RoadLanesConnector>();
    private final List<MarkupSegment> ac = new ArrayList<MarkupSegment>();
    @AnyLogicCustomSerialization
    private transient RoadBasicDataSource mk;
    private boolean bf = false;
    protected transient List<RoadEnd> i = new ArrayList<RoadEnd>();
    private transient Path2D bl;
    private transient Map<List<MarkupSegment>, Path2D> ca;

    public Intersection() {
    }

    public Intersection(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, boolean bl3, RoadEnd[] roadEndArray, RoadLanesConnector ... roadLanesConnectorArray) {
        super(agent, shapeDrawMode, bl2);
        this.bf = bl3;
        Collections.addAll(this.i, roadEndArray);
        Collections.addAll(this.e, roadLanesConnectorArray);
        this.initialize();
    }

    public void showLaneConnectors(boolean bl2) {
        this.bf = bl2;
    }

    public Intersection(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, boolean bl3, Road road, RoadEnd.Type type, Road road2, RoadEnd.Type type2, RoadLanesConnector ... roadLanesConnectorArray) {
        this(agent, shapeDrawMode, bl2, bl3, new RoadEnd[]{new RoadEnd(road, type), new RoadEnd(road2, type2)}, roadLanesConnectorArray);
    }

    public void setRoads(Road road, RoadEnd.Type type, Road road2, RoadEnd.Type type2) {
        this.addRoad(road, type);
        this.addRoad(road2, type2);
    }

    @AnyLogicInternalLibraryAPI
    public void setDataSource(RoadBasicDataSource roadBasicDataSource) {
        if (roadBasicDataSource == null) {
            this.a(hg.ihf, "dataSource");
        }
        if (roadBasicDataSource == this.mk) {
            return;
        }
        if (this.mk != null) {
            this.a(hg.mjl, roadBasicDataSource);
        }
        this.mk = roadBasicDataSource;
    }

    public int nCars() {
        return this.mk == null ? 0 : this.mk.nCars();
    }

    public List<Agent> getCars() {
        return this.mk == null ? Collections.emptyList() : this.mk.getCars();
    }

    protected void a(RoadConnectionPoint[][] roadConnectionPointArray) {
        RoadConnectionPoint[][] roadConnectionPointArray2 = roadConnectionPointArray;
        int n2 = roadConnectionPointArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RoadConnectionPoint[] roadConnectionPointArray3;
            RoadConnectionPoint[] roadConnectionPointArray4 = roadConnectionPointArray3 = roadConnectionPointArray2[n3];
            int n4 = roadConnectionPointArray3.length;
            int n5 = 0;
            while (n5 < n4) {
                RoadConnectionPoint roadConnectionPoint = roadConnectionPointArray4[n5];
                RoadConnectionPoint roadConnectionPoint2 = roadConnectionPoint.createConnectedPoint(this);
                if (roadConnectionPoint2.isIncoming()) {
                    this.d.add(roadConnectionPoint2);
                } else {
                    this.l.add(roadConnectionPoint2);
                }
                this.g.add(roadConnectionPoint2);
                ++n5;
            }
            ++n3;
        }
    }

    protected void k() {
    }

    protected void b() {
    }

    protected void e() {
        boolean bl2 = false;
        boolean bl3 = false;
        for (RoadConnectionPoint roadConnectionPoint : this.g) {
            if (roadConnectionPoint.isIncoming()) {
                bl2 = true;
            } else {
                bl3 = true;
            }
            if (!bl2 || !bl3) continue;
            return;
        }
        this.error("The road element should have at least one incoming and at least one outgoing road connection point.");
    }

    @AnyLogicInternalLibraryAPI
    public static List<MarkupSegment> generateDefaultGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2) {
        MarkupSegment markupSegment = com.anylogic.engine.markup.j.a(roadConnectionPoint.getDirectionSegment(), roadConnectionPoint2.getDirectionSegment());
        return Collections.singletonList(markupSegment);
    }

    @AnyLogicInternalLibraryAPI
    public void setGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2, List<MarkupSegment> list) {
        if (roadConnectionPoint.getOwner() != this) {
            this.error("Incoming connection point should belong to markup element.");
        }
        if (roadConnectionPoint2.getOwner() != this) {
            this.error("Outgoing connection point should belong to markup element.");
        }
        if (!roadConnectionPoint.isIncoming()) {
            this.error("Incoming connection point is not incoming.");
        }
        if (roadConnectionPoint2.isIncoming()) {
            this.error("Outgoing connection point is not outgoing.");
        }
        if (list == null || list.isEmpty()) {
            throw this.error("Guideline should contain at least one segment.");
        }
        Point point = roadConnectionPoint.getDirectionSegment().getStart(new Point());
        Point point2 = list.get(0).getStart(new Point());
        if (point2.distance2D(point) > 0.001) {
            this.a("Guideline should start at incoming connection point: %s, %s", point2, point);
        }
        Point point3 = roadConnectionPoint2.getDirectionSegment().getStart(new Point());
        point2 = list.get(list.size() - 1).getEnd(new Point());
        if (point2.distance2D(point3) > 0.001) {
            this.a("Guideline should end at outgoing connection point: %s, %s", point2, point3);
        }
        Pair<RoadConnectionPoint, RoadConnectionPoint> pair = new Pair<RoadConnectionPoint, RoadConnectionPoint>(roadConnectionPoint, roadConnectionPoint2);
        this.c.put(pair, list);
        this.b.add(list);
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getIncomingConnectionPoints() {
        return this.d;
    }

    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getOutgoingConnectionPoints() {
        return this.l;
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getConnectionPoint(RoadConnectionPoint roadConnectionPoint) {
        RoadConnectionPoint roadConnectionPoint2 = null;
        for (RoadConnectionPoint roadConnectionPoint3 : this.g) {
            if (roadConnectionPoint3.getConnectedPoint() != roadConnectionPoint) continue;
            roadConnectionPoint2 = roadConnectionPoint3;
            break;
        }
        return roadConnectionPoint2;
    }

    @AnyLogicInternalLibraryAPI
    public RoadConnectionPoint getConnectionPoint(boolean bl2, Road road, int n2) {
        RoadConnectionPoint roadConnectionPoint = null;
        for (RoadConnectionPoint roadConnectionPoint2 : this.g) {
            if (roadConnectionPoint2.isIncoming() != bl2 || roadConnectionPoint2.getConnectedPoint().getOwner() != road || road.getLaneIndex(roadConnectionPoint2.getConnectedPoint()) != n2) continue;
            roadConnectionPoint = roadConnectionPoint2;
            break;
        }
        return roadConnectionPoint;
    }

    @AnyLogicInternalLibraryAPI
    public void setGuideline(RoadConnectionPoint roadConnectionPoint, RoadConnectionPoint roadConnectionPoint2) {
        List<MarkupSegment> list = Intersection.generateDefaultGuideline(roadConnectionPoint, roadConnectionPoint2);
        this.setGuideline(roadConnectionPoint, roadConnectionPoint2, list);
    }

    @AnyLogicInternalLibraryAPI
    public Map<Pair<RoadConnectionPoint, RoadConnectionPoint>, List<MarkupSegment>> getGuidelines() {
        return this.c;
    }

    @Override
    @AnyLogicInternalLibraryAPI
    public List<RoadConnectionPoint> getConnectionPoints() {
        return this.g;
    }

    @Override
    void g_() {
        super.g_();
        if (this.i.isEmpty()) {
            this.error("This markup should connect at least one road");
        }
    }

    @Override
    protected void i() {
        Serializable serializable;
        Serializable serializable2;
        super.i();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (RoadEnd object2 : this.i) {
            serializable2 = object2.getRoad();
            serializable = new ArrayList<Object>();
            for (RoadConnectionPoint roadConnectionPoint : serializable2.getOutgoingConnectionPoints(object2.getType())) {
                RoadConnectionPoint roadConnectionPoint2 = roadConnectionPoint.createConnectedPoint(this);
                this.d.add(roadConnectionPoint2);
                serializable.add(roadConnectionPoint2);
            }
            ArrayList<RoadConnectionPoint> arrayList = new ArrayList<RoadConnectionPoint>();
            for (RoadConnectionPoint roadConnectionPoint : serializable2.getIncomingConnectionPoints(object2.getType())) {
                RoadConnectionPoint roadConnectionPoint3 = roadConnectionPoint.createConnectedPoint(this);
                this.l.add(roadConnectionPoint3);
                arrayList.add(roadConnectionPoint3);
            }
            hashMap.put((Road)serializable2, serializable);
            hashMap2.put((Road)serializable2, arrayList);
        }
        this.g.addAll(this.d);
        this.g.addAll(this.l);
        for (RoadLanesConnector roadLanesConnector : this.e) {
            try {
                serializable2 = (RoadConnectionPoint)((List)hashMap.get(roadLanesConnector.a)).get(roadLanesConnector.n);
                serializable = (RoadConnectionPoint)((List)hashMap2.get(roadLanesConnector.k)).get(roadLanesConnector.m);
            }
            catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
                throw this.a("Roads/lanes not found: %s", roadLanesConnector);
            }
            List<MarkupSegment> list = roadLanesConnector.h != null ? roadLanesConnector.h : Intersection.generateDefaultGuideline((RoadConnectionPoint)serializable2, serializable);
            this.setGuideline((RoadConnectionPoint)serializable2, (RoadConnectionPoint)serializable, list);
            this.f.put(list, roadLanesConnector);
        }
        this.e();
        this.b();
        this.k();
        this.a(this.ac, this.i);
        this.e = Collections.unmodifiableList(this.e);
        this.i = null;
    }

    public void addRoad(Road road, RoadEnd.Type type) {
        this.j();
        this.i.add(new RoadEnd(road, type));
    }

    public void addConnection(Road road, int n2, Road road2, int n3) {
        this.j();
        this.e.add(new RoadLanesConnector(road, n2, road2, n3));
    }

    public void addConnection(Road road, int n2, Road road2, int n3, MarkupSegment ... markupSegmentArray) {
        this.j();
        this.e.add(new RoadLanesConnector(road, n2, road2, n3, markupSegmentArray));
    }

    public void addConnection(Road road, int n2, Road road2, int n3, List<MarkupSegment> list) {
        this.j();
        this.e.add(new RoadLanesConnector(road, n2, road2, n3, list));
    }

    public List<RoadLanesConnector> getLanesConnectors() {
        return this.e;
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        if (!this.a(bl2)) {
            return;
        }
        if (this.bl == null) {
            this.bl = com.anylogic.engine.internal.presentation.e.a(this.ac);
        }
        Paint paint = com.anylogic.engine.markup.j.k(this.n);
        com.anylogic.engine.internal.presentation.e.a(graphics2D, paint);
        com.anylogic.engine.internal.presentation.e.a(graphics2D, 1.0f, LineStyle.LINE_STYLE_SOLID, false);
        graphics2D.fill(this.bl);
        if (this.bf) {
            if (this.ca == null) {
                this.ca = new HashMap<List<MarkupSegment>, Path2D>();
                for (List<MarkupSegment> list : this.b) {
                    this.ca.put(list, com.anylogic.engine.internal.presentation.e.a(list));
                }
            }
            double d2 = panel.getZoom();
            float f2 = 1.0f;
            if (d2 > 1.0) {
                f2 = (float)(d2 > 3.0 ? 2.0 / d2 : 1.0 / d2);
            }
            com.anylogic.engine.internal.presentation.e.a(graphics2D, f2, LineStyle.LINE_STYLE_SOLID, false);
            for (List<MarkupSegment> list : this.ca.keySet()) {
                RoadLanesConnector roadLanesConnector;
                Color color = Color.white;
                if (this.n.isSignalStateAnimationVisible() && (roadLanesConnector = this.f.get(list)) != null && roadLanesConnector.getSignal() != null) {
                    color = roadLanesConnector.getSignal().getColor();
                }
                graphics2D.setColor(color);
                graphics2D.draw(this.ca.get(list));
                for (MarkupSegment markupSegment : list) {
                    com.anylogic.engine.internal.presentation.e.a(graphics2D, markupSegment, (double)f2, (double)(4.0f * f2), true);
                }
            }
        }
    }

    private List<MarkupSegment> a(List<MarkupSegment> list, List<RoadEnd> list2) {
        Cloneable cloneable;
        int n2 = list2.size();
        final Point point = new Point();
        int n3 = 0;
        while (n3 < n2) {
            cloneable = Intersection.n(list2.get(n3));
            point.x += ((Position)cloneable).x;
            point.y += ((Position)cloneable).y;
            ++n3;
        }
        point.x *= 1.0 / (double)n2;
        point.y *= 1.0 / (double)n2;
        Comparator<RoadEnd> comparator = new Comparator<RoadEnd>(){

            public int a(RoadEnd roadEnd, RoadEnd roadEnd2) {
                Position position = Intersection.n(roadEnd);
                Position position2 = Intersection.n(roadEnd2);
                position.sub(point);
                position2.sub(point);
                double d2 = this.a(position2);
                double d3 = this.a(position);
                return (int)Math.signum(d2 - d3);
            }

            private double a(Position position) {
                double d2 = Math.atan2(position.y, position.x);
                if (com.anylogic.engine.markup.j.a(d2)) {
                    d2 = 0.0;
                } else if (d2 < 0.0) {
                    d2 += Math.PI * 2;
                }
                return d2;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((RoadEnd)object, (RoadEnd)object2);
            }
        };
        cloneable = new ArrayList<RoadEnd>(list2);
        Collections.sort(cloneable, comparator);
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        Point point5 = new Point();
        Point point6 = new Point();
        Point point7 = new Point();
        Point point8 = new Point();
        int n4 = 0;
        while (n4 < n2) {
            RoadEnd roadEnd = (RoadEnd)cloneable.get(n4);
            RoadEnd roadEnd2 = (RoadEnd)cloneable.get((n4 + 1) % n2);
            this.a(roadEnd, point3, point8, false);
            this.a(roadEnd, point2, point6, true);
            this.a(roadEnd2, point5, point7, false);
            this.a(roadEnd2, point4, point8, true);
            Road road = roadEnd.getRoad();
            if (road.getForwardLanesCount() != 0 && road.getBackwardLanesCount() != 0 && road.getMedianStripColor() == null && road.getMedianStripTexture() == null && com.anylogic.engine.markup.j.a(road) != 0.0) {
                Point point9 = new Point();
                Point point10 = new Point();
                Point point11 = new Point();
                Point point12 = new Point();
                this.a(roadEnd, point9, point10, 0, false);
                this.a(roadEnd, point11, point12, 0, true);
                com.anylogic.engine.markup.j.a(list, com.anylogic.engine.markup.j.m(point3, point9));
                com.anylogic.engine.markup.j.a(list, point9, point10, point11, point12);
                com.anylogic.engine.markup.j.a(list, com.anylogic.engine.markup.j.m(point11, point2));
            } else {
                com.anylogic.engine.markup.j.a(list, com.anylogic.engine.markup.j.m(point3, point2));
            }
            com.anylogic.engine.markup.j.a(list, point2, point6, point5, point7);
            ++n4;
        }
        return list;
    }

    private void a(RoadEnd roadEnd, Point point, Point point2, int n2, boolean bl2) {
        double d2 = this.n.getLaneWidth();
        double d3 = com.anylogic.engine.markup.j.a(roadEnd.getRoad()) / 2.0;
        Position position = Intersection.n(roadEnd);
        Intersection.a(point, position, d2 * (double)n2 + d3, bl2);
        Intersection.a(point2, position, point);
    }

    private static Position n(RoadEnd roadEnd) {
        Position position;
        Road road = roadEnd.getRoad();
        if (roadEnd.getType() == RoadEnd.Type.BEGIN) {
            position = road.getSegment(0).getStart(null);
            position.rotation += Math.PI;
        } else {
            position = road.getSegment(road.getSegmentCount() - 1).getEnd(null);
        }
        return position;
    }

    private void a(RoadEnd roadEnd, Point point, Point point2, boolean bl2) {
        int n2;
        int n3;
        boolean bl3;
        Road road = roadEnd.getRoad();
        boolean bl4 = road.getRoadNetwork().getDrivingDirection() == RoadDrivingDirection.ROAD_LEFT_HAND;
        boolean bl5 = bl3 = roadEnd.getType() == RoadEnd.Type.BEGIN;
        if (bl3 ^ bl4) {
            n3 = road.getBackwardLanesCount();
            n2 = road.getForwardLanesCount();
        } else {
            n3 = road.getForwardLanesCount();
            n2 = road.getBackwardLanesCount();
        }
        int n4 = bl2 ? n3 : n2;
        this.a(roadEnd, point, point2, n4, bl2);
    }

    private static Point a(Point point, Position position, double d2, boolean bl2) {
        double d3 = bl2 ? 1 : -1;
        double d4 = position.rotation + d3 * Math.PI / 2.0;
        double d5 = Math.cos(d4);
        double d6 = Math.sin(d4);
        point.x = position.x + d2 * d5;
        point.y = position.y + d2 * d6;
        point.z = position.z;
        return point;
    }

    private static Point a(Point point, Position position, Point point2) {
        double d2 = position.rotation;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = 10.0;
        point.x = point2.x + d5 * d3;
        point.y = point2.y + d5 * d4;
        point.z = point2.z;
        return point;
    }

    @Override
    @AnyLogicInternalAPI
    public void update3D(Panel panel, boolean bl2) {
        if (!this.getDrawMode().has3D()) {
            return;
        }
        this.a(panel, bl2);
    }

    @Override
    int f_() {
        return super.f_() + 2;
    }

    @Override
    l[] g() {
        l[] lArray = super.g();
        int n2 = super.f_();
        lArray[n2] = this.ac();
        lArray[n2 + 1] = this.mk();
        return lArray;
    }

    l ac() {
        Paint paint = com.anylogic.engine.markup.j.k(this.n);
        return new d(this, d.a.a, paint);
    }

    private l mk() {
        double d2 = 0.0;
        Paint paint = com.anylogic.engine.markup.j.k(this.n);
        Paint paint2 = com.anylogic.engine.markup.j.n(this.n);
        return new eb(this, d2, this.ac, Collections.emptyList(), 1.0f, paint, paint2);
    }

    @Override
    fd f() {
        double d2 = 0.0;
        return new fd(this, 0.0, 0.0, d2, 1.0, 1.0, 1.0, 0.0);
    }

    @Override
    void a(db db2) {
        super.a(db2);
        if (this.n(ha)) {
            db2.a(this.mk());
        }
    }
}

