/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.g;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public final class MarkupSegmentArc
extends MarkupSegment {
    private static final long serialVersionUID = -8548181700911090455L;
    private double f;
    private double e;
    private double ac;
    private double mk;
    private double nd;
    private double mf;
    private double hl;
    private double gf;
    private double ma;
    private double gd;
    private double nm;
    private double ib;
    private double ml;
    private double dd;
    private double jj;
    private double jb;
    private double hn;
    private double ng;
    private double bn;
    protected double l;
    protected double g;
    protected double c;
    protected double b;
    private double ih;
    private double na;
    private double ha;
    private double en;
    private double fj;
    private double me;

    public MarkupSegmentArc() {
    }

    public MarkupSegmentArc(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        super(d2, d3, d4, d5, d6, d7);
        this.f = d8;
        this.e = d9;
        this.ac = d10;
        this.initialize();
    }

    public MarkupSegmentArc(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20) {
        super(d2, d3, d4, d5, d6, d7);
        this.f = d8;
        this.e = d9;
        this.ac = d10;
        this.mk = d11;
        this.nd = d12;
        this.mf = d13;
        this.hl = d14;
        this.gf = Math.abs(d15 %= Math.PI * 2);
        this.ma = Math.signum(d15);
        this.ib = d16;
        this.ml = d17;
        this.dd = d18;
        this.jj = d19;
        this.jb = Math.abs(d20 %= Math.PI * 2);
        this.hn = Math.signum(d20);
        this.k();
    }

    @Override
    public void initialize() {
        g.a[] aArray = com.anylogic.engine.markup.g.a(new Point(this.n, this.k), new Point(this.n + Math.cos(this.f - 1.5707963267948966) * this.ac, this.k + Math.sin(this.f - 1.5707963267948966) * this.ac), new Point(this.h, this.j), new Point(this.h + Math.cos(this.e - 1.5707963267948966), this.j + Math.sin(this.e - 1.5707963267948966)));
        if (aArray == null || aArray.length < 2) {
            throw ff.m("Error when building arcs. Please consider using line segment instead or change angles");
        }
        if (aArray[0].a()) {
            throw ff.m("NaN arc0: " + aArray[0]);
        }
        if (aArray[1].a()) {
            throw ff.m("NaN arc1: " + aArray[1]);
        }
        this.mk = aArray[0].a;
        this.nd = aArray[0].n;
        this.mf = aArray[0].k;
        this.hl = Math.toRadians(-aArray[0].m);
        this.gf = Math.abs(Math.toRadians(-aArray[0].h));
        this.ma = Math.signum(-aArray[0].h);
        this.ib = aArray[1].a;
        this.ml = aArray[1].n;
        this.dd = aArray[1].k;
        this.jj = Math.toRadians(-aArray[1].m);
        this.jb = Math.abs(Math.toRadians(-aArray[1].h));
        this.hn = Math.signum(-aArray[1].h);
        this.k();
    }

    private void k() {
        this.b = this.mf * this.gf;
        double d2 = this.dd * this.jb;
        this.d = this.b + d2;
        if (!(this.d > 0.0)) {
            System.out.println(String.valueOf(this.gf) + ", " + this.jb);
            throw ff.m("Segment should have non-zero length in 2D (XY-plane)");
        }
        double d3 = this.hl + this.gf / 2.0 * this.ma;
        this.gd = this.mk + Math.cos(d3) * this.mf;
        this.nm = this.nd + Math.sin(d3) * this.mf;
        d3 = this.jj + this.jb / 2.0 * this.hn;
        this.ng = this.ib + Math.cos(d3) * this.dd;
        this.bn = this.ml + Math.sin(d3) * this.dd;
        d3 = this.jj;
        this.l = this.ib + Math.cos(d3) * this.dd;
        this.g = this.ml + Math.sin(d3) * this.dd;
        double d4 = this.i - this.m;
        this.a = Utilities.getLength(this.d, d4);
        double d5 = d4 / this.d;
        this.en = d5 * this.mf;
        this.fj = d5 * this.dd;
        this.c = this.m + d5 * this.b;
        this.ih = this.d / this.a;
        double d6 = d4 / this.a;
        this.me = -Math.asin(d6);
        this.na = this.b != 0.0 ? (this.c - this.m) / this.b : 0.0;
        this.ha = d2 != 0.0 ? (this.i - this.c) / d2 : 0.0;
    }

    public void setAngles(double d2, double d3, double d4) {
        this.n();
        this.f = d2;
        this.e = d3;
        this.ac = d4;
    }

    public double getStartAngle() {
        return this.f;
    }

    public double getEndAngle() {
        return this.e;
    }

    public double getRatioStartToEnd() {
        return this.ac;
    }

    @Override
    void a(double d2, Point point) {
        this.a();
        d2 *= this.ih;
        if (d2 <= this.b) {
            double d3 = this.hl + d2 / this.mf * this.ma;
            point.x = this.mk + Math.cos(d3) * this.mf;
            point.y = this.nd + Math.sin(d3) * this.mf;
            point.z = this.m + d2 * this.na;
        } else {
            double d4 = this.jj + (d2 - this.b) / this.dd * this.hn;
            point.x = this.ib + Math.cos(d4) * this.dd;
            point.y = this.ml + Math.sin(d4) * this.dd;
            point.z = this.c + (d2 - this.b) * this.ha;
        }
    }

    @Override
    void a(double d2, Position position) {
        this.a();
        position.verticalRotation = this.me;
        if ((d2 *= this.ih) <= this.b || this.dd == 0.0 && d2 <= this.b + 1.0E-4) {
            double d3 = this.hl + d2 / this.mf * this.ma;
            position.x = this.mk + Math.cos(d3) * this.mf;
            position.y = this.nd + Math.sin(d3) * this.mf;
            position.z = this.m + d2 * this.na;
            position.rotation = d3 + 1.5707963267948966 * this.ma;
        } else {
            double d4 = this.jj + (d2 - this.b) / this.dd * this.hn;
            position.x = this.ib + Math.cos(d4) * this.dd;
            position.y = this.ml + Math.sin(d4) * this.dd;
            position.z = this.c + (d2 - this.b) * this.ha;
            position.rotation = d4 + 1.5707963267948966 * this.hn;
        }
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.n, this.k, this.m, this.hl + 1.5707963267948966 * this.ma, this.me);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.h, this.j, this.i, this.jj + (this.jb + 1.5707963267948966) * this.hn, this.me);
        return position;
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.a();
        double d4 = MarkupSegmentArc.a(this.mk, this.nd, this.n, this.k, this.l, this.g, this.gd, this.nm, this.mf, this.gf, this.ma, d2, d3, point);
        Point point2 = new Point();
        double d5 = MarkupSegmentArc.a(this.ib, this.ml, this.l, this.g, this.h, this.j, this.ng, this.bn, this.dd, this.jb, this.hn, d2, d3, point2);
        if (d5 < d4) {
            d4 = d5;
            point.setLocation(point2);
        }
        return d4;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        this.a();
        double d5 = MarkupSegmentArc.a(this.mk, this.nd, this.n, this.k, this.l, this.g, this.gd, this.nm, this.mf, this.gf, this.ma, d2, d3, point);
        Point point2 = new Point();
        double d6 = MarkupSegmentArc.a(this.ib, this.ml, this.l, this.g, this.h, this.j, this.ng, this.bn, this.dd, this.jb, this.hn, d2, d3, point2);
        if (d6 < d5) {
            d5 = d6;
            point.setLocation(point2);
            if (this.m == this.i) {
                point.z = this.m;
            } else if (point.x == this.h && point.y == this.j) {
                point.z = this.i;
            } else if (point.x == this.l && point.y == this.g) {
                point.z = this.c;
            } else {
                double d7 = Math.atan2(point.y - this.ml, point.x - this.ib);
                if (d7 < 0.0) {
                    d7 += Math.PI * 2;
                }
                point.z = this.c + this.fj * d7;
            }
        } else if (this.m == this.i) {
            point.z = this.m;
        } else if (point.x == this.n && point.y == this.k) {
            point.z = this.m;
        } else if (point.x == this.l && point.y == this.g) {
            point.z = this.c;
        } else {
            double d8 = Math.atan2(point.y - this.nd, point.x - this.mk);
            if (d8 < 0.0) {
                d8 += Math.PI * 2;
            }
            point.z = this.m + this.en * d8;
        }
        return d5 += Utilities.sqr(point.z - d4);
    }

    private static double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Point point) {
        double d15 = d13 - d2;
        double d16 = d14 - d3;
        if (d11 <= Math.PI ? (d15 * (d7 - d3) - (d6 - d2) * d16) * d12 > 0.0 && (d15 * (d5 - d3) - (d4 - d2) * d16) * d12 < 0.0 : !((d15 * (d7 - d3) - (d6 - d2) * d16) * d12 < 0.0) || !((d15 * (d5 - d3) - (d4 - d2) * d16) * d12 > 0.0)) {
            double d17 = Utilities.getLength(d15, d16);
            double d18 = d10 / d17;
            point.setLocation(d2 + d15 * d18, d3 + d16 * d18);
            return Utilities.sqr(d17 - d10);
        }
        if ((d15 * (d9 -= d3) - d16 * (d8 -= d2)) * d12 > 0.0) {
            point.setLocation(d4, d5);
            return Utilities.getDistanceSq(d13, d14, d4, d5);
        }
        point.setLocation(d6, d7);
        return Utilities.getDistanceSq(d13, d14, d6, d7);
    }

    @Override
    public double getDistanceSq(double d2, double d3) {
        return this.getNearestPoint(d2, d3, new Point());
    }

    @Override
    public double getDistanceSq(double d2, double d3, double d4) {
        return this.getNearestPoint(d2, d3, d4, new Point());
    }

    @Override
    public void addTo(Path2D path2D) {
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = this.mf + this.mf;
        double_.setArc(this.mk - this.mf, this.nd - this.mf, d2, d2, Math.toDegrees(-this.hl), Math.toDegrees(-this.gf * this.ma), 0);
        path2D.append(double_, true);
        if (this.dd != 0.0) {
            d2 = this.dd + this.dd;
            double_.setArc(this.ib - this.dd, this.ml - this.dd, d2, d2, Math.toDegrees(-this.jj), Math.toDegrees(-this.jb * this.hn), 0);
            path2D.append(double_, true);
        }
    }

    public String toString() {
        return "(" + this.n + ", " + this.k + ", " + this.m + ")-arc-(" + this.h + ", " + this.j + ", " + this.i + ")";
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        Point point = new Point();
        double d4 = MarkupSegmentArc.a(this.mk, this.nd, this.n, this.k, this.l, this.g, this.gd, this.nm, this.mf, this.gf, this.ma, d2, d3, point);
        Point point2 = new Point();
        double d5 = MarkupSegmentArc.a(this.ib, this.ml, this.l, this.g, this.h, this.j, this.ng, this.bn, this.dd, this.jb, this.hn, d2, d3, point2);
        if (d5 < d4) {
            double d6 = MarkupSegmentArc.a(point2.x, point2.y, this.ib, this.ml, this.jj, this.jb, this.hn);
            return (d6 * this.dd + this.b) / this.ih;
        }
        double d7 = MarkupSegmentArc.a(point.x, point.y, this.mk, this.nd, this.hl, this.gf, this.ma);
        return d7 * this.mf / this.ih;
    }

    private static double a(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11 = Math.atan2(d3 - d5, d2 - d4);
        if (d11 < 0.0) {
            d11 += Math.PI * 2;
        }
        if ((d10 = d6) < 0.0) {
            d10 += Math.PI * 2;
        }
        if (Math.abs(d11 - d10) < 1.0E-4) {
            d11 = d10;
        }
        if (d8 > 0.0) {
            if (d11 < d10) {
                d11 += Math.PI * 2;
            }
            d9 = d11 - d10;
        } else {
            if (d11 > d10) {
                d10 += Math.PI * 2;
            }
            d9 = d10 - d11;
        }
        if (d9 < 1.0E-4) {
            d9 = d7;
        }
        return d9;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        Point point2 = MarkupSegmentArc.getArgNearestPointOnRay2D(d2, d3, d4, d5, this.mk, this.nd, this.n, this.k, this.l, this.g, this.mf, this.gf, this.ma, point);
        Point point3 = MarkupSegmentArc.getArgNearestPointOnRay2D(d2, d3, d4, d5, this.ib, this.ml, this.l, this.g, this.h, this.j, this.dd, this.jb, this.hn, point);
        if (point2 != null && point3 != null) {
            double d6;
            double d7 = Utilities.getDistanceSq(d2, d3, point2.x, point2.y);
            if (d7 <= (d6 = Utilities.getDistanceSq(d2, d3, point3.x, point3.y))) {
                point.setLocation(point2);
                return Math.sqrt(d7);
            }
            point.setLocation(point3);
            return Math.sqrt(d6);
        }
        if (point2 != null) {
            point.setLocation(point2);
            return Utilities.getDistance(d2, d3, point2.x, point2.y);
        }
        if (point3 != null) {
            point.setLocation(point3);
            return Utilities.getDistance(d2, d3, point3.x, point3.y);
        }
        return -1.0;
    }

    @Deprecated
    @AnyLogicInternalAPI
    public static Point getArgNearestPointOnRay2D(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Point point) {
        double d15;
        double d16;
        double d17 = d4 - d2;
        double d18 = d5 - d3;
        double d19 = Math.sqrt(d17 * d17 + d18 * d18);
        double d20 = d17 / d19;
        double d21 = d20 * (d6 - d2) + (d16 = d18 / d19) * (d7 - d3);
        double d22 = d21 * d20 + d2;
        double d23 = Math.sqrt((d22 - d6) * (d22 - d6) + ((d15 = d21 * d16 + d3) - d7) * (d15 - d7));
        if (d23 == d12) {
            if (point == null) {
                point = new Point();
            }
            double d24 = d21 * d20 + d2;
            double d25 = d21 * d16 + d3;
            double d26 = d24 - d2;
            double d27 = d25 - d3;
            if (Math.signum(d26) - Math.signum(d17) != 0.0 && Math.signum(d27) - Math.signum(d18) != 0.0) {
                point.setLocation(d24, d25);
                return point;
            }
        } else if (d23 < d12) {
            boolean bl2;
            if (point == null) {
                point = new Point();
            }
            double d28 = Math.sqrt(d12 * d12 - d23 * d23);
            double d29 = (d21 - d28) * d20 + d2;
            double d30 = (d21 - d28) * d16 + d3;
            double d31 = (d21 + d28) * d20 + d2;
            double d32 = (d21 + d28) * d16 + d3;
            double d33 = d29 - d2;
            double d34 = d30 - d3;
            boolean bl3 = Math.signum(d33) + Math.signum(d17) != 0.0 && Math.signum(d34) + Math.signum(d18) != 0.0;
            boolean bl4 = bl2 = Math.signum(d33) + Math.signum(d17) != 0.0 && Math.signum(d34) + Math.signum(d18) != 0.0;
            if (!bl3 && !bl2) {
                return null;
            }
            if (bl3) {
                bl3 = MarkupSegmentArc.a(d6, d7, d8, d9, d10, d11, d13, d14, d29, d30, point);
            }
            if (bl2) {
                bl2 = MarkupSegmentArc.a(d6, d7, d8, d9, d10, d11, d13, d14, d31, d32, point);
            }
            if (bl3 && bl2) {
                double d35;
                double d36 = Utilities.getDistanceSq(d2, d3, d29, d30);
                if (d36 <= (d35 = Utilities.getDistanceSq(d2, d3, d31, d32))) {
                    point.setLocation(d29, d30);
                    return point;
                }
                point.setLocation(d31, d32);
                return point;
            }
            if (bl3) {
                point.setLocation(d29, d30);
                return point;
            }
            if (bl2) {
                point.setLocation(d31, d32);
                return point;
            }
        }
        return null;
    }

    private static boolean a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, Point point) {
        double d12 = d10 - d2;
        double d13 = d11 - d3;
        if (d8 <= Math.PI) {
            return (d12 * (d7 - d3) - (d6 - d2) * d13) * d9 > 0.0 && (d12 * (d5 - d3) - (d4 - d2) * d13) * d9 < 0.0;
        }
        return !((d12 * (d7 - d3) - (d6 - d2) * d13) * d9 < 0.0) || !((d12 * (d5 - d3) - (d4 - d2) * d13) * d9 > 0.0);
    }

    @AnyLogicInternalAPI
    public double getStartArcCenterX() {
        return this.mk;
    }

    @AnyLogicInternalAPI
    public double getStartArcCenterY() {
        return this.nd;
    }

    @AnyLogicInternalAPI
    public double getStartArcRadius() {
        return this.mf;
    }

    @AnyLogicInternalAPI
    public double getStartArcStartAngle() {
        return this.hl;
    }

    @AnyLogicInternalAPI
    public double getStartArcAngle() {
        return this.gf;
    }

    @AnyLogicInternalAPI
    public double getStartArcSign() {
        return this.ma;
    }

    @AnyLogicInternalAPI
    public double getEndArcCenterX() {
        return this.ib;
    }

    @AnyLogicInternalAPI
    public double getEndArcCenterY() {
        return this.ml;
    }

    @AnyLogicInternalAPI
    public double getEndArcRadius() {
        return this.dd;
    }

    @AnyLogicInternalAPI
    public double getEndArcStartAngle() {
        return this.jj;
    }

    @AnyLogicInternalAPI
    public double getEndArcAngle() {
        return this.jb;
    }

    @AnyLogicInternalAPI
    public double getEndArcSign() {
        return this.hn;
    }

    @AnyLogicInternalAPI
    public double getJoinX() {
        return this.l;
    }

    @AnyLogicInternalAPI
    public double getJoinY() {
        return this.g;
    }

    @AnyLogicInternalAPI
    public double getJoinZ() {
        return this.c;
    }

    @Override
    public List<Shape> convertToShapes() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        Arc2D.Double double_ = new Arc2D.Double();
        double d2 = this.mf + this.mf;
        double_.setArc(this.mk - this.mf, this.nd - this.mf, d2, d2, Math.toDegrees(-this.hl), Math.toDegrees(-this.gf * this.ma), 0);
        arrayList.add(double_);
        if (this.dd != 0.0) {
            double_ = new Arc2D.Double();
            d2 = this.dd + this.dd;
            double_.setArc(this.ib - this.dd, this.ml - this.dd, d2, d2, Math.toDegrees(-this.jj), Math.toDegrees(-this.jb * this.hn), 0);
            arrayList.add(double_);
        }
        return arrayList;
    }
}

