/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.ff;
import com.anylogic.engine.markup.MarkupSegment;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;

public final class MarkupSegmentLine
extends MarkupSegment {
    private static final long serialVersionUID = -8638921250218870731L;
    private double l;
    private double g;
    private double c;
    private double b;
    private double f;
    private double e;
    private double ac;

    public MarkupSegmentLine(double d2, double d3, double d4, double d5, double d6, double d7) {
        super(d2, d3, d4, d5, d6, d7);
        this.initialize();
    }

    public MarkupSegmentLine() {
    }

    @Override
    void a(double d2, Point point) {
        point.x = this.n + this.l * d2;
        point.y = this.k + this.g * d2;
        point.z = this.m + this.c * d2;
    }

    @Override
    void a(double d2, Position position) {
        this.a(d2, (Point)position);
        position.rotation = this.b;
        position.verticalRotation = this.f;
    }

    @Override
    public Position getStart(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.n, this.k, this.m, this.b, this.f);
        return position;
    }

    @Override
    public Position getEnd(Position position) {
        if (position == null) {
            position = new Position();
        }
        position.setPosition(this.h, this.j, this.i, this.b, this.f);
        return position;
    }

    @Override
    public final void initialize() {
        this.e = this.l = this.h - this.n;
        this.ac = this.g = this.j - this.k;
        this.c = this.i - this.m;
        this.d = Utilities.getLength(this.l, this.g);
        double d2 = this.a = this.c != 0.0 ? Utilities.getLength(this.l, this.g, this.c) : this.d;
        if (!(this.a > 0.0)) {
            throw ff.m("Segment should have non-zero length: " + this.toString());
        }
        this.l /= this.a;
        this.g /= this.a;
        this.c /= this.a;
        this.e /= this.d;
        this.ac /= this.d;
        this.b = Math.atan2(this.g, this.l);
        this.f = -Math.asin(this.c);
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.a();
        double d4 = (d2 - this.n) * this.e + (d3 - this.k) * this.ac;
        if (d4 <= 0.0) {
            point.x = this.n;
            point.y = this.k;
        } else if (d4 >= this.d) {
            point.x = this.h;
            point.y = this.j;
        } else {
            point.x = this.n + this.e * d4;
            point.y = this.k + this.ac * d4;
        }
        return Utilities.getDistanceSq(d2, d3, point.x, point.y);
    }

    @Override
    public double getDistanceSq(double d2, double d3) {
        this.a();
        double d4 = d2 - this.n;
        double d5 = d3 - this.k;
        double d6 = d4 * this.e + d5 * this.ac;
        double d7 = d6 <= 0.0 ? 0.0 : ((d6 = (d4 = this.h - d2) * this.e + (d5 = this.j - d3) * this.ac) <= 0.0 ? 0.0 : d6 * d6);
        double d8 = Utilities.getLengthSq(d4, d5) - d7;
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        return d8;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        this.a();
        double d5 = (d2 - this.n) * this.l + (d3 - this.k) * this.g + (d4 - this.m) * this.c;
        if (d5 <= 0.0) {
            point.x = this.n;
            point.y = this.k;
            point.z = this.m;
        } else if (d5 >= this.a) {
            point.x = this.h;
            point.y = this.j;
            point.z = this.i;
        } else {
            point.x = this.n + this.l * d5;
            point.y = this.k + this.g * d5;
            point.z = this.m + this.c * d5;
        }
        return Utilities.getDistanceSq(d2, d3, d4, point.x, point.y, point.z);
    }

    @Override
    public double getDistanceSq(double d2, double d3, double d4) {
        this.a();
        d3 -= this.k;
        double d5 = (d2 -= this.n) * this.l + (d3 -= this.m) * this.g + d4 * this.c;
        double d6 = Utilities.sqr(d5);
        double d7 = Utilities.getLengthSq(d2, d3, d4) - d6;
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        return d7;
    }

    @Override
    public double getNearestPointOnRay2D(double d2, double d3, double d4, double d5, Point point) {
        if (!Utilities.isRayIntersectingSegment(d2, d3, d4, d5, this.n, this.k, this.h, this.j)) {
            return -1.0;
        }
        double d6 = this.g / this.l;
        double d7 = (d5 - d3) / (d4 - d2);
        if (d6 == Double.POSITIVE_INFINITY) {
            d6 = 1.0E25;
        }
        if (d6 == Double.NEGATIVE_INFINITY) {
            d6 = -1.0E25;
        }
        if (d7 == Double.POSITIVE_INFINITY) {
            d7 = 1.0E25;
        }
        if (d7 == Double.NEGATIVE_INFINITY) {
            d7 = -1.0E25;
        }
        double d8 = this.k - d6 * this.n;
        double d9 = d3 - d7 * d2;
        if (d6 == d7) {
            double d10;
            double d11 = this.h - this.n;
            double d12 = this.j - this.k;
            double d13 = (d2 - this.n) * d11 + (d3 - this.k) * d12;
            if (d13 >= 0.0 && d13 <= Utilities.getLengthSq(d11, d12)) {
                point.setLocation(d2, d3);
                return 0.0;
            }
            double d14 = Utilities.getDistanceSq(d2, d3, this.n, this.k);
            if (d14 <= (d10 = Utilities.getDistanceSq(d2, d3, this.h, this.j))) {
                point.setLocation(this.n, this.k);
                return d14;
            }
            point.setLocation(this.h, this.j);
            return d10;
        }
        point.x = (d9 - d8) / (d6 - d7);
        point.y = Math.abs(this.h - this.n) > Math.abs(d4 - d2) ? d6 * point.x + d8 : d7 * point.x + d9;
        return Utilities.getDistanceSq(d2, d3, point.x, point.y);
    }

    @Override
    public double getOffsetOfPoint(double d2, double d3) {
        if (this.l != 0.0) {
            return Utilities.limit(0.0, (d2 - this.n) / this.l, this.a);
        }
        if (this.g != 0.0) {
            return Utilities.limit(0.0, (d3 - this.k) / this.g, this.a);
        }
        return 0.0;
    }

    @Override
    public void addTo(Path2D path2D) {
        path2D.lineTo(this.h, this.j);
    }

    public String toString() {
        return "(" + this.n + ", " + this.k + ", " + this.m + ")-line-(" + this.h + ", " + this.j + ", " + this.i + ")";
    }

    @Override
    public List<Shape> convertToShapes() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        arrayList.add(new Line2D.Double(this.n, this.k, this.h, this.j));
        return arrayList;
    }
}

