/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.ExtAgentContinuous;
import com.anylogic.engine.ExtAgentWithSpatialMetrics;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.UtilitiesCollection;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.markup.AbstractMarkup;
import com.anylogic.engine.markup.AbstractNetwork;
import com.anylogic.engine.markup.ContinuousShortestPathData;
import com.anylogic.engine.markup.Ground;
import com.anylogic.engine.markup.INetworkMarkupElement;
import com.anylogic.engine.markup.INode;
import com.anylogic.engine.markup.MarkupShape;
import com.anylogic.engine.markup.NetworkMarkupElement;
import com.anylogic.engine.markup.Node;
import com.anylogic.engine.markup.PalletRack;
import com.anylogic.engine.markup.Path;
import com.anylogic.engine.markup.ShortestPathData;
import com.anylogic.engine.markup.d;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Network
extends AbstractNetwork<Node, Path, Agent> {
    private static final long serialVersionUID = -6308646393905078831L;
    private List<PalletRack> b = new ArrayList<PalletRack>();
    @AnyLogicCustomSerialization
    private transient Ground f;
    private double e = 0.0;
    private ShapeDrawMode ac;

    public Network(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2) {
        this(agent, string, shapeDrawMode, null, d2);
    }

    Network(Ground ground) {
        this((Agent)ground.getOwner(), String.valueOf(ground.getName()) + ".network", ground.getDrawMode(), ground, ground.getZ());
    }

    private Network(Agent agent, String string, ShapeDrawMode shapeDrawMode, Ground ground, double d2) {
        super(agent, string);
        this.ac = shapeDrawMode;
        this.f = ground;
        this.e = d2;
        this.j = new ArrayList();
        this.i = new ArrayList();
    }

    public Network(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl2, boolean bl3) {
        super(agent, string, bl2, bl3);
        this.e = d2;
        this.j = new ArrayList();
        this.i = new ArrayList();
    }

    public Network(Agent agent, String string, ShapeDrawMode shapeDrawMode, double d2, boolean bl2, boolean bl3, NetworkMarkupElement ... networkMarkupElementArray) {
        super(agent, string, bl2, bl3);
        this.ac = shapeDrawMode;
        this.e = d2;
        this.j = new ArrayList(networkMarkupElementArray.length / 2);
        this.i = new ArrayList(networkMarkupElementArray.length);
        this.addAll(networkMarkupElementArray);
        this.initialize();
    }

    @Override
    Stream<? extends AbstractMarkup> h() {
        return UtilitiesCollection.streamOfElements(this.nodes(), this.paths(), this.b);
    }

    public void addAll(NetworkMarkupElement ... networkMarkupElementArray) {
        NetworkMarkupElement[] networkMarkupElementArray2 = networkMarkupElementArray;
        int n2 = networkMarkupElementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            NetworkMarkupElement networkMarkupElement = networkMarkupElementArray2[n3];
            if (networkMarkupElement instanceof Node) {
                this.add((Node)networkMarkupElement);
            } else if (networkMarkupElement instanceof Path) {
                this.add((Path)networkMarkupElement);
            } else if (networkMarkupElement instanceof PalletRack) {
                this.add((PalletRack)networkMarkupElement);
            }
            ++n3;
        }
    }

    public void setDrawMode(ShapeDrawMode shapeDrawMode) {
        if (shapeDrawMode == null) {
            throw new RuntimeException(String.format(hg.ihf, "drawMode"));
        }
        if (shapeDrawMode == this.ac) {
            return;
        }
        if (this.ac != null) {
            throw new RuntimeException(String.format(hg.hkm, new Object[]{this.ac, shapeDrawMode, this.getName()}));
        }
        this.ac = shapeDrawMode;
    }

    public ShapeDrawMode getDrawMode() {
        if (this.f != null) {
            return this.f.getDrawMode();
        }
        if (this.ac == null) {
            this.ac = MarkupShape.nm;
        }
        return this.ac;
    }

    public double getZ() {
        return this.getGround() == null ? this.e : this.getGround().getZ();
    }

    @Override
    public void add(PalletRack palletRack) {
        this.m();
        this.a(palletRack, this.b.size());
        this.b.add(palletRack);
    }

    @Override
    Path a(Node node, Path path) {
        return node.k(path);
    }

    @Override
    int a(Path path) {
        return path.bl;
    }

    @Override
    int a(Node node) {
        return node.bl;
    }

    @Override
    void a(Node node, int n2) {
        node.bl = n2;
    }

    @Override
    double a(Node node, Path path, Path path2, Point point, Point point2) {
        return node.a(path, path2, point, point2);
    }

    @Override
    void a(INetworkMarkupElement iNetworkMarkupElement, int n2) {
        if (iNetworkMarkupElement instanceof NetworkMarkupElement) {
            NetworkMarkupElement networkMarkupElement = (NetworkMarkupElement)iNetworkMarkupElement;
            networkMarkupElement.setOwner((Agent)this.a);
            networkMarkupElement.a(this, n2);
            networkMarkupElement.h();
        }
    }

    d<Node> n(Node node) {
        return node.gd();
    }

    @Override
    public Agent getSpace() {
        return (Agent)this.getOwner();
    }

    public Ground getGround() {
        return this.f;
    }

    public Node getNearestNode(double d2, double d3, double d4) {
        Point point = new Point();
        double d5 = Double.POSITIVE_INFINITY;
        Node node = null;
        for (Node node2 : this.j) {
            double d6 = node2.getNearestPoint(d2, d3, d4, point);
            if (!(d6 < d5)) continue;
            d5 = d6;
            node = node2;
        }
        return node;
    }

    @Override
    ShortestPathData<Node, Path> i() {
        return new ContinuousShortestPathData();
    }

    @Override
    public double getPlainDistance(Point point, Point point2) {
        return point.distance(point2);
    }

    @Override
    protected double a(double d2, LengthUnits lengthUnits) {
        this.d();
        return this.getSpace().getScale().toLengthUnits(d2, lengthUnits);
    }

    @Override
    protected double n(double d2, LengthUnits lengthUnits) {
        this.d();
        return this.getSpace().getScale().toPixels(d2, lengthUnits);
    }

    @Override
    @AnyLogicInternalAPI
    public final Class<? extends ExtAgentWithSpatialMetrics> getCompatibleAgentExtensionClass() {
        return ExtAgentContinuous.class;
    }

    @Override
    /* synthetic */ int n(INode iNode) {
        return this.a((Node)iNode);
    }

    @Override
    /* synthetic */ d k(INode iNode) {
        return this.n((Node)iNode);
    }
}

