/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicCustomProposalType;
import com.anylogic.engine.AnyLogicCustomSerialization;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.LengthUnits;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Presentable;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.y.eb;
import com.anylogic.engine.internal.y.l;
import com.anylogic.engine.markup.AbstractRoadSidePart;
import com.anylogic.engine.markup.CircularCurveImpl;
import com.anylogic.engine.markup.MarkupSegment;
import com.anylogic.engine.markup.MarkupSegmentLine;
import com.anylogic.engine.markup.ParkingLotDataSource;
import com.anylogic.engine.markup.ParkingLotType;
import com.anylogic.engine.markup.Road;
import com.anylogic.engine.markup.RoadDrivingDirection;
import com.anylogic.engine.markup.a;
import com.anylogic.engine.markup.j;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ParkingLot
extends AbstractRoadSidePart {
    private static final long serialVersionUID = -5501833494893390820L;
    private ParkingLotType g = ParkingLotType.PARKING_LOT_PARALLEL;
    private int c = 5;
    private final a b = new a(5.0, LengthUnits.METER);
    private final a f = new a(2.5, LengthUnits.METER);
    @AnyLogicCustomSerialization
    private transient ParkingLotDataSource e;
    private List<MarkupSegment> ac;
    private List<MarkupSegment> mk;
    private transient Path2D bf;
    private transient Path2D bl;

    private void ac() {
        if (!this.f.a()) {
            this.a(hg.dhh, "parkingSpaceWidth", this.f);
        }
        if (!this.b.a()) {
            this.a(hg.dhh, "parkingSpaceLength", this.b);
        }
        if (this.c <= 0) {
            this.a(hg.dhh, "nSpaces", this.c);
        }
        if (this.g == null) {
            this.a(hg.ihf, "parkingType");
        }
    }

    public ParkingLot() {
    }

    public ParkingLot(Road road, ShapeDrawMode shapeDrawMode, boolean bl2, boolean bl3, double d2, ParkingLotType parkingLotType, int n2, double d3, double d4) {
        super(road, shapeDrawMode, bl2, bl3, d2);
        this.g = parkingLotType;
        this.c = n2;
        this.f.n(d3);
        this.b.n(d4);
        this.initialize();
    }

    @AnyLogicInternalAPI
    public void setDataSource(ParkingLotDataSource parkingLotDataSource) {
        if (parkingLotDataSource == null) {
            this.a(hg.ihf, "dataSource");
        }
        if (parkingLotDataSource == this.e) {
            return;
        }
        if (this.e != null) {
            this.a(hg.mjl, parkingLotDataSource);
        }
        this.e = parkingLotDataSource;
    }

    public int nFree() {
        return this.e == null ? this.nSpaces() : this.e.nFree();
    }

    public int randomFreeSpaceIndex() {
        return this.e == null ? this.gf.uniform_discr(this.nSpaces() - 1) : this.e.randomFreeSpaceIndex();
    }

    public Agent getCarOnSpace(int n2) {
        return this.e == null ? null : this.e.getCarOnSpace(n2);
    }

    public int nCars() {
        return this.e == null ? 0 : this.e.nCars();
    }

    public List<Agent> getCars() {
        return this.e == null ? Collections.emptyList() : this.e.getCars();
    }

    public int[] getFreeSpaceIndexes() {
        if (this.e == null) {
            int[] nArray = new int[this.nSpaces()];
            int n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = n2;
                ++n2;
            }
            return nArray;
        }
        return this.e.getFreeSpaceIndexes();
    }

    @Override
    void g_() {
        super.g_();
        this.ac();
    }

    @Override
    protected void i() {
        double d2;
        double d3;
        super.i();
        switch (this.g) {
            case PARKING_LOT_PARALLEL: {
                d3 = this.getParkingSpaceWidth();
                d2 = this.getParkingSpaceLength();
                break;
            }
            case PARKING_LOT_PERPENDICULAR: {
                d3 = this.getParkingSpaceLength();
                d2 = this.getParkingSpaceWidth();
                break;
            }
            default: {
                throw this.a(hg.dhh, new Object[]{"parkingType", this.g});
            }
        }
        int n2 = this.l ? this.i.getForwardLanesCount() : this.i.getBackwardLanesCount();
        double d4 = this.l ? 1 : -1;
        double d5 = this.n.getDrivingDirection() == RoadDrivingDirection.ROAD_RIGHT_HAND ? 1 : -1;
        double d6 = d5 * d4;
        double d7 = this.n.getLaneWidth();
        double d8 = (double)this.c * d2;
        double d9 = d6 * d3;
        double d10 = d6 * (d7 * (double)n2 + com.anylogic.engine.markup.j.a(this.i) / 2.0);
        double d11 = com.anylogic.engine.markup.j.a(this.i.getAxisMarkupSegments(), d10);
        CircularCurveImpl circularCurveImpl = new CircularCurveImpl(this.i.getAxisMarkupSegments());
        Point point = circularCurveImpl.getPointAtOffset(com.anylogic.engine.markup.j.a(circularCurveImpl, this.getOffset()), null);
        double d12 = ParkingLot.a((Iterable<? extends MarkupSegment>)d11, point);
        if (!this.l) {
            d12 -= d8;
        }
        List<MarkupSegment> list = com.anylogic.engine.markup.j.a((List<MarkupSegment>)d11, d12, d12 + d8);
        Object object = com.anylogic.engine.markup.j.a(list, d9);
        object = com.anylogic.engine.markup.j.a((List<MarkupSegment>)object);
        Position position = list.get(0).getStart(null);
        Position position2 = list.get(list.size() - 1).getEnd(null);
        Position position3 = ((MarkupSegment)object.get(0)).getStart(null);
        Position position4 = ((MarkupSegment)object.get(object.size() - 1)).getEnd(null);
        MarkupSegmentLine markupSegmentLine = com.anylogic.engine.markup.j.m(position4, position);
        MarkupSegmentLine markupSegmentLine2 = com.anylogic.engine.markup.j.m(position2, position3);
        this.ac = new ArrayList<MarkupSegment>();
        this.mk = new ArrayList<MarkupSegment>();
        this.ac.addAll(list);
        com.anylogic.engine.markup.j.a(this.ac, markupSegmentLine2);
        this.ac.addAll((Collection<MarkupSegment>)object);
        com.anylogic.engine.markup.j.a(this.ac, markupSegmentLine);
        CircularCurveImpl circularCurveImpl2 = new CircularCurveImpl(list);
        int n3 = 1;
        while (n3 < this.c) {
            double d13 = (double)n3 * d2;
            Position position5 = circularCurveImpl2.getPositionAtOffset(com.anylogic.engine.markup.j.a(circularCurveImpl2, d13), null);
            Position position6 = position5.clone(null);
            Position position7 = position5.clone(null);
            double d14 = position5.rotation + 1.5707963267948966;
            position7.x = position6.x + d9 * Math.cos(d14);
            position7.y = position6.y + d9 * Math.sin(d14);
            com.anylogic.engine.markup.j.a(this.mk, com.anylogic.engine.markup.j.m(position6, position7));
            ++n3;
        }
        this.mk.addAll(list);
    }

    public ParkingLotType getParkingType() {
        return this.g;
    }

    public void setParkingType(ParkingLotType parkingLotType) {
        this.j();
        this.g = parkingLotType;
    }

    public int nSpaces() {
        return this.c;
    }

    public void setNSpaces(int n2) {
        this.j();
        this.c = n2;
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.PIXEL)
    public double getParkingSpaceLength() {
        return this.b.a(this);
    }

    public double getParkingSpaceLength(LengthUnits lengthUnits) {
        return this.b.a(this, lengthUnits);
    }

    public void setParkingSpaceLength(double d2) {
        this.j();
        this.b.a(d2);
    }

    public void setParkingSpaceLength(double d2, LengthUnits lengthUnits) {
        this.j();
        this.b.a(d2, lengthUnits);
    }

    @AnyLogicCustomProposalType(value=AnyLogicCustomProposalType.Label.PIXEL)
    public double getParkingSpaceWidth() {
        return this.f.a(this);
    }

    public double getParkingSpaceWidth(LengthUnits lengthUnits) {
        return this.f.a(this, lengthUnits);
    }

    public void setParkingSpaceWidth(double d2) {
        this.j();
        this.f.a(d2);
    }

    public void setParkingSpaceWidth(double d2, LengthUnits lengthUnits) {
        this.j();
        this.f.a(d2, LengthUnits.METER);
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        if (!this.a(bl2)) {
            return;
        }
        Paint paint = com.anylogic.engine.markup.j.k(this.n);
        Paint paint2 = com.anylogic.engine.markup.j.n(this.n);
        if (paint != null) {
            if (this.bf == null) {
                this.bf = com.anylogic.engine.internal.presentation.e.a(this.ac);
            }
            if (this.bl == null) {
                this.bl = com.anylogic.engine.internal.presentation.e.a(this.mk, false);
            }
            float f2 = (float)com.anylogic.engine.markup.j.m(this.n);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, f2, Presentable.LINE_STYLE_SOLID, true);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, paint);
            graphics2D.fill(this.bf);
            if (paint2 != null) {
                com.anylogic.engine.internal.presentation.e.a(graphics2D, paint2);
                graphics2D.draw(this.bl);
            }
        }
    }

    @Override
    l b() {
        Paint paint = com.anylogic.engine.markup.j.k(this.n);
        Paint paint2 = com.anylogic.engine.markup.j.n(this.n);
        double d2 = 0.0;
        float f2 = (float)com.anylogic.engine.markup.j.m(this.n);
        return new eb(this, d2, this.ac, this.mk, f2, paint, paint2);
    }
}

