/*
 * Decompiled with CFR 0.152.
 */
package com.anylogic.engine.markup;

import com.anylogic.engine.Agent;
import com.anylogic.engine.AnyLogicInternalAPI;
import com.anylogic.engine.Point;
import com.anylogic.engine.Position;
import com.anylogic.engine.Utilities;
import com.anylogic.engine.internal.hg;
import com.anylogic.engine.internal.presentation.e;
import com.anylogic.engine.internal.y.af;
import com.anylogic.engine.internal.y.db;
import com.anylogic.engine.internal.y.l;
import com.anylogic.engine.markup.AreaNode;
import com.anylogic.engine.markup.Attractor;
import com.anylogic.engine.markup.PositionChoiceMode;
import com.anylogic.engine.markup.Slope;
import com.anylogic.engine.presentation.LineStyle;
import com.anylogic.engine.presentation.Panel;
import com.anylogic.engine.presentation.ShapeDrawMode;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Random;

public class PolygonalNode
extends AreaNode {
    private static final long serialVersionUID = -2294940773211731233L;
    protected double[] kh;
    protected double[] kn;
    private double ck;
    private double bh;
    private double di;
    private double bm;
    private Path2D.Double gn;
    private double kc;
    private Position[] bi = null;
    private static final int ne = 1000;
    private static final int nl = 46337;
    private static final int mn = 46327;

    public PolygonalNode() {
    }

    public PolygonalNode(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, double d2, double d3, double d4, double[] dArray, double[] dArray2, Slope slope, Paint paint, Paint paint2, double d5, LineStyle lineStyle, PositionChoiceMode positionChoiceMode, Attractor ... attractorArray) {
        super(agent, shapeDrawMode, bl2, d2, d3, d4, slope, paint, paint2, d5, lineStyle, positionChoiceMode, attractorArray);
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.a(hg.dhh, "dx/dy/dz", hg.fdi);
        }
        this.kh = dArray;
        this.kn = dArray2;
        this.initialize();
    }

    public PolygonalNode(Agent agent, ShapeDrawMode shapeDrawMode, boolean bl2, double d2, double d3, double d4, double[] dArray, double[] dArray2, Paint paint, Paint paint2, double d5, LineStyle lineStyle, PositionChoiceMode positionChoiceMode, Attractor ... attractorArray) {
        super(agent, shapeDrawMode, bl2, d2, d3, d4, null, paint, paint2, d5, lineStyle, positionChoiceMode, attractorArray);
        if (dArray == null || dArray2 == null || dArray.length == 0 || dArray.length != dArray2.length) {
            throw this.a(hg.dhh, "dx/dy/dz", hg.fdi);
        }
        this.kh = dArray;
        this.kn = dArray2;
        this.initialize();
    }

    public void addVertex(double d2, double d3) {
        int n2;
        int n3;
        this.j();
        if (this.kh == null) {
            this.kh = new double[11];
            this.kh[0] = 0.0;
        }
        if ((n3 = (n2 = (int)(this.kh[0] = this.kh[0] + 1.0)) * 2 + 1) > this.kh.length) {
            double[] dArray = this.kh;
            this.kh = new double[n2 * 4 + 1];
            System.arraycopy(dArray, 0, this.kh, 0, (n2 - 1) * 2 + 1);
        }
        n3 -= 2;
        this.kh[n3++] = d2;
        this.kh[n3++] = d3;
    }

    @Override
    void g_() {
        int n2;
        super.g_();
        if (this.kn == null) {
            if (this.kh == null || this.kh[0] < 3.0) {
                throw this.error("Error: node polygon should have at least 3 vertices");
            }
            n2 = (int)this.kh[0];
            double[] dArray = this.kh;
            this.kh = new double[n2];
            this.kn = new double[n2];
            int n3 = 1;
            int n4 = 0;
            while (n4 < n2) {
                this.kh[n4] = dArray[n3++];
                this.kn[n4] = dArray[n3++];
                ++n4;
            }
        }
        if ((n2 = this.kh.length) < 3) {
            throw this.error("Error: node polygon should have at least 3 vertices");
        }
        if (PolygonalNode.a(this.kh, this.kn, n2)) {
            throw this.error("Error: node polygon is self-intersecting: its outline intersects itself");
        }
        this.gn = new Path2D.Double(0, n2);
        this.ck = this.di = this.kh[0];
        this.bh = this.bm = this.kn[0];
        this.gn.moveTo(this.kh[0], this.kn[0]);
        this.kc = this.kh[n2 - 1] * this.kn[0] - this.kh[0] * this.kn[n2 - 1];
        int n5 = 1;
        while (n5 < n2) {
            double d2 = this.kh[n5];
            double d3 = this.kn[n5];
            this.gn.lineTo(d2, d3);
            if (d2 < this.ck) {
                this.ck = d2;
            }
            if (d2 > this.di) {
                this.di = d2;
            }
            if (d3 < this.bh) {
                this.bh = d3;
            }
            if (d3 > this.bm) {
                this.bm = d3;
            }
            this.kc += this.kh[n5 - 1] * this.kn[n5] - this.kh[n5] * this.kn[n5 - 1];
            ++n5;
        }
        if (this.kc < 0.0) {
            this.kc = -this.kc;
        }
        if (!(this.kc > 0.0)) {
            throw this.error("Error: node polygon has zero area");
        }
        this.kc /= 2.0;
        this.gn.closePath();
    }

    private static boolean a(double[] dArray, double[] dArray2, int n2) {
        if (n2 <= 3) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray[n3];
            double d3 = dArray2[n3];
            double d4 = dArray[(n3 + 1) % n2];
            double d5 = dArray2[(n3 + 1) % n2];
            int n4 = n3 + 2;
            int n5 = n3 == 0 ? n2 - 1 : n2;
            while (n4 < n5) {
                double d6 = dArray[n4];
                double d7 = dArray2[n4];
                double d8 = dArray[(n4 + 1) % n2];
                double d9 = dArray2[(n4 + 1) % n2];
                if (Line2D.linesIntersect(d2, d3, d4, d5, d6, d7, d8, d9)) {
                    return true;
                }
                ++n4;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public Point randomPointInside(Random random, Point point) {
        double d2;
        double d3;
        this.h();
        if (point == null) {
            point = new Point();
        }
        while (!this.gn.contains(d3 = Utilities.uniform(this.ck, this.di, random), d2 = Utilities.uniform(this.bh, this.bm, random))) {
        }
        point.setLocation(d3, d2);
        this.n(point);
        return point;
    }

    private void n(Point point) {
        point.z = this.a(point.x, point.y);
        point.x += this.a;
        point.y += this.n;
    }

    @Override
    public double getNearestPoint(double d2, double d3, Point point) {
        this.h();
        double d4 = d2 - this.a;
        double d5 = d3 - this.n;
        if (this.gn.contains(d4, d5)) {
            point.setLocation(d4, d5);
            this.n(point);
            return 0.0;
        }
        int n2 = this.kh.length;
        Utilities.getNearestPointOnSegment(point, this.kh[n2 - 1], this.kn[n2 - 1], this.kh[0], this.kn[0], d4, d5);
        double d6 = Utilities.getDistanceSq(d4, d5, point.x, point.y);
        Point point2 = new Point();
        int n3 = 1;
        while (n3 < n2) {
            Utilities.getNearestPointOnSegment(point2, this.kh[n3 - 1], this.kn[n3 - 1], this.kh[n3], this.kn[n3], d4, d5);
            double d7 = Utilities.getDistanceSq(d4, d5, point2.x, point2.y);
            if (d7 < d6) {
                point.setLocation(point2);
                d6 = d7;
            }
            ++n3;
        }
        this.n(point);
        return d6;
    }

    @Override
    public double getNearestPoint(double d2, double d3, double d4, Point point) {
        double d5 = this.getNearestPoint(d2, d3, point);
        return d5 + Utilities.sqr(d4 - this.i);
    }

    private Position[] m(int n2) {
        Position[] positionArray;
        if (n2 <= 0 || n2 > 1000) {
            n2 = 1000;
        }
        if ((positionArray = this.bi) == null || positionArray.length < n2) {
            double d2;
            positionArray = new Position[n2];
            int n3 = 0;
            while (n3 < positionArray.length) {
                positionArray[n3] = new Position();
                ++n3;
            }
            double d3 = this.di - this.ck;
            double d4 = this.bm - this.bh;
            double d5 = d3 / d4;
            double d6 = (double)n2 * (d3 * d4 / this.kc);
            double d7 = Math.sqrt(d6 / d5);
            double d8 = d5 * d7;
            double d9 = d3 / d8;
            double d10 = d4 / d7;
            int n4 = 0;
            double d11 = this.bh + d10 * 0.5;
            block1: while (d11 < this.bm) {
                d2 = this.ck + d9 * 0.5;
                while (d2 < this.di) {
                    if (this.gn.contains(d2, d11)) {
                        positionArray[n4].setLocation(d2, d11);
                        if (++n4 >= positionArray.length) break block1;
                    }
                    d2 += d9;
                }
                d11 += d10;
            }
            if (n4 < positionArray.length) {
                d11 = this.bh + d10;
                block3: while (d11 < this.bm) {
                    d2 = this.ck + d9;
                    while (d2 < this.di) {
                        if (this.gn.contains(d2, d11)) {
                            positionArray[n4].setLocation(d2, d11);
                            if (++n4 >= positionArray.length) break block3;
                        }
                        d2 += d9;
                    }
                    d11 += d10;
                }
                while (n4 < positionArray.length) {
                    while (!this.gn.contains(d11 = this.gf.uniform(this.ck, this.di), d2 = this.gf.uniform(this.bh, this.bm))) {
                    }
                    positionArray[n4++].setLocation(d11, d2);
                }
            }
            Position[] positionArray2 = positionArray;
            int n5 = positionArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Position position = positionArray2[n6];
                this.n(position);
                position.verticalRotation = Double.NaN;
                position.rotation = Double.NaN;
                ++n6;
            }
            this.bi = positionArray;
        }
        return positionArray;
    }

    static int a(int n2, int n3, int n4) {
        return (int)((long)n2 * 46337L / (long)n3 * 46327L % 46337L * (long)n4 / 46337L);
    }

    @Override
    public Position getPosition(int n2, int n3, Position position) {
        if (n2 < 0) {
            n2 = 0;
        }
        switch (this.ac) {
            case POSITION_CHOICE_ARRANGED: {
                if (n3 < 1) {
                    n3 = 1;
                }
                Position[] positionArray = this.m(n3);
                position = positionArray[n2 % positionArray.length].clone(position);
                return position;
            }
        }
        return super.getPosition(n2, n3, position);
    }

    public double getXMin() {
        return this.a + this.ck;
    }

    public double getXMax() {
        return this.a + this.di;
    }

    public double getYMin() {
        return this.n + this.bh;
    }

    public double getYMax() {
        return this.n + this.bm;
    }

    public int getNPoints() {
        return this.kh.length;
    }

    public double getPointDx(int n2) {
        return this.kh[n2];
    }

    public double getPointDy(int n2) {
        return this.kn[n2];
    }

    @Override
    public boolean contains(double d2, double d3) {
        this.h();
        return this.ck <= d2 && d2 <= this.di && this.bh <= d3 && d3 <= this.bm && this.gn.contains(d2 -= this.a, d3 -= this.n);
    }

    @Override
    public void draw(Panel panel, Graphics2D graphics2D, AffineTransform affineTransform, boolean bl2) {
        double d2;
        Rectangle rectangle;
        this.h();
        if (!this.a(bl2)) {
            return;
        }
        if (this.mi == null && (this.b == null || this.f == 0.0f)) {
            return;
        }
        com.anylogic.engine.internal.presentation.e.a(graphics2D, affineTransform);
        graphics2D.translate(this.a, this.n);
        if (panel != null && panel.isAnimationParameterEnabled(12) && (rectangle = com.anylogic.engine.internal.presentation.e.a(graphics2D)) != null && !rectangle.intersects(this.ck - (double)this.f, this.bh - (double)this.f, this.di - this.ck + (d2 = (double)(this.f + this.f)), this.bm - this.bh + d2)) {
            return;
        }
        if (this.mi != null) {
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.mi);
            graphics2D.fill(this.gn);
        }
        if (this.b != null && this.f > 0.0f) {
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.b);
            com.anylogic.engine.internal.presentation.e.a(graphics2D, this.f, this.e, true);
            graphics2D.draw(this.gn);
        }
    }

    @Override
    @AnyLogicInternalAPI
    public void update3D(Panel panel, boolean bl2) {
        if (!this.getDrawMode().has3D()) {
            return;
        }
        this.a(panel, bl2);
    }

    @Override
    int f_() {
        return super.f_() + 1;
    }

    @Override
    l[] g() {
        l[] lArray = super.g();
        int n2 = super.f_();
        lArray[n2] = this.ib();
        return lArray;
    }

    private l ib() {
        int n2 = this.kh.length;
        Paint paint = n2 >= 3 ? this.mi : null;
        double d2 = 0.0;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this.kh[n4] != d3 || this.kn[n4] != d4) {
                d3 = this.kh[n4];
                d4 = this.kn[n4];
                dArray[n3] = this.kh[n4];
                dArray2[n3] = -this.kn[n4];
                dArray3[n3] = d2;
                ++n3;
            }
            ++n4;
        }
        n4 = 1;
        if (n4 != 0 && n3 >= 2 && dArray[0] == dArray[n3 - 1] && dArray2[0] == dArray2[n3 - 1]) {
            --n3;
        }
        Boolean bl2 = null;
        if (paint != null) {
            if (bl2 == null) {
                boolean bl3 = true;
                if (n2 > 3) {
                    int n5 = 0;
                    block1: while (n5 < n2) {
                        double d5 = dArray[n5];
                        double d6 = dArray2[n5];
                        int n6 = (n5 + 1) % n2;
                        double d7 = dArray[n6];
                        double d8 = dArray2[n6];
                        int n7 = n5 + 2;
                        int n8 = n5 != 0 ? n2 : n2 - 1;
                        while (n7 < n8) {
                            int n9 = (n7 + 1) % n2;
                            if (Line2D.linesIntersect(d5, d6, d7, d8, dArray[n7], dArray2[n7], dArray[n9], dArray2[n9])) {
                                bl3 = false;
                                break block1;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
                bl2 = bl3;
            }
            if (!bl2.booleanValue()) {
                paint = null;
            }
        }
        double d9 = 0.0;
        return new af(this, n2, dArray, dArray2, dArray3, true, this.f, d9, this.b, paint);
    }

    @Override
    void a(db db2) {
        super.a(db2);
        if (this.n(ha)) {
            db2.a(this.ib());
        }
    }
}

